/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.ccc;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.ccc.DivergenceSegmentsReportTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.ccc.CCCFilesDivergenceReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.ccc.CCCFilesDivergenceReportTestBase;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class Bug2550Test
extends CCCFilesDivergenceReportTestBase {
    @Test
    public void testExchange() throws Exception {
        this.createProfiles();
        this.createObjects();
        HashMap<String, Object> data = new HashMap<String, Object>();
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        DivergenceReportParameters params = new DivergenceReportParameters();
        params.setPeriodBegin(cldr.getTime());
        cldr.add(2, 12);
        params.setPeriodEnd(cldr.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        params.setSupplier(new EntityReference(this.vendorContainer));
        params.setExcludePaperTickets(false);
        data.put("key-report-params", params);
        CCCFilesDivergenceReportPrepareHandler handler = new CCCFilesDivergenceReportPrepareHandler();
        List<List<DivergenceSegmentsReportTicket>> filteredData = handler.getData(data, null);
        Assert.assertEquals((long)0L, (long)filteredData.size());
    }

    private void createObjects() throws Exception {
        int segmentCnt = 2;
        CCCExchangeDocument doc = this.createDoc("0000001");
        this.addCCCFile(doc, segmentCnt);
        EntityContainer<BookingFile> ctr = this.addProduct(doc);
        Product product = (Product)((Reservation)((BookingFile)ctr.getEntity()).getReservations().get(0)).getProducts().get(0);
        Product exchangeProduct = new Product();
        AirProductHelper.copy((Product)product, (Product)exchangeProduct, (boolean)true);
        exchangeProduct.setPreviousProduct(product);
        product.setNextProduct(exchangeProduct);
        exchangeProduct.setStatus(ProductStatus.EXCHANGE);
        Product newSell = new Product();
        AirProductHelper.copy((Product)product, (Product)newSell, (boolean)true);
        newSell.setSystemNumber("0000002");
        newSell.setPreviousProduct(exchangeProduct);
        exchangeProduct.setNextProduct(newSell);
        EntityStorage.get().save(ctr, false);
        CCCExchangeDocument doc2 = this.createDoc("0000001");
        doc2.setAgsTax(BigDecimal.ZERO);
        doc2.setCommissionValue(BigDecimal.ZERO);
        doc2.setEquivalentFare(BigDecimal.ZERO);
        doc2.setPenalty(BigDecimal.ZERO);
        doc2.setTchTax(BigDecimal.ZERO);
        doc2.setTransaction(TransactionType.EXCHANGE);
        this.addCCCFile(doc2, segmentCnt);
        doc2 = this.createDoc("0000002");
        doc2.setAgsTax(BigDecimal.ZERO);
        doc2.setCommissionValue(BigDecimal.ZERO);
        doc2.setEquivalentFare(BigDecimal.ZERO);
        doc2.setPenalty(BigDecimal.ZERO);
        doc2.setTchTax(BigDecimal.ZERO);
        doc2.setTransaction(TransactionType.SELL);
        this.addCCCFile(doc2, segmentCnt);
    }
}

