/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.ccc;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocument;
import com.gridnine.xtrip.common.reports.model.DivergenceReportDocument;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.ccc.DivergenceSegmentsReportTicket;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.reports.prepare.salesreports.ccc.CCCFilesDivergenceReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.ccc.CCCFilesDivergenceReportTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CCCFilesDivergenceReportTest
extends CCCFilesDivergenceReportTestBase {
    @Test
    public void getDataTest() {
        try {
            this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
            this.createProfiles();
            List<String> divergenceSystemNumbers = this.createObjects();
            HashMap<String, Object> data = new HashMap<String, Object>();
            Calendar cldr = Calendar.getInstance();
            cldr.setTime(this.issueDate);
            cldr.add(2, -6);
            DivergenceReportParameters params = new DivergenceReportParameters();
            params.setPeriodBegin(cldr.getTime());
            cldr.add(2, 12);
            params.setPeriodEnd(cldr.getTime());
            params.setAgency(new EntityReference(this.agencyContainer));
            data.put("key-report-params", params);
            CCCFilesDivergenceReportPrepareHandler handler = new CCCFilesDivergenceReportPrepareHandler();
            List<List<DivergenceSegmentsReportTicket>> filteredData = handler.getData(data, null);
            Assert.assertEquals((String)("\u0412 \u043e\u0442\u0447\u0451\u0442\u0435 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 " + filteredData.size() + " \u043f\u0430\u0440 \u0431\u0438\u043b\u0435\u0442/CCC-\u0444\u0430\u0439\u043b, \u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c " + divergenceSystemNumbers.size()), (long)divergenceSystemNumbers.size(), (long)filteredData.size());
            for (List<DivergenceSegmentsReportTicket> list : filteredData) {
                DivergenceSegmentsReportTicket ticket = list.get(0);
                if (ticket == null || divergenceSystemNumbers.contains(ticket.getTicketNumber())) continue;
                Assert.fail((String)("\u0412 \u043e\u0442\u0447\u0451\u0442\u0435 \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u043e \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0431\u0438\u043b\u0435\u0442/CCC-\u0444\u0430\u0439\u043b \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c " + ticket.getTicketNumber()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Exception throws: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void renderReportTest() {
        try {
            this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
            this.createProfiles();
            this.createObjects();
            HashMap<String, Object> data = new HashMap<String, Object>();
            Calendar cldr = Calendar.getInstance();
            cldr.setTime(this.issueDate);
            cldr.add(2, -6);
            DivergenceReportParameters params = new DivergenceReportParameters();
            params.setPeriodBegin(cldr.getTime());
            cldr.add(2, 12);
            params.setPeriodEnd(cldr.getTime());
            params.setAgency(new EntityReference(this.agencyContainer));
            data.put("key-report-params", params);
            ArrayList messages = new ArrayList();
            data.put("key-messages", messages);
            CCCFilesDivergenceReportPrepareHandler handler = new CCCFilesDivergenceReportPrepareHandler();
            handler.prepareData(data);
            CCCFilesDivergenceReportTestBase.TestCCCFilesDivergenceReportRenderHandler renderHandler = new CCCFilesDivergenceReportTestBase.TestCCCFilesDivergenceReportRenderHandler();
            EntityContainer renderReport = renderHandler.renderReport(data);
            File outFile = new File(this.getOutFolder(), "Divergence_CCC.xls");
            try (FileOutputStream os = new FileOutputStream(outFile);){
                os.write(((ReportFile)((DivergenceReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
            }
            String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("Divergence_CCC.xls")), (File)outFile);
            Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Exception throws: " + e.getMessage()));
        }
    }

    private List<String> createObjects() throws Exception {
        int segmentCnt = 2;
        ArrayList<String> divergenceSystemNumbers = new ArrayList<String>();
        CCCExchangeDocument doc = this.createDoc("7453369480101");
        this.addCCCFile(doc, segmentCnt);
        this.addProduct(doc);
        doc.setTicketNumber("7453369480102");
        divergenceSystemNumbers.add(doc.getTicketNumber());
        doc.setEquivalentFare(BigDecimal.valueOf(250L));
        this.addCCCFile(doc, segmentCnt);
        doc.setEquivalentFare(BigDecimal.valueOf(245L));
        this.addProduct(doc);
        doc.setTicketNumber("7453369480105");
        divergenceSystemNumbers.add(doc.getTicketNumber());
        doc.setSegmentCarrierCode("A2");
        this.addCCCFile(doc, segmentCnt);
        doc.setSegmentCarrierCode("A1");
        this.addProduct(doc);
        doc.setTicketNumber("7453369480106");
        divergenceSystemNumbers.add(doc.getTicketNumber());
        this.addProduct(doc);
        doc.setTicketNumber("7453369480107");
        divergenceSystemNumbers.add(doc.getTicketNumber());
        this.addCCCFile(doc, segmentCnt);
        return divergenceSystemNumbers;
    }
}

