/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.ccc;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LegalFormReference;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.PersonPositionReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.ccc.CCCFilesDivergenceReportRenderHandler;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;

public abstract class CCCFilesDivergenceReportTestBase
extends RenderSalesReportTestBase {
    protected Date issueDate;
    protected EntityContainer<Organization> agencyContainer;
    protected EntityContainer<Organization> vendorContainer;
    protected EntityContainer<Person> agentContainer;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        LocaleManager.get().setCurrentLocale(LocaleHelper.EN_LOCALE);
    }

    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("cccFilesReportTestDictionaries.xml");
    }

    protected EntityContainer<BookingFile> addProduct(CCCExchangeDocument doc) throws Exception {
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile bf = (BookingFile)bfc.getEntity();
        Reservation reservation = new Reservation();
        reservation.setBookingFile(bf);
        bf.getReservations().add(reservation);
        bf.setAgency(doc.getAgency());
        String user = LogicalStorage.get().getUser();
        bfc.setCreatedBy(user);
        bfc.setModifiedBy(user);
        Product product = new Product();
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setValidatorCode("7367435");
        product.setSystemNumber(doc.getTicketNumber());
        product.setIssueDate(this.issueDate);
        product.setAgencyCode(((Organization)EntityStorage.get().resolve(doc.getAgency()).getEntity()).getCode());
        Traveller traveller = new Traveller();
        traveller.setName("Test passenger");
        product.setTraveller(traveller);
        AirProductHelper.clearCommissions((Product)product);
        product.getFares().clear();
        ProductFare productFare = new ProductFare();
        productFare.setBaseFare(SystemHelper.getMoney((double)doc.getEquivalentFare().doubleValue(), (String)"RUB"));
        productFare.setEquivalentFare(doc.getEquivalentFare());
        product.getFares().add(productFare);
        product.setCarrierNumber(doc.getValidatingCarrierNumber());
        product.setConjCount(0);
        product.setTicketType(TicketType.OWN);
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyContainer.toReference());
        AirProductHelper.setSubagency((Product)product, (EntityReference)this.agencyContainer.toReference());
        product.setCashier(this.agent);
        product.getTaxes().clear();
        Tax tax = new Tax();
        tax.setCode("ZZ");
        tax.setEquivalentAmount(doc.getTchTax());
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("YR");
        tax.setEquivalentAmount(doc.getAgsTax());
        product.getTaxes().add(tax);
        product.setBlankOwnerRef((EntityReference)ProfileDao.getProfileReferenceByCode((String)"\u04281", OrganizationIndex.class).get(0));
        product.setBlankType(doc.getBlankType());
        product.setContractRulesApplied(true);
        product.setProductCategory(ProductCategory.AIR);
        product.setTariffType(TariffType.REGULAR);
        ProductFop pt = new ProductFop();
        pt.setType(PaymentType.CASH);
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(doc.getEquivalentFare().add(doc.getAgsTax()).add(doc.getTchTax()));
        pt.setAmount(money);
        pt.setOperationDate(this.issueDate);
        pt.setAgent(new EntityReference("test uid", Person.class, "test agent"));
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(pt);
        product.setStatus(ProductStatus.valueOf((String)doc.getTransaction().name()));
        AirProductHelper.setAgency((Product)product, (EntityReference)doc.getAgency());
        AirProductHelper.setSupplier((Product)product, (EntityReference)doc.getSupplier());
        Segment segment = new Segment();
        segment.setArriveCityCode(doc.getArrivalCityCode());
        segment.setDepartCityCode(doc.getDepartureCityCode());
        segment.setStartDate(doc.getStartDate());
        segment.setFlightNo(doc.getFlightNo());
        segment.setRecordNumber(1);
        segment.setAirline((DictionaryReference)new AirlineReference(doc.getSegmentCarrierCode()));
        segment.setClassOfService(doc.getClassOfService());
        segment.setFareBasis(doc.getFareBasis());
        SegmentTariff segmentTariff = new SegmentTariff();
        segmentTariff.getSegments().add(segment);
        product.getSegmentTariffs().add(segmentTariff);
        Commission commission = new Commission();
        commission.setRate(doc.getCommissionRate());
        commission.setEquivalentAmount(doc.getCommissionValue());
        commission.setContractType(ContractType.VENDOR);
        commission.setSegmentTariff(segmentTariff);
        commission.setCommissionProperties(this.commPropRef);
        AirProductHelper.getVendorContractRelation((Product)product).getCommissions().add(commission);
        segment = new Segment();
        segment.setArriveCityCode(doc.getDepartureCityCode());
        segment.setDepartCityCode(doc.getArrivalCityCode());
        segment.setStartDate(doc.getStartDate());
        segment.setFlightNo(doc.getFlightNo());
        segment.setRecordNumber(2);
        segment.setAirline((DictionaryReference)new AirlineReference(doc.getSegmentCarrierCode()));
        segment.setClassOfService(doc.getClassOfService());
        segment.setFareBasis(doc.getFareBasis());
        segmentTariff = new SegmentTariff();
        segmentTariff.getSegments().add(segment);
        product.getSegmentTariffs().add(segmentTariff);
        product.setChecked(true);
        EntityStorage.get().save(bfc, true);
        return EntityStorage.get().resolve(bfc.toReference());
    }

    protected void addCCCFile(CCCExchangeDocument data, int segmentCnt) throws Exception {
        for (int i = 0; i < segmentCnt; ++i) {
            EntityContainer cccfc = new EntityContainer(CCCExchangeDocument.class);
            String user = LogicalStorage.get().getUser();
            cccfc.setCreatedBy(user);
            cccfc.setModifiedBy(user);
            CCCExchangeDocument doc = (CCCExchangeDocument)cccfc.getEntity();
            doc.setTicketNumber(data.getTicketNumber());
            doc.setIssued(this.issueDate);
            doc.setAgency(data.getAgency());
            doc.setSupplier(data.getSupplier());
            doc.setClassOfService(data.getClassOfService());
            doc.setFareBasis(data.getFareBasis());
            doc.setArrivalCityCode(i % 2 == 0 ? data.getArrivalCityCode() : data.getDepartureCityCode());
            doc.setDepartureCityCode(i % 2 != 0 ? data.getArrivalCityCode() : data.getDepartureCityCode());
            doc.setStartDate(data.getStartDate());
            doc.setFlightNo(data.getFlightNo());
            doc.setTransferSegment(i + 1 + "");
            doc.setSegmentCarrierCode(data.getSegmentCarrierCode());
            doc.setBlankType(data.getBlankType());
            doc.setPartNum(data.getPartNum());
            doc.setPackNum(data.getPackNum());
            doc.setValidatingCarrierNumber(data.getValidatingCarrierNumber());
            doc.setAbcPeriod(data.getAbcPeriod());
            doc.setTransaction(data.getTransaction());
            if (i == 0) {
                doc.setEquivalentFare(data.getEquivalentFare());
                doc.setTchTax(data.getTchTax());
                doc.setAgsTax(data.getAgsTax());
                doc.setPenalty(data.getPenalty());
                doc.setCommissionValue(data.getCommissionValue());
                doc.setCommissionRate(data.getCommissionRate());
            }
            EntityStorage.get().save(cccfc, true);
        }
    }

    protected CCCExchangeDocument createDoc(String systemNumber) {
        CCCExchangeDocument result = new CCCExchangeDocument();
        result.setTicketNumber(systemNumber);
        result.setCommissionRate(Double.valueOf(0.05));
        result.setCommissionValue(BigDecimal.valueOf(345L));
        result.setEquivalentFare(BigDecimal.valueOf(245L));
        result.setValidatingCarrierNumber("1");
        result.setTchTax(BigDecimal.valueOf(50L));
        result.setAgsTax(BigDecimal.valueOf(100L));
        result.setTransaction(TransactionType.SELL);
        result.setClassOfService("\u042d");
        result.setFareBasis("Y");
        result.setArrivalCityCode("\u041c\u041e\u0412");
        result.setDepartureCityCode("\u041a\u0423\u0421");
        result.setStartDate(this.issueDate);
        result.setFlightNo("302");
        result.setTransferSegment("1");
        result.setBlankType((DictionaryReference)new BlankTypeReference("999"));
        result.setPartNum("10809");
        result.setPackNum("1");
        result.setAgency(this.agencyContainer.toReference());
        result.setSupplier(this.vendorContainer.toReference());
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, 1);
        result.setAbcPeriod(cldr.getTime());
        result.setSegmentCarrierCode("A1");
        return result;
    }

    protected void createProfiles() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        String registrationName = "BSP";
        this.vendorContainer = new EntityContainer(Organization.class);
        String user = LogicalStorage.get().getUser();
        this.vendorContainer.setCreatedBy(user);
        this.vendorContainer.setModifiedBy(user);
        Organization profile = (Organization)this.vendorContainer.getEntity();
        L10nStringHelper.setValue((L10nString)profile.getShortName(), (String)"BSP", (Locale)Locale.ENGLISH);
        profile.setActive(true);
        profile.setCode("BSP");
        L10nStringHelper.setValue((L10nString)profile.getFullName(), (String)registrationName, (Locale)Locale.ENGLISH);
        profile.setRegistrationId("0000000015");
        EntityStorage es = EntityStorage.get();
        es.save(this.vendorContainer, true);
        this.agencyContainer = new EntityContainer(Organization.class);
        this.agencyContainer.setCreatedBy(user);
        this.agencyContainer.setModifiedBy(user);
        EntityReference agencyRef = this.agencyContainer.toReference();
        Organization agency = (Organization)this.agencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"ABC", (Locale)Locale.ENGLISH);
        agency.setActive(true);
        agency.setCode("1001");
        L10nStringHelper.setValue((L10nString)agency.getFullName(), (String)"ABC", (Locale)Locale.ENGLISH);
        agency.setLegalForm((DictionaryReference)new LegalFormReference("\u041e\u041e\u041e"));
        SystemHelper.setMetadataValue((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_TCH_AGENCY_CODE, (Object)"10\u041c\u041e\u0421");
        es.save(this.agencyContainer, true);
        this.agentContainer = new EntityContainer(Person.class);
        this.agentContainer.setCreatedBy(user);
        this.agentContainer.setModifiedBy(user);
        Person agent = (Person)this.agentContainer.getEntity();
        agent.setUid("Test uid");
        agent.setCode("testAgent");
        agent.setLoginName(user);
        es.save(this.agentContainer, true);
        PersonPositionReference directorPosition = new PersonPositionReference(ManagerType.DIRECTOR.name());
        PersonEmployment directorEmployment = new PersonEmployment();
        directorEmployment.setOrganization(agencyRef);
        directorEmployment.setPosition((DictionaryReference)directorPosition);
        directorEmployment.setAuthorized(true);
        directorEmployment.setMainEmployment(true);
        EntityContainer directorContainer = new EntityContainer(Person.class);
        Person director = (Person)directorContainer.getEntity();
        L10nStringHelper.setValue((L10nString)director.getLastName(), (String)"Mr. Manager", (Locale)Locale.ENGLISH);
        director.getTypes().add(PersonType.MANAGER);
        director.getEmployments().add(directorEmployment);
        EntityStorage.get().save(directorContainer, false);
        PersonPositionReference chiefAccountantPosition = new PersonPositionReference(ManagerType.CHIEF_ACCOUNTANT.name());
        PersonEmployment chiefAccountantEmployment = new PersonEmployment();
        chiefAccountantEmployment.setOrganization(agencyRef);
        chiefAccountantEmployment.setPosition((DictionaryReference)chiefAccountantPosition);
        chiefAccountantEmployment.setAuthorized(true);
        chiefAccountantEmployment.setMainEmployment(true);
        EntityContainer chiefAccountantContainer = new EntityContainer(Person.class);
        Person chiefAccountant = (Person)chiefAccountantContainer.getEntity();
        L10nStringHelper.setValue((L10nString)chiefAccountant.getLastName(), (String)"Mr. Accountant", (Locale)Locale.ENGLISH);
        chiefAccountant.getTypes().add(PersonType.MANAGER);
        chiefAccountant.getEmployments().add(chiefAccountantEmployment);
        EntityStorage.get().save(chiefAccountantContainer, false);
        EntityContainer salesPointContainer = new EntityContainer(SalesPoint.class);
        salesPointContainer.setCreatedBy(user);
        salesPointContainer.setModifiedBy(user);
        SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
        salesPoint.setActive(true);
        salesPoint.setCode("2001");
        salesPoint.setActive(true);
        salesPoint.setAgency(new EntityReference(this.agencyContainer));
        salesPoint.setShortName("salesPoint");
        Validator validator = new Validator();
        validator.setNumber("7367435");
        validator.setAgency(new EntityReference(this.agencyContainer));
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        validator.setOpened(cldr.getTime());
        cldr.add(1, 212);
        validator.setClosed(cldr.getTime());
        validator.setBlankOwner(this.findBlankOwnerByCode("A1"));
        validator.setSupplier(this.findBlankOwnerByCode("A1"));
        salesPoint.getValidators().add(validator);
        es.save(salesPointContainer, true);
        EntityContainer stockBlankContainer = new EntityContainer(StockBlank.class);
        stockBlankContainer.setCreatedBy(user);
        stockBlankContainer.setModifiedBy(user);
        StockBlank stockBlank = (StockBlank)stockBlankContainer.getEntity();
        stockBlank.setNumber("1");
        es.save(stockBlankContainer, true);
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        cc.setCreatedBy(user);
        cc.setModifiedBy(user);
        cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(new EntityReference(this.vendorContainer));
        info.setCustomer(new EntityReference(this.agencyContainer));
        contract.setVendor(new EntityReference(this.vendorContainer));
        info.setNumber("01");
        es.save(cc, true);
    }

    static class TestCCCFilesDivergenceReportRenderHandler
    extends CCCFilesDivergenceReportRenderHandler {
        TestCCCFilesDivergenceReportRenderHandler() {
        }

        protected File getTemplateFile() throws IOException {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            if (!result.exists()) {
                throw new IOException("Template " + result.getCanonicalPath() + " was not found");
            }
            return result;
        }
    }
}

