/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.common;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.BaseSsodExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.reports.model.DivergenceReportDocument;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.render.RenderHandlersRegistry;
import com.gridnine.xtrip.common.reports.render.ReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.common.BaseSsodDivergenceTicketWrapper;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.PrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;

public abstract class BaseSsodDivergenceReportTestBase<E extends BaseSsodExchangeDocument>
extends RenderSalesReportTestBase {
    protected DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    protected Date issueDate;
    protected String travellerName;
    protected String baseFareCurrencyCode;
    protected double equivalentFare;
    protected double baseFare;
    protected String validatingCarrierNumber;
    protected double penalty;
    protected List<Tax> taxes = new ArrayList<Tax>();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.travellerName = "Ivanov Ivan";
        this.baseFareCurrencyCode = "EUR";
        this.equivalentFare = 100.0;
        this.baseFare = 3.0;
        this.validatingCarrierNumber = "421";
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setEquivalentAmount(BigDecimal.valueOf(50L));
        this.taxes.add(tax);
        tax = new Tax();
        tax.setCode("YR");
        tax.setEquivalentAmount(BigDecimal.valueOf(50L));
        this.taxes.add(tax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File renderReport(String outputFileName) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        DivergenceReportParameters params = new DivergenceReportParameters();
        params.setPeriodBegin(cldr.getTime());
        cldr.add(2, 12);
        params.setPeriodEnd(cldr.getTime());
        params.setAgency(this.agencyReference);
        data.put("key-report-params", params);
        ReportPrepareHandler prepareHandler = ((PrepareHandlersRegistry)Environment.getPublished(PrepareHandlersRegistry.class)).get(this.getReportId());
        prepareHandler.prepareData(data);
        List messages = (List)data.get("key-messages");
        for (Message message : messages) {
            if (message.getType() != MessageType.ERROR) continue;
            Assert.fail((String)message.getMessage().toString());
        }
        ReportRenderHandler renderHandler = ((RenderHandlersRegistry)Environment.getPublished(RenderHandlersRegistry.class)).get(this.getReportId());
        DivergenceReportDocument doc = (DivergenceReportDocument)renderHandler.renderReport(data).getEntity();
        File outFile = new File(this.getOutFolder(), outputFileName);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(((ReportFile)doc.getFiles().get(0)).getContent());
        }
        return outFile;
    }

    protected abstract String getReportId();

    protected EntityContainer<E> createExchangeFile(String systemNumber, BaseSsodDivergenceTicketWrapper.ItemType type) throws Exception {
        E doc = this.creatExchangeFile();
        EntityContainer rfc = EntityContainer.create(doc);
        doc.setTicketNumber(systemNumber);
        doc.setIssued(this.issueDate);
        doc.setAgency(this.agencyReference);
        doc.setValidatingAirline((DictionaryReference)DictHelper.findAirlineByAnyCode((String)this.validatingCarrierNumber).toReference());
        doc.setTravellerName(this.travellerName);
        if (type != BaseSsodDivergenceTicketWrapper.ItemType.MCO_REFERENCE) {
            doc.setBaseFare(SystemHelper.getMoney((double)this.baseFare, (String)this.baseFareCurrencyCode));
            doc.setEquivalentFare(BigDecimal.valueOf(this.equivalentFare));
            doc.setPenalty(BigDecimal.valueOf(this.penalty));
        }
        doc.setTicketNumber(systemNumber);
        switch (type) {
            case EXCHANGE: {
                doc.setTransaction(TransactionType.EXCHANGE);
                break;
            }
            case MCO_REFERENCE: {
                doc.setTransaction(TransactionType.REFERENCE);
                break;
            }
            case REFUND: {
                doc.setTransaction(TransactionType.REFUND);
                break;
            }
            case VOID: {
                doc.setTransaction(TransactionType.CANCEL);
                break;
            }
            default: {
                doc.setTransaction(TransactionType.SELL);
            }
        }
        for (Tax tax : this.taxes) {
            Tax ctax = new Tax();
            ctax.setCode(tax.getCode());
            ctax.setEquivalentAmount(tax.getEquivalentAmount());
            doc.getTaxes().add(ctax);
        }
        return EntityStorage.get().save(rfc, true);
    }

    protected abstract E creatExchangeFile();

    protected String createPenaltyMco(String systemNumber, String relatedProductUid) throws Exception {
        EntityContainer bfc = null;
        BookingFile bf = null;
        Reservation reservation = null;
        Product relatedProduct = null;
        Traveller traveller = null;
        ProductSearchResult psr = BookingDao.findProductByUid((String)relatedProductUid);
        bfc = psr.getContainer();
        bf = (BookingFile)bfc.getEntity();
        reservation = (Reservation)bf.getReservations().get(0);
        relatedProduct = (Product)psr.getProduct();
        traveller = (Traveller)bf.getTravellers().get(0);
        Product product = new Product();
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setSystemNumber(systemNumber);
        product.setIssueDate(this.issueDate);
        product.setTraveller(traveller);
        product.setStatus(ProductStatus.SELL);
        product.setProductCategory(ProductCategory.MCO);
        product.setMcoCategory(MCOCategory.PENALTY);
        product.getRelatedProducts().add(relatedProduct);
        ProductFare productFare = new ProductFare();
        productFare.setBaseFare(SystemHelper.getMoney((double)this.baseFare, (String)this.baseFareCurrencyCode));
        productFare.setEquivalentFare(BigDecimal.valueOf(this.equivalentFare));
        product.getFares().add(productFare);
        product.setCarrierNumber(this.validatingCarrierNumber);
        Airline airline = DictHelper.findAirlineByAnyCode((String)this.validatingCarrierNumber);
        product.setCarrier((DictionaryReference)(airline == null ? null : airline.toReference()));
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyReference);
        product.setConjCount(0);
        product.getScns().add(systemNumber);
        product.setTicketType(TicketType.OWN);
        product.setBlankOwnerRef(this.s7Reference);
        EntityContainer vendorCtr = EntityStorage.get().resolve(this.s7Reference);
        if (vendorCtr != null && (airline = (Airline)DictionaryCache.get().resolveReference(((Organization)vendorCtr.getEntity()).getAirline())) != null) {
            product.setBlankOwnerNumber(airline.getAirlineNumber());
        }
        for (Tax tax : this.taxes) {
            Tax ctax = new Tax();
            ctax.setCode(tax.getCode());
            ctax.setEquivalentAmount(tax.getEquivalentAmount());
            product.getTaxes().add(ctax);
        }
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setContractRulesApplied(true);
        product.setTariffType(TariffType.REGULAR);
        ProductFop productFop = new ProductFop();
        productFop.setType(PaymentType.CASH);
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(BigDecimal.valueOf(this.equivalentFare).add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product)));
        productFop.setAmount(money);
        productFop.setOperationDate(this.issueDate);
        List vendorFops = AirProductHelper.getVendorContractRelation((Product)product).getFops();
        List clientFops = AirProductHelper.getClientContractRelation((Product)product).getFops();
        vendorFops.add(productFop);
        clientFops.add(XCloneHelper.clone((XCloneable)productFop, (boolean)true));
        EntityStorage.get().save(bfc, true);
        return product.getUid();
    }

    protected String createProduct(String systemNumber, BaseSsodDivergenceTicketWrapper.ItemType type, String relatedProductUid) throws Exception {
        EntityContainer bfc = null;
        BookingFile bf = null;
        Reservation reservation = null;
        Product relatedProduct = null;
        Traveller traveller = null;
        if (relatedProductUid != null) {
            ProductSearchResult psr = BookingDao.findProductByUid((String)relatedProductUid);
            bfc = psr.getContainer();
            bf = (BookingFile)bfc.getEntity();
            reservation = (Reservation)bf.getReservations().get(0);
            relatedProduct = (Product)psr.getProduct();
            traveller = (Traveller)bf.getTravellers().get(0);
        } else {
            bfc = new EntityContainer(BookingFile.class);
            bf = (BookingFile)bfc.getEntity();
            reservation = new Reservation();
            this.setRecordLocator(reservation, this.getGds());
            bf.getReservations().add(reservation);
            reservation.setBookingFile(bf);
            bf.setAgency(this.agencyReference);
            traveller = new Traveller();
            traveller.setName(this.travellerName);
            bf.getTravellers().add(traveller);
        }
        Product product = new Product();
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setSystemNumber(systemNumber);
        product.setIssueDate(this.issueDate);
        product.setTraveller(traveller);
        switch (type) {
            case REFUND: {
                product.setStatus(ProductStatus.REFUND);
                product.setProductCategory(ProductCategory.AIR);
                product.setPreviousProduct(relatedProduct);
                relatedProduct.setNextProduct(product);
                break;
            }
            case MCO_REFERENCE: {
                product.setStatus(ProductStatus.SELL);
                product.setProductCategory(ProductCategory.MCO);
                product.setMcoCategory(MCOCategory.INFORMATION);
                product.getRelatedProducts().add(relatedProduct);
                break;
            }
            case VOID: {
                product.setStatus(ProductStatus.VOID);
                break;
            }
            case EXCHANGE: {
                product.setStatus(ProductStatus.SELL);
                product.setProductCategory(ProductCategory.AIR);
                Product exchange = AirProductHelper.clone((Product)relatedProduct, (boolean)true);
                exchange.setStatus(ProductStatus.EXCHANGE);
                exchange.setNextProduct(product);
                exchange.setChecked(true);
                exchange.setPreviousProduct(relatedProduct);
                exchange.setIssueDate(this.issueDate);
                for (Object fop : AirProductHelper.getVendorContractRelation((Product)exchange).getFops()) {
                    fop.setOperationDate(this.issueDate);
                }
                for (Object fop : AirProductHelper.getClientContractRelation((Product)exchange).getFops()) {
                    fop.setOperationDate(this.issueDate);
                }
                product.setPreviousProduct(exchange);
                relatedProduct.setNextProduct(product);
                break;
            }
            default: {
                product.setStatus(ProductStatus.SELL);
                product.setProductCategory(ProductCategory.AIR);
            }
        }
        if (type != BaseSsodDivergenceTicketWrapper.ItemType.MCO_REFERENCE) {
            ProductFare productFare = new ProductFare();
            productFare.setBaseFare(SystemHelper.getMoney((double)this.baseFare, (String)this.baseFareCurrencyCode));
            productFare.setEquivalentFare(BigDecimal.valueOf(this.equivalentFare));
            product.getFares().add(productFare);
            product.setPenalty(BigDecimal.valueOf(this.penalty));
        }
        product.setCarrierNumber(this.validatingCarrierNumber);
        Airline airline = DictHelper.findAirlineByAnyCode((String)this.validatingCarrierNumber);
        product.setCarrier((DictionaryReference)(airline == null ? null : airline.toReference()));
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyReference);
        product.setConjCount(0);
        product.getScns().add(systemNumber);
        product.setTicketType(TicketType.OWN);
        product.setBlankOwnerRef(this.s7Reference);
        EntityContainer vendorCtr = EntityStorage.get().resolve(this.s7Reference);
        if (vendorCtr != null && (airline = (Airline)DictionaryCache.get().resolveReference(((Organization)vendorCtr.getEntity()).getAirline())) != null) {
            product.setBlankOwnerNumber(airline.getAirlineNumber());
        }
        for (Tax tax : this.taxes) {
            Tax ctax = new Tax();
            ctax.setCode(tax.getCode());
            ctax.setEquivalentAmount(tax.getEquivalentAmount());
            product.getTaxes().add(ctax);
        }
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setContractRulesApplied(true);
        product.setTariffType(TariffType.REGULAR);
        ProductFop productFop = new ProductFop();
        productFop.setType(PaymentType.CASH);
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(BigDecimal.valueOf(this.equivalentFare).add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product)));
        productFop.setAmount(money);
        productFop.setOperationDate(this.issueDate);
        List vendorFops = AirProductHelper.getVendorContractRelation((Product)product).getFops();
        List clientFops = AirProductHelper.getClientContractRelation((Product)product).getFops();
        vendorFops.add(productFop);
        clientFops.add(XCloneHelper.clone((XCloneable)productFop, (boolean)true));
        EntityStorage.get().save(bfc, true);
        return product.getUid();
    }

    protected abstract GdsName getGds();
}

