/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.hot;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.HotExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.reports.prepare.salesreports.divergence.HOTFilesDivergenceReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.hot.HOTFilesDivergenceReportTestBase;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class HOTFilesDivergenceReportTest
extends HOTFilesDivergenceReportTestBase {
    @Test
    public void getDataTest() {
        try {
            this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
            this.createProfiles();
            List<String> divergenceSystemNumbers = this.createObjects();
            HashMap<String, Object> data = new HashMap<String, Object>();
            Calendar cldr = Calendar.getInstance();
            cldr.setTime(this.issueDate);
            cldr.add(2, -6);
            DivergenceReportParameters params = new DivergenceReportParameters();
            params.setPeriodBegin(cldr.getTime());
            cldr.add(2, 12);
            params.setPeriodEnd(cldr.getTime());
            params.setAgency(new EntityReference(this.agencyContainer));
            data.put("key-report-params", params);
            HOTFilesDivergenceReportPrepareHandler handler = new HOTFilesDivergenceReportPrepareHandler();
            List<Object[]> filteredData = handler.getData(data, null);
            Assert.assertEquals((String)("\u0412 \u043e\u0442\u0447\u0451\u0442\u0435 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 " + filteredData.size() + " \u043f\u0430\u0440 \u0431\u0438\u043b\u0435\u0442/HOT-\u0444\u0430\u0439\u043b, \u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c " + divergenceSystemNumbers.size()), (long)divergenceSystemNumbers.size(), (long)filteredData.size());
            for (Object[] pair : filteredData) {
                Product product = (Product)pair[0];
                HotExchangeDocument doc = (HotExchangeDocument)pair[1];
                if ((product == null || divergenceSystemNumbers.contains(product.getSystemNumber())) && (doc == null || divergenceSystemNumbers.contains(doc.getTicketNumber()))) continue;
                Assert.fail((String)("\u0412 \u043e\u0442\u0447\u0451\u0442\u0435 \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u043e \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0431\u0438\u043b\u0435\u0442/HOT-\u0444\u0430\u0439\u043b \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c " + (product != null ? product.getSystemNumber() : doc.getTicketNumber())));
            }
        }
        catch (Exception e) {
            this.log.error("error", (Throwable)e);
            Assert.fail((String)("Exception throws: " + e.getMessage()));
        }
    }

    @Test
    public void renderReportTest() {
        try {
            this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
            this.createProfiles();
            this.createObjects();
            File outFile = this.createReport("Divergence_HOT.xls");
            String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("Divergence_HOT.xls")), (File)outFile);
            Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            this.log.error("error", (Throwable)e);
            Assert.fail((String)("Exception throws: " + e.getMessage()));
        }
    }

    private List<String> createObjects() throws Exception {
        String systemNumber = "7453369480101";
        String travellerName = "Test Passenger";
        BigDecimal commissionAmount = BigDecimal.valueOf(345L);
        ArrayList<BigDecimal> commissionAmounts = new ArrayList<BigDecimal>();
        commissionAmounts.add(BigDecimal.valueOf(345L));
        Money baseFare = this.buildMoney("EUR", 245.0);
        BigDecimal equivalentFare = BigDecimal.valueOf(11147.5);
        AirlineReference ticketingAirline = new AirlineReference("A1");
        ArrayList<Tax> taxes = new ArrayList<Tax>();
        Tax tax = new Tax();
        tax.setCode("RI");
        tax.setAmount(this.buildMoney("RUB", 133.0));
        tax.setEquivalentAmount(BigDecimal.valueOf(133L));
        taxes.add(tax);
        tax = new Tax();
        tax.setCode("RE");
        tax.setAmount(this.buildMoney("RUB", 123.0));
        tax.setEquivalentAmount(BigDecimal.valueOf(123L));
        taxes.add(tax);
        tax = new Tax();
        tax.setCode("SI");
        tax.setAmount(this.buildMoney("RUB", 111.0));
        tax.setEquivalentAmount(BigDecimal.valueOf(111L));
        taxes.add(tax);
        ProductStatus productType = ProductStatus.SELL;
        TransactionType transactionType = TransactionType.SELL;
        ArrayList<String> divergenceSystemNumbers = new ArrayList<String>();
        systemNumber = "7453369480101";
        divergenceSystemNumbers.add(systemNumber);
        this.addHotFile(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmount, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, transactionType);
        travellerName = "Test Passenger1";
        this.addProduct(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmounts, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, productType, (EntityContainer<Organization>)this.vendorContainer);
        travellerName = "Test Passenger";
        systemNumber = "7453369480103";
        divergenceSystemNumbers.add(systemNumber);
        commissionAmount = BigDecimal.valueOf(346L);
        this.addHotFile(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmount, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, transactionType);
        commissionAmount = BigDecimal.valueOf(345L);
        this.addProduct(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmounts, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, productType, (EntityContainer<Organization>)this.vendorContainer);
        systemNumber = "7453369480104";
        divergenceSystemNumbers.add(systemNumber);
        this.addHotFile(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmount, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, transactionType);
        baseFare = this.buildMoney("EUR", 246.0);
        this.addProduct(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmounts, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, productType, (EntityContainer<Organization>)this.vendorContainer);
        baseFare = this.buildMoney("EUR", 245.0);
        systemNumber = "7453369480105";
        divergenceSystemNumbers.add(systemNumber);
        this.addHotFile(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmount, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, transactionType);
        equivalentFare = BigDecimal.valueOf(11148.5);
        this.addProduct(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmounts, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, productType, (EntityContainer<Organization>)this.vendorContainer);
        equivalentFare = BigDecimal.valueOf(11147.5);
        systemNumber = "7453369480107";
        divergenceSystemNumbers.add(systemNumber);
        this.addHotFile(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmount, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, transactionType);
        ticketingAirline = new AirlineReference("A2");
        this.addProduct(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmounts, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, productType, (EntityContainer<Organization>)this.vendorContainer);
        ticketingAirline = new AirlineReference("A1");
        systemNumber = "7453369480108";
        divergenceSystemNumbers.add(systemNumber);
        this.addHotFile(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmount, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, transactionType);
        taxes.remove(2);
        this.addProduct(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmounts, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, productType, (EntityContainer<Organization>)this.vendorContainer);
        tax = new Tax();
        tax.setCode("SI");
        tax.setAmount(this.buildMoney("RUB", 111.0));
        tax.setEquivalentAmount(BigDecimal.valueOf(111L));
        taxes.add(tax);
        systemNumber = "7453369480109";
        divergenceSystemNumbers.add(systemNumber);
        this.addHotFile(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmount, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, transactionType);
        Date otherDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-02");
        this.addProduct(systemNumber, travellerName, otherDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmounts, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, productType, (EntityContainer<Organization>)this.vendorContainer);
        systemNumber = "7453369480110";
        divergenceSystemNumbers.add(systemNumber);
        transactionType = TransactionType.REFUND;
        this.addHotFile(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmount, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, transactionType);
        transactionType = TransactionType.SELL;
        divergenceSystemNumbers.add(systemNumber);
        this.addProduct(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmounts, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, productType, (EntityContainer<Organization>)this.vendorContainer);
        systemNumber = "7453369480111";
        travellerName = "Test Passenger mrs";
        this.addHotFile(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmount, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, transactionType);
        travellerName = "Test Passenger";
        this.addProduct(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmounts, baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, productType, (EntityContainer<Organization>)this.vendorContainer);
        return divergenceSystemNumbers;
    }
}

