/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.hot;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.HotExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.reports.model.DivergenceReportDocument;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.hot.HOTFilesDivergenceReportRenderHandler;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.reports.prepare.salesreports.divergence.HOTFilesDivergenceReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

abstract class HOTFilesDivergenceReportTestBase
extends RenderSalesReportTestBase {
    protected Date issueDate;
    protected EntityContainer<Organization> agencyContainer;
    protected EntityContainer<Organization> vendorContainer;
    protected final String equiveCurrencyCode = "RUB";
    protected final String foreignCurrencyCode = "EUR";

    HOTFilesDivergenceReportTestBase() {
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        LocaleManager.get().setCurrentLocale(LocaleHelper.EN_LOCALE);
    }

    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("hotFilesReportTestDictionaries.xml");
    }

    protected URL getEntitiesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("testdata.xml");
    }

    protected void addHotFile(String systemNumber, String travellerName, Date issueDate, EntityContainer<Organization> agencyContainer, BigDecimal commissionAmount, Money baseFare, BigDecimal equivalentFare, DictionaryReference<Airline> ticketingAirline, List<Tax> taxes, TransactionType transactionType) throws Exception {
        EntityContainer hfc = new EntityContainer(HotExchangeDocument.class);
        HotExchangeDocument doc = (HotExchangeDocument)hfc.getEntity();
        String user = LogicalStorage.get().getUser();
        hfc.setCreatedBy(user);
        hfc.setModifiedBy(user);
        doc.setTicketNumber(systemNumber);
        doc.setIssued(issueDate);
        doc.setAgency(new EntityReference(agencyContainer));
        doc.setTravellerName(travellerName);
        doc.setBSPCommissionRate(BigDecimal.ZERO.compareTo(MiscUtil.guarded((BigDecimal)commissionAmount)) == 0 ? Double.valueOf(0.0) : Double.valueOf(commissionAmount.multiply(BigDecimal.valueOf(100L)).divide(MiscUtil.guarded((BigDecimal)equivalentFare), 2, RoundingMode.HALF_UP).doubleValue()));
        doc.setBSPCommissionValue(commissionAmount);
        doc.setBaseFare(baseFare);
        doc.setEquivalentFare(equivalentFare);
        doc.setTicketingAirline(ticketingAirline);
        doc.getTaxes().clear();
        doc.getTaxes().addAll(taxes);
        doc.setTransaction(transactionType);
        EntityStorage.get().save(hfc, true);
    }

    protected EntityContainer<BookingFile> addProduct(String systemNumber, String travellerName, Date issueDate, EntityContainer<Organization> agencyContainer, List<BigDecimal> commissionAmounts, Money baseFare, BigDecimal equivalentFare, DictionaryReference<Airline> ticketingAirline, List<Tax> taxes, ProductStatus productStatus, EntityContainer<Organization> vendorContainer) throws Exception {
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile bf = (BookingFile)bfc.getEntity();
        Reservation reservation = new Reservation();
        reservation.setBookingFile(bf);
        bf.getReservations().add(reservation);
        bf.setAgency(new EntityReference(agencyContainer));
        String user = LogicalStorage.get().getUser();
        bfc.setCreatedBy(user);
        bfc.setModifiedBy(user);
        Product product = new Product();
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setValidatorCode("7367435");
        product.setSystemNumber(systemNumber);
        product.setIssueDate(issueDate);
        product.setAgencyCode(((Organization)agencyContainer.getEntity()).getCode());
        Traveller traveller = new Traveller();
        traveller.setName(travellerName);
        product.setTraveller(traveller);
        AirProductHelper.clearCommissions((Product)product);
        List vendorCommissions = AirProductHelper.getVendorContractRelation((Product)product).getCommissions();
        for (BigDecimal commissionAmount : commissionAmounts) {
            vendorCommissions.add(this.buildCommissions(commissionAmount.doubleValue(), ContractType.VENDOR));
        }
        product.getFares().clear();
        ProductFare productFare = new ProductFare();
        productFare.setBaseFare(baseFare);
        product.getFares().add(productFare);
        productFare = new ProductFare();
        productFare.setEquivalentFare(equivalentFare);
        product.getFares().add(productFare);
        product.setCarrier(ticketingAirline);
        product.setConjCount(0);
        product.getScns().add(systemNumber);
        product.setTicketType(TicketType.OWN);
        product.getTaxes().clear();
        product.getTaxes().addAll(taxes);
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (Tax tax : taxes) {
            taxAmount = taxAmount.add(tax.getAmount().getValue());
        }
        product.setBlankOwnerRef(this.findBlankOwnerByCode("BSP"));
        product.setBlankType((DictionaryReference)new BlankTypeReference("999"));
        AirProductHelper.setAgency((Product)product, (EntityReference)agencyContainer.toReference());
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setContractRulesApplied(true);
        product.setProductCategory(ProductCategory.AIR);
        product.setTariffType(TariffType.REGULAR);
        ProductFop pt = new ProductFop();
        pt.setType(PaymentType.CASH);
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(equivalentFare.add(taxAmount));
        pt.setAmount(money);
        pt.setOperationDate(issueDate);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(pt);
        product.setStatus(productStatus);
        bfc = EntityStorage.get().save(bfc, true);
        EntityContainer stockBlankContainer = new EntityContainer(StockBlank.class);
        stockBlankContainer.setCreatedBy(user);
        stockBlankContainer.setModifiedBy(user);
        StockBlank stockBlank = (StockBlank)stockBlankContainer.getEntity();
        stockBlank.setSupplier(new EntityReference(vendorContainer));
        stockBlank.setProductUid(product.getUid());
        EntityStorage.get().save(stockBlankContainer, true);
        return bfc;
    }

    protected Money buildMoney(String currency, double sum) {
        Money money = new Money();
        money.setCurrency(currency);
        money.setValue(new BigDecimal(sum));
        return money;
    }

    protected Commission buildCommissions(double sum, ContractType contractType) {
        Commission commission = new Commission();
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(new BigDecimal(sum));
        commission.setAmount(money);
        commission.setContractType(contractType);
        commission.setEquivalentAmount(money.getValue());
        return commission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createReport(String fileName) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        DivergenceReportParameters params = new DivergenceReportParameters();
        params.setPeriodBegin(cldr.getTime());
        cldr.add(2, 12);
        params.setPeriodEnd(cldr.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        data.put("key-report-params", params);
        ArrayList messages = new ArrayList();
        data.put("key-messages", messages);
        HOTFilesDivergenceReportPrepareHandler handler = new HOTFilesDivergenceReportPrepareHandler();
        handler.prepareData(data);
        data.put("AGENCY_DIRECTOR", "Mr. director");
        data.put("AGENCY_ACCOUNTANT", "Mr. accountant");
        TestHOTFilesDivergenceReportRenderHandler renderHandler = new TestHOTFilesDivergenceReportRenderHandler();
        EntityContainer renderReport = renderHandler.renderReport(data);
        File outFile = new File(this.getOutFolder(), "Divergence_exchange_HOT.xls");
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(((ReportFile)((DivergenceReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
        }
        return outFile;
    }

    protected void createProfiles() throws Exception {
        String registrationName = "BSP";
        this.vendorContainer = new EntityContainer(Organization.class);
        String user = LogicalStorage.get().getUser();
        this.vendorContainer.setCreatedBy(user);
        this.vendorContainer.setModifiedBy(user);
        Organization profile = (Organization)this.vendorContainer.getEntity();
        L10nStringHelper.setValue((L10nString)profile.getShortName(), (String)"BSP", (Locale)Locale.ENGLISH);
        profile.setActive(true);
        profile.setCode("BSP");
        L10nStringHelper.setValue((L10nString)profile.getFullName(), (String)registrationName, (Locale)Locale.ENGLISH);
        profile.setRegistrationId("0000000015");
        EntityStorage es = EntityStorage.get();
        es.save(this.vendorContainer, true);
        this.agencyContainer = new EntityContainer(Organization.class);
        this.agencyContainer.setCreatedBy(user);
        this.agencyContainer.setModifiedBy(user);
        Organization agency = (Organization)this.agencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"ABC", (Locale)Locale.ENGLISH);
        agency.setActive(true);
        agency.setCode("1001");
        es.save(this.agencyContainer, true);
        EntityContainer salesPointContainer = new EntityContainer(SalesPoint.class);
        salesPointContainer.setCreatedBy(user);
        salesPointContainer.setModifiedBy(user);
        SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
        salesPoint.setActive(true);
        salesPoint.setCode("2001");
        salesPoint.setActive(true);
        salesPoint.setAgency(new EntityReference(this.agencyContainer));
        salesPoint.setShortName("salesPoint");
        Validator validator = new Validator();
        validator.setNumber("7367435");
        validator.setAgency(new EntityReference(this.agencyContainer));
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        validator.setOpened(cldr.getTime());
        cldr.add(1, 212);
        validator.setClosed(cldr.getTime());
        validator.setBlankOwner(this.findBlankOwnerByCode("A1"));
        es.save(salesPointContainer, true);
        EntityContainer stockBlankContainer = new EntityContainer(StockBlank.class);
        stockBlankContainer.setCreatedBy(user);
        stockBlankContainer.setModifiedBy(user);
        StockBlank stockBlank = (StockBlank)stockBlankContainer.getEntity();
        stockBlank.setNumber("1");
        es.save(stockBlankContainer, true);
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        cc.setCreatedBy(user);
        cc.setModifiedBy(user);
        cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(new EntityReference(this.vendorContainer));
        info.setCustomer(new EntityReference(this.agencyContainer));
        contract.setVendor(new EntityReference(this.vendorContainer));
        info.setNumber("01");
        es.save(cc, true);
    }

    protected List<Object[]> prepareReport() throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        DivergenceReportParameters params = new DivergenceReportParameters();
        params.setPeriodBegin(cldr.getTime());
        cldr.add(2, 12);
        params.setPeriodEnd(cldr.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        data.put("key-report-params", params);
        HOTFilesDivergenceReportPrepareHandler handler = new HOTFilesDivergenceReportPrepareHandler();
        return handler.getData(data, null);
    }

    class TestHOTFilesDivergenceReportRenderHandler
    extends HOTFilesDivergenceReportRenderHandler {
        TestHOTFilesDivergenceReportRenderHandler() {
        }

        protected File getTemplateFile() throws IOException {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            if (!result.exists()) {
                throw new IOException("Template " + result.getCanonicalPath() + " was not found");
            }
            return result;
        }
    }
}

