/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.hot;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.hot.HOTFilesDivergenceReportTestBase;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class HotFilesExchangeReportTest
extends HOTFilesDivergenceReportTestBase {
    @Test
    public void testExchange() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2018-01-16");
        this.createProfiles();
        this.createObjects();
        List<Object[]> comparisonResult = this.prepareReport();
        Assert.assertEquals((long)0L, (long)comparisonResult.size());
    }

    private void createObjects() throws Exception {
        String systemNumber = "7453369480101";
        String travellerName = "Test Passenger";
        BigDecimal commissionAmount = BigDecimal.valueOf(0L);
        Money baseFare = this.buildMoney("EUR", 245.0);
        BigDecimal equivalentFare = BigDecimal.valueOf(11147.5);
        AirlineReference ticketingAirline = new AirlineReference("A1");
        TransactionType transactionType = TransactionType.EXCHANGE;
        this.addHotFile(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, commissionAmount, baseFare, null, (DictionaryReference<Airline>)ticketingAirline, Collections.emptyList(), transactionType);
        ArrayList<Tax> taxes = new ArrayList<Tax>();
        Tax tax = new Tax();
        tax.setCode("RI");
        tax.setAmount(this.buildMoney("RUB", 100.0));
        tax.setEquivalentAmount(BigDecimal.valueOf(100L));
        taxes.add(tax);
        tax = new Tax();
        tax.setCode("RE");
        tax.setAmount(this.buildMoney("RUB", 200.0));
        tax.setEquivalentAmount(BigDecimal.valueOf(200L));
        taxes.add(tax);
        EntityContainer<BookingFile> bfc = this.addProduct(systemNumber, travellerName, this.issueDate, (EntityContainer<Organization>)this.agencyContainer, Collections.singletonList(BigDecimal.valueOf(0L)), baseFare, equivalentFare, (DictionaryReference<Airline>)ticketingAirline, taxes, ProductStatus.SELL, (EntityContainer<Organization>)this.vendorContainer);
        Product prod = (Product)((Reservation)((BookingFile)bfc.getEntity()).getReservations().get(0)).getProducts().get(0);
        Product firstSell = new Product();
        AirProductHelper.copy((Product)prod, (Product)firstSell, (boolean)true);
        firstSell.setIssueDate(new SimpleDateFormat("yyyy-MM-dd").parse("2014-01-16"));
        AirProductHelper.getVendorContractRelation((Product)firstSell).getFops().forEach(fop -> fop.setOperationDate(firstSell.getIssueDate()));
        Product exchange = new Product();
        AirProductHelper.copy((Product)prod, (Product)exchange, (boolean)true);
        exchange.setStatus(ProductStatus.EXCHANGE);
        firstSell.setNextProduct(exchange);
        exchange.setPreviousProduct(firstSell);
        prod.setPreviousProduct(exchange);
        exchange.setNextProduct(prod);
        EntityStorage.get().save(bfc, true);
    }
}

