/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.prepare.tch;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.reports.ReportsTestBase;
import com.gridnine.xtrip.server.reports.prepare.salesreports.tch.TchSalesReportPrepareHandler;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class Code99ATest
extends ReportsTestBase {
    private final double rate1 = 10.0;
    private final double rate2 = 20.0;
    private final double tariffFare = 1000.0;
    private final double taxAmount = 100.0;
    private final String equiveCurrencyCode = "RUB";
    private Date issueDate;
    private EntityContainer<Organization> agencyContainer;
    private EntityContainer<Organization> clientContainer;
    private EntityContainer<Person> agentContainer;
    private final String cityCode1 = "testCityCode1";
    private final String cityCode2 = "testCityCode2";

    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("tchPrepareSalesReportTestDictionaries.xml");
    }

    @Test
    public void testReport() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        this.createBookingFile();
        HashMap<String, Object> data = new HashMap<String, Object>();
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ReportParameters params = new ReportParameters();
        params.setPeriodBegin(cldr.getTime());
        cldr.add(2, 12);
        params.setPeriodEnd(cldr.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        params.setBlankOwner(this.tchReference);
        TchSalesReportPrepareHandler handler = new TchSalesReportPrepareHandler();
        data.put("key-report-params", params);
        handler.prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)message.getMessage().getKey(), (boolean)true);
        }
        List batchDataList = (List)data.get("key-batch-data-list");
        Object cashList = null;
        for (Object batch : batchDataList) {
            if (!batch.getBatchId().equals("CASH")) continue;
            cashList = batch;
            break;
        }
        ReportBatchData packBatch = null;
        for (ReportBatchData batch : batchDataList) {
            if (!batch.getBatchId().equals("PACK")) continue;
            packBatch = batch;
            break;
        }
        Assert.assertNotNull(packBatch);
        Assert.assertEquals((long)1L, (long)packBatch.getTickets().size());
        Assert.assertNotNull((Object)cashList);
        List tickets = cashList.getTickets();
        Assert.assertEquals((long)2L, (long)tickets.size());
        for (TchTicket ticket : tickets) {
            if (ticket.getTicketNumber().equals("A1")) {
                double comm1 = 50.0;
                double comm2 = 100.0;
                if (ticket.getCarrierCodes()[0].equals("A2")) {
                    Assert.assertEquals((double)comm1, (double)ticket.getVendorEquivalentCommission().doubleValue(), (double)0.001);
                } else if (ticket.getCarrierCodes()[0].equals("A3")) {
                    Assert.assertEquals((double)comm2, (double)ticket.getVendorEquivalentCommission().doubleValue(), (double)0.001);
                } else {
                    Assert.assertTrue((boolean)false);
                }
                Assert.assertEquals((double)500.0, (double)ticket.getFareCash().doubleValue(), (double)0.0);
                Assert.assertEquals((double)0.0, (double)ticket.getXtTaxCash().doubleValue(), (double)0.0);
                Assert.assertEquals((double)50.0, (double)ticket.getTchTaxCash().doubleValue(), (double)0.0);
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
    }

    private void createBookingFile() throws Exception {
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile result = (BookingFile)bfc.getEntity();
        result.setCustomerProfile(this.clientContainer.toReference());
        String user = LogicalStorage.get().getUser();
        bfc.setCreatedBy(user);
        bfc.setModifiedBy(user);
        Reservation reservation = new Reservation();
        reservation.setBookingFile(result);
        result.getReservations().add(reservation);
        this.addProduct(reservation, result);
        EntityStorage.get().save(bfc, true);
    }

    private void addProduct(Reservation reservation, BookingFile result) throws Exception {
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        result.getTravellers().add(traveller);
        Product product = new Product();
        product.setTicketType(TicketType.OWN);
        product.setTariffType(TariffType.REGULAR);
        product.setValidatorCode("12345678");
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setTraveller(traveller);
        product.setProductCategory(ProductCategory.AIR);
        product.setBlankOwnerRef(this.tchReference);
        product.setBlankOwnerNumber("99A");
        product.setStatus(ProductStatus.SELL);
        product.setCashier(this.agent);
        product.setCarrier((DictionaryReference)new AirlineReference("A1"));
        product.setCarrierNumber("99A");
        product.setBlankType((DictionaryReference)new BlankTypeReference("99A 661"));
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyContainer.toReference());
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        result.setAgency(new EntityReference(this.agencyContainer));
        Segment segment = new Segment();
        segment.setStartDate(Calendar.getInstance().getTime());
        segment.setAirline((DictionaryReference)new AirlineReference("A2"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("testCityCode1"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("testCityCode2"));
        segment.setFareBasis("farebasis");
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        AirProductHelper.setSegmentBaseFare((Product)product, (SegmentTariff)sppPsgr, (Money)SystemHelper.getMoney((double)500.0, (String)"RUB"));
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(500.0));
        Tax tax = new Tax();
        tax.setCode("ZZ");
        tax.setAmount(SystemHelper.getMoney((double)50.0, (String)"RUB"));
        tax.setEquivalentAmount(BigDecimal.valueOf(50.0));
        tax.setSegmentTariff(sppPsgr);
        product.getTaxes().add(tax);
        segment = new Segment();
        segment.setStartDate(Calendar.getInstance().getTime());
        segment.setAirline((DictionaryReference)new AirlineReference("A3"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("testCityCode2"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("testCityCode1"));
        segment.setFareBasis("farebasis");
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        AirProductHelper.setSegmentBaseFare((Product)product, (SegmentTariff)sppPsgr, (Money)SystemHelper.getMoney((double)500.0, (String)"RUB"));
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(500.0));
        tax = new Tax();
        tax.setCode("ZZ");
        tax.setAmount(SystemHelper.getMoney((double)50.0, (String)"RUB"));
        tax.setEquivalentAmount(BigDecimal.valueOf(50.0));
        tax.setSegmentTariff(sppPsgr);
        product.getTaxes().add(tax);
        product.setIssueDate(this.issueDate);
        ProductFop fop = new ProductFop();
        fop.setType(PaymentType.CASH);
        fop.setOperationDate(this.issueDate);
        fop.setAmount(SystemHelper.getMoney((double)1100.0, (String)"RUB"));
        fop.setAgent(new EntityReference(this.agentContainer));
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setSystemNumber("A1");
    }

    private void createProfiles() throws Exception {
        EntityStorage es = EntityStorage.get();
        String user = LogicalStorage.get().getUser();
        EntityContainer commCtr = new EntityContainer(CommissionProperties.class);
        ((CommissionProperties)commCtr.getEntity()).setDisplayName("Commission %");
        ((CommissionProperties)commCtr.getEntity()).setRate(true);
        ((CommissionProperties)commCtr.getEntity()).setRoundingMode(RoundingMode.NONE);
        ((CommissionProperties)commCtr.getEntity()).setRate(true);
        es.save(commCtr, false);
        this.agencyContainer = new EntityContainer(Organization.class);
        this.agencyContainer.setCreatedBy(user);
        this.agencyContainer.setModifiedBy(user);
        Organization agency = (Organization)this.agencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"testAgency", (Locale)Locale.ENGLISH);
        agency.setActive(true);
        agency.setCode("testAgency");
        es.save(this.agencyContainer, true);
        this.agentContainer = new EntityContainer(Person.class);
        this.agentContainer.setCreatedBy(user);
        this.agentContainer.setModifiedBy(user);
        Person agent = (Person)this.agentContainer.getEntity();
        agent.setUid("Test uid");
        agent.setCode("testAgent");
        agent.setLoginName(user);
        es.save(this.agentContainer, true);
        this.clientContainer = new EntityContainer(Organization.class);
        this.clientContainer.setCreatedBy(user);
        this.clientContainer.setModifiedBy(user);
        Organization client = (Organization)this.agencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)client.getShortName(), (String)"testClient", (Locale)Locale.ENGLISH);
        client.setActive(true);
        client.setCode("testClient");
        es.save(this.clientContainer, true);
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        cc.setCreatedBy(user);
        cc.setModifiedBy(user);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(this.tchReference);
        info.setCustomer(new EntityReference(this.agencyContainer));
        contract.setVendor(this.tchReference);
        info.setNumber("01");
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("A2");
        RuleRestriction restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)"\u04281");
        rs.getRestrictions().add(restr);
        restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.CARRIER_NUMBER);
        restr.setCondition((RuleCondition)Conditions.EQUALS);
        restr.setValue((Object)"2");
        rs.getRestrictions().add(restr);
        RuleResult res = new RuleResult();
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(commCtr.toReference());
        value.setValue(10.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("A2");
        restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)"\u04281");
        rs.getRestrictions().add(restr);
        restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.CARRIER_NUMBER);
        restr.setCondition((RuleCondition)Conditions.EQUALS);
        restr.setValue((Object)"3");
        rs.getRestrictions().add(restr);
        res = new RuleResult();
        value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(commCtr.toReference());
        value.setValue(20.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        es.save(cc, true);
    }
}

