/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.prepare.vv;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.salesreports.vv.VvSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.prepare.VvReportPrepareBaseTest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class VvSalesReportPrepareTest
extends VvReportPrepareBaseTest {
    private final double[] equivTariffs = new double[]{1200.0, 3560.0, 9030.0, 2400.0, 3400.0, 7600.0, 9100.0, 10000.0, 12000.0, 1500.0};
    protected Date issueDate = Calendar.getInstance().getTime();
    protected Map<String, Object> data = new HashMap<String, Object>();
    private final String validatorCode = "111111";

    @Test
    public void testPrepareReport() throws Exception {
        this.init();
        this.createBookingFiles();
        this.prepareReport(this.data);
    }

    protected void init() throws Exception {
        this.ac = this.createAgency();
        this.airlineRef = this.createAirlineVV();
    }

    protected void prepareReport(Map<String, Object> data) throws Exception {
        VvSalesReportPrepareBookingFilesHandler handler = new VvSalesReportPrepareBookingFilesHandler();
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -1);
        ReportParameters params = new ReportParameters();
        params.setPeriodBegin(cldr.getTime());
        cldr.add(2, 2);
        params.setPeriodEnd(cldr.getTime());
        params.setAgency(new EntityReference(this.ac));
        params.setBlankOwner((EntityReference)ProfileDao.getProfileReferenceByCode((String)"VV", OrganizationIndex.class).get(0));
        data.put("key-report-params", params);
        handler.prepareData(data);
    }

    protected void createBookingFiles() throws Exception {
        for (int i = 0; i < 10; ++i) {
            EntityContainer bfc = new EntityContainer(BookingFile.class);
            BookingFile bookingFile = (BookingFile)bfc.getEntity();
            String user = LogicalStorage.get().getUser();
            bfc.setCreatedBy(user);
            bfc.setModifiedBy(user);
            Reservation reservation = new Reservation();
            reservation.setBookingFile(bookingFile);
            bookingFile.getReservations().add(reservation);
            this.addProduct(reservation, bookingFile, "VV", "RUB", this.equivTariffs[i], this.generateTicketNumber(i));
            EntityStorage.get().save(bfc, true);
        }
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile bookingFile = (BookingFile)bfc.getEntity();
        String user = LogicalStorage.get().getUser();
        bfc.setCreatedBy(user);
        bfc.setModifiedBy(user);
        Reservation reservation = new Reservation();
        reservation.setBookingFile(bookingFile);
        bookingFile.getReservations().add(reservation);
        EntityStorage.get().save(bfc, true);
    }

    protected Product addProduct(Reservation reservation, BookingFile bookingFile, String airlineCode, String currencyCode, double equivalentTariff, String ticketNumber) throws Exception {
        Product product = new Product();
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setValidatorCode("111111");
        product.setProductCategory(ProductCategory.AIR);
        product.setBlankOwnerRef(this.findBlankOwnerByCode(airlineCode));
        product.setBlankOwnerNumber("870");
        product.setStatus(ProductStatus.SELL);
        product.setCarrier((DictionaryReference)new AirlineReference(airlineCode));
        product.setCarrierNumber(airlineCode);
        product.setBlankType((DictionaryReference)new BlankTypeReference("870 24"));
        bookingFile.setAgency(new EntityReference(this.ac));
        AirProductHelper.setAgency((Product)product, (EntityReference)this.ac.toReference());
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        Segment segment = new Segment();
        segment.setStartDate(Calendar.getInstance().getTime());
        segment.setAirline((DictionaryReference)new AirlineReference(airlineCode));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("MSC"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("VIE"));
        segment.setFareBasis("farebasis");
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        Money money = new Money();
        money.setValue(BigDecimal.valueOf(equivalentTariff));
        money.setCurrency(currencyCode);
        product.getSegmentTariffs().add(sppPsgr);
        segment = new Segment();
        segment.setStartDate(Calendar.getInstance().getTime());
        segment.setAirline((DictionaryReference)new AirlineReference(airlineCode));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("VIE"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("MSC"));
        segment.setFareBasis("farebasis");
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        money = new Money();
        money.setValue(BigDecimal.valueOf(0.85 * equivalentTariff));
        money.setCurrency(currencyCode);
        product.getSegmentTariffs().add(sppPsgr);
        Money money2 = new Money();
        money2.setValue(BigDecimal.valueOf(1.5 * equivalentTariff));
        money2.setCurrency(currencyCode);
        AirProductHelper.setBaseFare((Product)product, (Money)money2);
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setAmount(SystemHelper.getMoney((double)36.0, (String)"RUB"));
        tax.setEquivalentAmount(BigDecimal.valueOf(72L));
        product.getTaxes().add(tax);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.valueOf(1.5 * equivalentTariff));
        product.setIssueDate(this.issueDate);
        ProductFop fop = new ProductFop();
        fop.setType(PaymentType.CASH);
        Money money3 = new Money();
        money3.setValue(BigDecimal.valueOf(2.0 * equivalentTariff).add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product)));
        money3.setCurrency(currencyCode);
        fop.setAmount(money3);
        fop.setOperationDate(this.issueDate);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setSystemNumber(ticketNumber);
        return product;
    }

    private String generateTicketNumber(int number) {
        return String.format("%1$d", 2405822000L + (long)number);
    }

    protected class VvSalesReportPrepareBookingFilesHandler
    extends VvSalesReportPrepareHandler {
        protected VvSalesReportPrepareBookingFilesHandler() {
        }

        @Override
        public void prepareData(Map<String, Object> data) throws Exception {
            ArrayList messages = new ArrayList();
            data.put("key-messages", messages);
            Collection products = this.getData((Map)data, (List)messages);
            Assert.assertEquals((long)10L, (long)products.size());
        }
    }
}

