/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.agentreport;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.agentreport.BaseAgentReportTest;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AgentReportTest
extends BaseAgentReportTest {
    private final double fare1 = 100.0;
    private final double fare2 = 200.0;
    private final double fare3 = 300.0;
    private final double fare4 = 400.0;
    private static final String TICKET_NO_FIRST_SELL = "004";
    private static final String TICKET_NO_SELL_EXCHANGE = "051";
    private static final String TICKET_NO_SECOND_SELL = "052";
    private static final String TICKET_NO_SIMPLE_SELL_1 = "001";
    private static final String TICKET_NO_SELL_REFUND = "002";
    private static final String TICKET_NO_VOID = "003";
    private static final String TICKET_SELL_CC = "006";
    private static final String MCO_PENALTY = "007";
    private static final String MCO_REFERENCE = "008";
    private static final String TICKET_NO_PTA = "009";
    private static final String TICKET_ETICKET = "010";
    private static final String EMCO_PENALTY = "015";
    private static final String EMCO_REFERENCE = "016";
    private static final String TICKET_CONJUNCTION = "011";
    private static final String TICKET_ISSUED_BEFORE = "020";
    private static final String TICKET_ISSUED_BEFORE2 = "021";
    private static final String TICKET_ISSUED_BEFORE4 = "0214";
    private static final String TICKET_REFUND_ISSUED_BEFORE = "022";
    private static final String TICKET_REFUND_ISSUED_BEFORE2 = "0222";
    private static final String TICKET_UNPAYED = "023";
    private static final String TICKET_ISSUED_BEFORE3 = "024";
    private static final String TICKET_ISSUED_AND_UNPAYED = "025";
    private static final String TICKET_ISSUED_AND_PAYED_AFTER = "026";

    @Override
    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("agentReportTestDictionaries.xml");
    }

    @Test
    public void testReport() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        this.createProduct(TICKET_NO_SIMPLE_SELL_1, 0, this.airlineCode2, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber2, null);
        String prodUid = this.createProduct("0012", 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        ProductSearchResult searchResult = BookingDao.findProductByUid((String)prodUid);
        Product prod = (Product)searchResult.getProduct();
        ArrayList<ProductFop> fops = new ArrayList<ProductFop>();
        List clientFops = AirProductHelper.getClientContractRelation((Product)prod).getFops();
        for (ProductFop fop : clientFops) {
            fop.getAmount().setValue(fop.getAmount().getValue().subtract(BigDecimal.ONE));
            ProductFop newFop = new ProductFop();
            newFop.setAmount(SystemHelper.getMoney((double)1.0, (String)"RUB"));
            newFop.setType(fop.getType());
            newFop.getFares().addAll(fop.getFares());
            newFop.getCommissions().addAll(fop.getCommissions());
            fops.add(newFop);
        }
        clientFops.addAll(fops);
        EntityStorage.get().save(searchResult.getContainer(), false, (EntityStorageSaveParameters)new EntityStorageSaveParameters().ignoreInterceptors(true));
        String pr2 = this.createProduct(TICKET_NO_SELL_REFUND, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, null, PaymentType.INVOICE, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        String refundUid = this.createProduct(TICKET_NO_SELL_REFUND, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.REFUND, pr2, PaymentType.INVOICE, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        this.createProduct(MCO_PENALTY, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, refundUid, PaymentType.INVOICE, ProductCategory.MCO, MCOCategory.PENALTY, false, this.airlineNumber1, null);
        prodUid = this.createProduct(MCO_REFERENCE, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, refundUid, PaymentType.INVOICE, ProductCategory.MCO, MCOCategory.INFORMATION, false, this.airlineNumber1, null);
        EntityStorage.get().save(searchResult.getContainer(), false);
        this.createProduct(TICKET_NO_VOID, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.VOID, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        this.createProduct(TICKET_NO_PTA, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.PTA, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        pr2 = this.createProduct(TICKET_ETICKET, 0, this.airlineCode1, (EntityReference<Organization>)this.suReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, true, this.airlineNumber1, null);
        refundUid = this.createProduct(TICKET_ETICKET, 0, this.airlineCode1, (EntityReference<Organization>)this.suReference, 100.0, ProductStatus.REFUND, pr2, PaymentType.CASH, ProductCategory.AIR, null, true, this.airlineNumber1, null);
        this.createProduct(EMCO_PENALTY, 0, this.airlineCode1, (EntityReference<Organization>)this.suReference, 100.0, ProductStatus.SELL, refundUid, PaymentType.CASH, ProductCategory.MCO, MCOCategory.PENALTY, false, this.airlineNumber1, null);
        this.createProduct(EMCO_REFERENCE, 0, this.airlineCode1, (EntityReference<Organization>)this.suReference, 100.0, ProductStatus.SELL, refundUid, PaymentType.CASH, ProductCategory.MCO, MCOCategory.INFORMATION, false, this.airlineNumber1, null);
        String pr4 = this.createProduct(TICKET_NO_FIRST_SELL, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 300.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        String pr5 = this.createProduct(TICKET_NO_SELL_EXCHANGE, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 300.0, ProductStatus.EXCHANGE, pr4, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        this.createProduct(TICKET_NO_SECOND_SELL, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 400.0, ProductStatus.SELL, pr5, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, BigDecimal.valueOf(10L));
        this.createProduct(TICKET_SELL_CC, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 400.0, ProductStatus.SELL, null, PaymentType.CREDIT_CARD, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        this.createProduct("0062", 0, this.airlineCode2, (EntityReference<Organization>)this.tchReference, 400.0, ProductStatus.SELL, null, PaymentType.CREDIT_CARD, ProductCategory.AIR, null, false, this.airlineNumber2, null);
        this.createProduct(TICKET_CONJUNCTION, 1, this.airlineCode2, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber2, null);
        prodUid = this.createProduct(TICKET_ISSUED_BEFORE, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 400.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        searchResult = BookingDao.findProductByUid((String)prodUid);
        prod = (Product)searchResult.getProduct();
        prod.setIssueDate(new Date(this.issueDate.getTime() - 259200000L));
        EntityStorage.get().save(searchResult.getContainer(), false);
        prodUid = this.createProduct(TICKET_ISSUED_BEFORE2, 0, this.airlineCode2, (EntityReference<Organization>)this.suReference, 400.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber2, null);
        searchResult = BookingDao.findProductByUid((String)prodUid);
        prod = (Product)searchResult.getProduct();
        prod.setCashier(new EntityReference("testUid", Person.class, "test agent"));
        prod.setIssueDate(new Date(this.issueDate.getTime() - 259200000L));
        EntityStorage.get().save(searchResult.getContainer(), false);
        prodUid = this.createProduct(TICKET_ISSUED_BEFORE4, 0, this.airlineCode2, (EntityReference<Organization>)this.suReference, 400.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber2, null);
        searchResult = BookingDao.findProductByUid((String)prodUid);
        prod = (Product)searchResult.getProduct();
        prod.setCashier(new EntityReference("testUid", Person.class, "test agent"));
        prod.setIssueDate(new Date(this.issueDate.getTime() - 259200000L));
        EntityStorage.get().save(searchResult.getContainer(), false);
        pr2 = this.createProduct(TICKET_REFUND_ISSUED_BEFORE, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        refundUid = this.createProduct(TICKET_REFUND_ISSUED_BEFORE, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.REFUND, pr2, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        searchResult = BookingDao.findProductByUid((String)refundUid);
        prod = (Product)searchResult.getProduct();
        prod.setIssueDate(new Date(this.issueDate.getTime() - 259200000L));
        prod.getPreviousProduct().setTicketType(TicketType.EXTERNAL);
        EntityStorage.get().save(searchResult.getContainer(), false);
        pr2 = this.createProduct(TICKET_REFUND_ISSUED_BEFORE2, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        refundUid = this.createProduct(TICKET_REFUND_ISSUED_BEFORE2, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.REFUND, pr2, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        searchResult = BookingDao.findProductByUid((String)refundUid);
        prod = (Product)searchResult.getProduct();
        prod.setIssueDate(new Date(this.issueDate.getTime() - 259200000L));
        prod.getPreviousProduct().setTicketType(TicketType.EXTERNAL);
        EntityStorage.get().save(searchResult.getContainer(), false);
        prodUid = this.createProduct(TICKET_UNPAYED, 0, this.airlineCode2, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber2, null);
        searchResult = BookingDao.findProductByUid((String)prodUid);
        prod = (Product)searchResult.getProduct();
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
            fop.setOperationDate(null);
        }
        prod.setIssueDate(new Date(this.issueDate.getTime() - 259200000L));
        EntityStorage.get().save(searchResult.getContainer(), false);
        prodUid = this.createProduct(TICKET_ISSUED_BEFORE3, 0, this.airlineCode2, (EntityReference<Organization>)this.suReference, 400.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber2, null);
        searchResult = BookingDao.findProductByUid((String)prodUid);
        prod = (Product)searchResult.getProduct();
        prod.setIssueDate(new Date(this.issueDate.getTime() - 259200000L));
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
            fop.setAgent(new EntityReference("testUid", Person.class, "test agent"));
        }
        EntityStorage.get().save(searchResult.getContainer(), false);
        prodUid = this.createProduct(TICKET_ISSUED_AND_UNPAYED, 0, this.airlineCode2, (EntityReference<Organization>)this.suReference, 400.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber2, null);
        searchResult = BookingDao.findProductByUid((String)prodUid);
        prod = (Product)searchResult.getProduct();
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
            fop.setAgent(null);
            fop.setOperationDate(null);
        }
        EntityStorage.get().save(searchResult.getContainer(), false);
        prodUid = this.createProduct(TICKET_ISSUED_AND_PAYED_AFTER, 0, this.airlineCode2, (EntityReference<Organization>)this.suReference, 400.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber2, null);
        searchResult = BookingDao.findProductByUid((String)prodUid);
        prod = (Product)searchResult.getProduct();
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
            fop.setOperationDate(new Date(prod.getIssueDate().getTime() + 259200000L));
        }
        EntityStorage.get().save(searchResult.getContainer(), false);
        File outFile = new File(this.getOutFolder(), "AgentReport.xls");
        HashMap<String, Object> data = new HashMap<String, Object>();
        AgentReportParameters params = new AgentReportParameters();
        Calendar cl = Calendar.getInstance();
        cl.setTime(this.issueDate);
        cl.add(5, -1);
        params.setPeriodBegin(cl.getTime());
        cl.add(5, 2);
        params.setPeriodEnd(cl.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        data.put("key-report-params", params);
        params.setAgent(this.agentContainer.toReference());
        params.getVendors().add(this.tchReference);
        params.getVendors().add(this.suReference);
        params.setTemplate(new EntityReference("agentReportTemplate", TemplateDocument.class, null));
        AgentReportPrepareHandler prepareHandler = new AgentReportPrepareHandler();
        prepareHandler.prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)message.getMessage().getKey(), (boolean)true);
        }
        List batchDataList = (List)data.get("key-batch-data-list");
        ArrayList tickets = new ArrayList(((ReportBatchData)batchDataList.get(0)).getTickets());
        tickets.addAll(((ReportBatchData)batchDataList.get(1)).getTickets());
        boolean foundIssuedAndUnpayed = false;
        for (AgentReportTicket ticket : tickets) {
            if (TICKET_UNPAYED.equals(ticket.getTicketNumber())) {
                Assert.assertTrue((String)"unpayed ticket is in report", (boolean)false);
            }
            if (TICKET_ISSUED_BEFORE3.equals(ticket.getTicketNumber())) {
                Assert.assertTrue((String)"ticket of other agent is in report", (boolean)false);
            }
            if (!TICKET_ISSUED_AND_UNPAYED.equals(ticket.getTicketNumber())) continue;
            foundIssuedAndUnpayed = true;
        }
        if (!foundIssuedAndUnpayed) {
            Assert.assertTrue((String)"issued and unpayed ticket is not in the report", (boolean)false);
        }
        AgentReportRenderHandler renderHandler = new AgentReportRenderHandler();
        EntityContainer renderReport = renderHandler.renderReport(data);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(((ReportFile)((AgentReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("AgentReport.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

