/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.agentreport;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.commission.RouteType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LegalFormReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Manager;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.salesreports.render.agentreport.RenderAgentReportTestBase;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public abstract class BaseAgentReportTest
extends RenderAgentReportTestBase {
    private final double rate1 = 10.0;
    private final double rate2 = 20.0;
    protected String airlineCode1 = "testAirlineCode1";
    protected String airlineCode2 = "testAirlineCode2";
    protected String airlineNumber1 = "026";
    protected String airlineNumber2 = "027";
    protected EntityContainer<Organization> agencyContainer;
    protected EntityContainer<Organization> subagencyContainer;
    protected EntityContainer<Person> agentContainer;
    protected EntityContainer<Organization> clientContainer;
    protected EntityContainer<FeeProperties> sellFee;
    protected EntityContainer<FeeProperties> refundFee;
    protected EntityContainer<FeeProperties> exchangeFee;
    protected EntityContainer<CommissionProperties> commission;
    protected Date issueDate;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        LocaleManager.get().setCurrentLocale(LocaleHelper.RU_LOCALE);
    }

    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("agentReportTestDictionaries.xml");
    }

    protected String createProduct(String ticketNo, int conj, String airline, EntityReference<Organization> blOwner, double fare, ProductStatus status, String relUid, PaymentType paymentType, ProductCategory productCategory, MCOCategory mcoCategory, boolean eticket, String airlineNumber, BigDecimal penalty) throws Exception {
        return this.createProduct((EntityReference<Organization>)this.agencyContainer.toReference(), ticketNo, conj, airline, blOwner, fare, status, relUid, paymentType, productCategory, mcoCategory, eticket, airlineNumber, penalty);
    }

    protected String createProduct(EntityReference<Organization> subagency, String ticketNo, int conj, String airline, EntityReference<Organization> blOwner, double fare, ProductStatus status, String relUid, PaymentType paymentType, ProductCategory productCategory, MCOCategory mcoCategory, boolean eticket, String airlineNumber, BigDecimal penalty) throws Exception {
        Airline carrier;
        EntityContainer bfc = null;
        Product product = null;
        if (!TextUtil.isBlank((String)relUid)) {
            ProductSearchResult searchResult = BookingDao.findProductByUid((String)relUid);
            bfc = searchResult.getContainer();
            Reservation reservation = searchResult.getReservation();
            this.setRecordLocator(reservation, this.tchReference.equals(blOwner) ? GdsName.SIRENA : GdsName.SABRE);
            product = new Product();
            reservation.getProducts().add(product);
            product.setReservation(reservation);
            Product relatedProduct = (Product)searchResult.getProduct();
            if (productCategory == ProductCategory.AIR) {
                product.setPreviousProduct(relatedProduct);
                if (status == ProductStatus.EXCHANGE) {
                    relatedProduct.setNextProduct(product);
                }
            } else {
                product.getRelatedProducts().add(relatedProduct);
            }
        } else {
            bfc = new EntityContainer(BookingFile.class);
            String user = LogicalStorage.get().getUser();
            bfc.setCreated(new Date());
            bfc.setCreatedBy(user);
            bfc.setModified(new Date());
            bfc.setModifiedBy(user);
            BookingFile bf = (BookingFile)bfc.getEntity();
            Reservation reservation = new Reservation();
            this.setRecordLocator(reservation, this.tchReference.equals(blOwner) ? GdsName.SIRENA : GdsName.SABRE);
            bf.getReservations().add(reservation);
            reservation.setBookingFile(bf);
            product = new Product();
            reservation.getProducts().add(product);
            product.setReservation(reservation);
        }
        product.setCashier(this.agentContainer.toReference());
        BookingFile bf = (BookingFile)bfc.getEntity();
        bf.setCustomerProfile(this.clientContainer.toReference());
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        bf.getTravellers().add(traveller);
        product.setTraveller(traveller);
        product.setBlankOwnerRef(blOwner);
        EntityContainer ctr = EntityStorage.get().resolve(blOwner);
        if (ctr != null && ((Organization)ctr.getEntity()).getAirline() != null && (carrier = (Airline)DictionaryCache.get().resolveReference(((Organization)ctr.getEntity()).getAirline())) != null) {
            product.setBlankOwnerNumber(carrier.getAirlineNumber());
        }
        product.setStatus(ProductStatus.SELL);
        product.setCarrier((DictionaryReference)new AirlineReference(airline));
        bf.setAgency(this.agencyContainer.toReference());
        AirProductHelper.setSubagency((Product)product, subagency);
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyContainer.toReference());
        AirProductHelper.setSupplier((Product)product, blOwner);
        product.setProductCategory(productCategory);
        product.setMcoCategory(mcoCategory);
        product.setEticket(eticket);
        product.setPenalty(penalty);
        product.setBlankType((DictionaryReference)new BlankTypeReference(eticket ? "99A \u042d61" : "99A 661"));
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(BigDecimal.valueOf(fare));
        AirProductHelper.setBaseFare((Product)product, (Money)money);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.valueOf(fare));
        double taxAmount = 100.0;
        Tax tax = new Tax();
        tax.setCode(this.tchReference.equals(blOwner) ? "ZZ" : "RU");
        tax.setEquivalentAmount(BigDecimal.valueOf(0.25 * taxAmount));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("YQ");
        tax.setEquivalentAmount(BigDecimal.valueOf(0.75 * taxAmount));
        product.getTaxes().add(tax);
        product.setStatus(status);
        product.setSystemNumber(ticketNo);
        product.setConjCount(conj);
        product.getScns().add(ticketNo);
        product.setIssueDate(this.issueDate);
        product.setCarrierNumber(airlineNumber);
        product.setTicketType(TicketType.OWN);
        product.setTariffType(TariffType.REGULAR);
        product.setValidatorCode("12345678");
        if (product.getStatus() != ProductStatus.VOID) {
            ProductFop pt = new ProductFop();
            pt.setType(paymentType);
            Segment segment = new Segment();
            segment.setRecordNumber(1);
            segment.setStartDate(this.issueDate);
            segment.setAirline((DictionaryReference)new AirlineReference(airline));
            segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("MOW"));
            segment.setArriveLocation((DictionaryReference)new GeoLocationReference("AER"));
            segment.setFareBasis("farebasis");
            SegmentTariff sppPsgr = new SegmentTariff();
            sppPsgr.getSegments().add(segment);
            product.getSegmentTariffs().add(sppPsgr);
            segment = new Segment();
            segment.setRecordNumber(2);
            segment.setStartDate(this.issueDate);
            segment.setAirline((DictionaryReference)new AirlineReference(airline));
            segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("AER"));
            segment.setArriveLocation((DictionaryReference)new GeoLocationReference("MOW"));
            segment.setFareBasis("farebasis");
            sppPsgr = new SegmentTariff();
            sppPsgr.getSegments().add(segment);
            product.getSegmentTariffs().add(sppPsgr);
            if (paymentType.equals((Object)PaymentType.CREDIT_CARD)) {
                Card card = new Card();
                card.setVendor(CardVendor.AMEX);
                pt.setCard(card);
            }
            Money money2 = new Money();
            money2.setCurrency("RUB");
            money2.setValue(BigDecimal.valueOf(fare + taxAmount + (penalty != null ? penalty.doubleValue() : 0.0)));
            pt.setAmount(money2);
            List vendorFops = AirProductHelper.getVendorContractRelation((Product)product).getFops();
            List clientFops = AirProductHelper.getClientContractRelation((Product)product).getFops();
            vendorFops.add(pt);
            ProductFop clientFop = (ProductFop)XCloneHelper.clone((XCloneable)pt, (boolean)true);
            clientFop.setOperationDate(this.issueDate);
            clientFop.setAgent(this.agentContainer.toReference());
            clientFops.add(clientFop);
        }
        EntityStorage.get().save(bfc, false);
        return product.getUid();
    }

    protected void createProfiles() throws Exception {
        String user = LogicalStorage.get().getUser();
        EntityStorage es = EntityStorage.get();
        this.sellFee = new EntityContainer(FeeProperties.class);
        FeeProperties prop = (FeeProperties)this.sellFee.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("fee"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setOperation(Operation.SELL);
        prop.getProductTypes().add(ProductType.AIR_TICKET);
        prop.getReturnCases().add(ReturnCase.EXCHANGE);
        prop.getReturnCases().add(ReturnCase.FORCED_EXCHANGE);
        prop.getReturnCases().add(ReturnCase.REFUND);
        prop.getReturnCases().add(ReturnCase.FORCED_REFUND);
        prop.getRouteTypes().add(RouteType.ONE_WAY);
        prop.getRouteTypes().add(RouteType.ROUND_TRIP);
        prop.setDisplayName("sell fee");
        es.save(this.sellFee, true);
        this.refundFee = new EntityContainer(FeeProperties.class);
        prop = (FeeProperties)this.refundFee.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("refundFee"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setOperation(Operation.REFUND);
        prop.getProductTypes().add(ProductType.AIR_TICKET);
        prop.getReturnCases().add(ReturnCase.REFUND);
        prop.getReturnCases().add(ReturnCase.FORCED_REFUND);
        prop.getRouteTypes().add(RouteType.ONE_WAY);
        prop.getRouteTypes().add(RouteType.ROUND_TRIP);
        prop.setDisplayName("refund fee");
        es.save(this.refundFee, true);
        this.exchangeFee = new EntityContainer(FeeProperties.class);
        prop = (FeeProperties)this.exchangeFee.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("exchangeFee"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setOperation(Operation.EXCHANGE);
        prop.getProductTypes().add(ProductType.AIR_TICKET);
        prop.getRouteTypes().add(RouteType.ONE_WAY);
        prop.getRouteTypes().add(RouteType.ROUND_TRIP);
        prop.setDisplayName("exchange fee");
        es.save(this.exchangeFee, true);
        this.commission = new EntityContainer(CommissionProperties.class);
        prop = (CommissionProperties)this.commission.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("commission"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setDisplayName("commission");
        es.save(this.commission, true);
        this.clientContainer = new EntityContainer(Organization.class);
        this.clientContainer.setCreatedBy(user);
        this.clientContainer.setModifiedBy(user);
        Organization profile = (Organization)this.clientContainer.getEntity();
        profile.getTypes().add(OrganizationType.CORPORATE_CLIENT);
        L10nStringHelper.setValue((L10nString)profile.getShortName(), (String)"Client", (Locale)Locale.ENGLISH);
        profile.setActive(true);
        profile.setCode("001");
        profile.setRegistrationId("0000000016");
        es.save(this.clientContainer, true);
        this.agencyContainer = new EntityContainer(Organization.class);
        this.agencyContainer.setCreatedBy(user);
        this.agencyContainer.setModifiedBy(user);
        Organization agency = (Organization)this.agencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"testAgency", (Locale)Locale.ENGLISH);
        agency.setActive(true);
        agency.setCode("testAgency");
        L10nStringHelper.setValue((L10nString)agency.getFullName(), (String)"testAgency", (Locale)Locale.ENGLISH);
        agency.setLegalForm((DictionaryReference)new LegalFormReference("\u041e\u041e\u041e"));
        Manager director = new Manager();
        director.setType(ManagerType.DIRECTOR);
        director.setName("Mr. director");
        agency.getManagers().add(director);
        Manager accountant = new Manager();
        accountant.setType(ManagerType.CHIEF_ACCOUNTANT);
        accountant.setName("Mr. accountant");
        agency.getManagers().add(accountant);
        SystemHelper.setMetadataValue((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_TCH_AGENCY_CODE, (Object)"\u041c\u041e\u042110");
        es.save(this.agencyContainer, true);
        this.subagencyContainer = new EntityContainer(Organization.class);
        this.subagencyContainer.setCreatedBy(user);
        this.subagencyContainer.setModifiedBy(user);
        agency = (Organization)this.subagencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"testSubagency", (Locale)Locale.ENGLISH);
        agency.setActive(true);
        agency.setCode("testSubagency");
        L10nStringHelper.setValue((L10nString)agency.getFullName(), (String)"testSubagency", (Locale)Locale.ENGLISH);
        agency.setLegalForm((DictionaryReference)new LegalFormReference("\u041e\u041e\u041e"));
        director = new Manager();
        director.setType(ManagerType.DIRECTOR);
        director.setName("Mr. director");
        agency.getManagers().add(director);
        accountant = new Manager();
        accountant.setType(ManagerType.CHIEF_ACCOUNTANT);
        accountant.setName("Mr. accountant");
        agency.getManagers().add(accountant);
        SystemHelper.setMetadataValue((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_TCH_AGENCY_CODE, (Object)"\u041c\u041e\u042110");
        es.save(this.subagencyContainer, true);
        this.agentContainer = new EntityContainer(Person.class);
        Person agent = (Person)this.agentContainer.getEntity();
        agent.setActive(true);
        PersonEmployment placeOfEmployment = new PersonEmployment();
        placeOfEmployment.setOrganization(this.agencyContainer.toReference());
        agent.getEmployments().add(placeOfEmployment);
        L10nStringHelper.setValue((L10nString)agent.getLastName(), (String)"Ivanov", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)agent.getFirstName(), (String)"Ivan", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)agent.getMiddleName(), (String)"Ivanovich", (Locale)Locale.ENGLISH);
        es.save(this.agentContainer, true);
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        cc.setCreatedBy(user);
        cc.setModifiedBy(user);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(this.tchReference);
        info.setCustomer(new EntityReference(this.agencyContainer));
        contract.setVendor(this.tchReference);
        info.setNumber("01");
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("fare1");
        RuleRestriction restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.AIRLINES);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)this.airlineCode1);
        rs.getRestrictions().add(restr);
        RuleResult res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(this.commission.toReference());
        value.setValue(10.0);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("fare2");
        restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.AIRLINES);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)this.airlineCode2);
        rs.getRestrictions().add(restr);
        res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setValue(20.0);
        value.setTarget(this.commission.toReference());
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        es.save(cc, true);
        EntityContainer suContractCtr = new EntityContainer(Contract.class);
        contract = (Contract)suContractCtr.getEntity();
        XCloneModelHelper.copy((BaseEntity)cc, (BaseEntity)suContractCtr, (boolean)true);
        contract.setVendor(this.suReference);
        contract.setSupplier(this.suReference);
        ((ContractCustomerInfo)contract.getCustomers().get(0)).setCustomer(this.agencyContainer.toReference());
        es.save(suContractCtr, true);
        EntityContainer clientContractCtr = new EntityContainer(Contract.class);
        contract = (Contract)clientContractCtr.getEntity();
        XCloneModelHelper.copy((BaseEntity)cc, (BaseEntity)clientContractCtr, (boolean)true);
        contract.setContractType(ContractType.CLIENT);
        contract.setSupplier(this.agencyContainer.toReference());
        ((ContractCustomerInfo)contract.getCustomers().get(0)).setCustomer(this.clientContainer.toReference());
        contract.setVendor(null);
        RuleSet rules2 = new RuleSet();
        RuleSettings rs2 = new RuleSettings();
        rs2.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs2.setName("fee");
        RuleResult res2 = new RuleResult();
        res2.setAction((RuleAction)Actions.SIMPLE_FEE);
        RuleResultValue value2 = new RuleResultValue();
        value2.setCurrencyCode("RUB");
        value2.setValue(30.0);
        value2.setTarget(this.sellFee.toReference());
        res2.setValue((Object)value2);
        rs2.getResults().add(res2);
        res2 = new RuleResult();
        res2.setAction((RuleAction)Actions.SIMPLE_FEE);
        value2 = new RuleResultValue();
        value2.setCurrencyCode("RUB");
        value2.setValue(10.0);
        value2.setTarget(this.refundFee.toReference());
        res2.setValue((Object)value2);
        rs2.getResults().add(res2);
        res2 = new RuleResult();
        res2.setAction((RuleAction)Actions.SIMPLE_FEE);
        value2 = new RuleResultValue();
        value2.setCurrencyCode("RUB");
        value2.setValue(10.0);
        value2.setTarget(this.exchangeFee.toReference());
        res2.setValue((Object)value2);
        rs2.getResults().add(res2);
        rules2.getRules().add(rs2);
        contract.setRuleSet(rules2);
        es.save(clientContractCtr, true);
    }
}

