/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.agentreport;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.commission.RouteType;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryRegion;
import com.gridnine.xtrip.common.model.delivery.DeliveryRegionReference;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.LegalFormReference;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Manager;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointType;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.reports.salesreports.render.agentreport.BaseAgentReportTest;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;

public abstract class BaseDeliveryAgentReportTest
extends BaseAgentReportTest {
    protected EntityContainer<SalesPoint> salesPointContainer;

    protected Delivery createDelivery(String ticketNo, DeliveryStatus status, BigDecimal deliveryCost, PaymentType paymentType, String relUid) throws Exception {
        EntityContainer bfc = null;
        Delivery ticket = null;
        if (!TextUtil.isBlank((String)relUid)) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)relUid));
            bfc = EntityStorage.get().resolve(((DeliveryIndex)EntityStorage.get().search(DeliveryIndex.class, query).getData().get(0)).getSource());
            Delivery relatedProduct = (Delivery)BookingHelper.findProduct((BookingFile)((BookingFile)bfc.getEntity()), (String)relUid);
            Reservation reservation = relatedProduct.getReservation();
            ticket = new Delivery();
            reservation.getProducts().add(ticket);
            ticket.setPreviousProduct(relatedProduct);
            ticket.setReservation(reservation);
        } else {
            bfc = new EntityContainer(BookingFile.class);
            bfc.setCreated(new Date());
            bfc.setModified(new Date());
            BookingFile bf = (BookingFile)bfc.getEntity();
            bf.setCustomerProfile(this.clientContainer.toReference());
            Reservation reservation = new Reservation();
            this.setRecordLocator(reservation, GdsName.SIRENA);
            bf.getReservations().add(reservation);
            reservation.setBookingFile(bf);
            ticket = new Delivery();
            reservation.getProducts().add(ticket);
            ticket.setReservation(reservation);
            Traveller traveller = new Traveller();
            traveller.setName("Testov");
            bf.getTravellers().add(traveller);
        }
        ticket.setStatus(status);
        BookingFile bookingFile = (BookingFile)bfc.getEntity();
        bookingFile.setCustomerProfile(this.clientContainer.toReference());
        ticket.setAgency(this.agencyContainer.toReference());
        ticket.setAgent(this.agentContainer.toReference());
        ticket.setIssueDate(this.issueDate);
        ticket.setSystemNumber(ticketNo);
        ticket.setSalesPoint(this.salesPointContainer.toReference());
        ticket.setDeliveryRegion((DictionaryReference)new DeliveryRegionReference("MOW"));
        GeneralProductCommission comm = new GeneralProductCommission();
        comm.setEquivalentAmount(deliveryCost);
        comm.setContractType(ContractType.CLIENT);
        comm.setCommissionProperties(this.sellFee.toReference());
        ticket.getCommissions().add(comm);
        ticket.setContractRulesApplied(true);
        GeneralProductFop clientFop = new GeneralProductFop();
        clientFop.setType(paymentType);
        clientFop.setEquivalentAmount(deliveryCost);
        clientFop.setAgent(this.agentContainer.toReference());
        clientFop.setOperationDate(this.issueDate);
        clientFop.getCommissions().add(comm);
        ticket.getClientFops().add(clientFop);
        EntityStorage.get().save(bfc, true);
        return (Delivery)BookingHelper.findProduct((BookingFile)((BookingFile)bfc.getEntity()), (String)ticket.getUid());
    }

    @Override
    protected void createProfiles() throws Exception {
        String user = LogicalStorage.get().getUser();
        EntityStorage es = EntityStorage.get();
        DeliveryRegion region = new DeliveryRegion();
        region.setCode("MOW");
        region.getTranslations().put(new Locale("ru"), "\u041c\u043e\u0441\u043a\u0432\u0430");
        DictionaryStorage.get().save((BaseDictionary)region);
        this.sellFee = new EntityContainer(FeeProperties.class);
        FeeProperties prop = (FeeProperties)this.sellFee.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("fee"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setOperation(Operation.SELL);
        prop.getProductTypes().add(ProductType.DELIVERY);
        prop.getReturnCases().add(ReturnCase.EXCHANGE);
        prop.getReturnCases().add(ReturnCase.FORCED_EXCHANGE);
        prop.getReturnCases().add(ReturnCase.REFUND);
        prop.getReturnCases().add(ReturnCase.FORCED_REFUND);
        prop.getRouteTypes().add(RouteType.ONE_WAY);
        prop.getRouteTypes().add(RouteType.ROUND_TRIP);
        prop.setDisplayName("sell fee");
        es.save(this.sellFee, true);
        this.sellFee.toReference();
        this.clientContainer = new EntityContainer(Organization.class);
        this.clientContainer.setCreatedBy(user);
        this.clientContainer.setModifiedBy(user);
        Organization profile = (Organization)this.clientContainer.getEntity();
        L10nStringHelper.setValue((L10nString)profile.getShortName(), (String)"Client", (Locale)Locale.ENGLISH);
        profile.setActive(true);
        profile.setCode("001");
        profile.setRegistrationId("0000000016");
        es.save(this.clientContainer, true);
        this.agencyContainer = new EntityContainer(Organization.class);
        this.agencyContainer.setCreatedBy(user);
        this.agencyContainer.setModifiedBy(user);
        Organization entity = (Organization)this.agencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)entity.getShortName(), (String)"testAgency", (Locale)Locale.ENGLISH);
        entity.setActive(true);
        entity.setCode("testAgency");
        L10nStringHelper.setValue((L10nString)entity.getFullName(), (String)"testAgency", (Locale)Locale.ENGLISH);
        entity.setLegalForm((DictionaryReference)new LegalFormReference("\u041e\u041e\u041e"));
        Manager director = new Manager();
        director.setType(ManagerType.DIRECTOR);
        director.setName("Mr. director");
        entity.getManagers().add(director);
        Manager accountant = new Manager();
        accountant.setType(ManagerType.CHIEF_ACCOUNTANT);
        accountant.setName("Mr. accountant");
        entity.getManagers().add(accountant);
        SystemHelper.setMetadataValue((Collection)entity.getMetadata(), (MetadataKey)MetadataKey.KEY_TCH_AGENCY_CODE, (Object)"\u041c\u041e\u042110");
        es.save(this.agencyContainer, true);
        this.salesPointContainer = new EntityContainer(SalesPoint.class);
        entity = (SalesPoint)this.salesPointContainer.getEntity();
        entity.setAgency(this.agencyContainer.toReference());
        entity.setCode("001SP");
        entity.setFullName("Test Sales Point");
        entity.setShortName("Test Sales Point");
        entity.setType(SalesPointType.SALES_OFFICE);
        es.save(this.salesPointContainer, true);
        this.agentContainer = new EntityContainer(Person.class);
        entity = (Person)this.agentContainer.getEntity();
        entity.setActive(true);
        PersonEmployment placeOfEmployment = new PersonEmployment();
        placeOfEmployment.setOrganization(this.agencyContainer.toReference());
        entity.getEmployments().add(placeOfEmployment);
        L10nStringHelper.setValue((L10nString)entity.getLastName(), (String)"Ivanov", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)entity.getFirstName(), (String)"Ivan", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)entity.getMiddleName(), (String)"Ivanovich", (Locale)Locale.ENGLISH);
        PlaceOfSales placeOfSales = new PlaceOfSales();
        placeOfSales.setSalesPoint(this.salesPointContainer.toReference());
        entity.getSalesPoints().add(placeOfSales);
        es.save(this.agentContainer, true);
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        cc.setCreatedBy(user);
        cc.setModifiedBy(user);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.CLIENT);
        contract.setSupplier(this.agencyContainer.toReference());
        ((ContractCustomerInfo)contract.getCustomers().get(0)).setCustomer(this.clientContainer.toReference());
        contract.setVendor(null);
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.DELIVERY);
        rs.setName("fee");
        RuleResult res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_FEE);
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("RUB");
        value.setValue(30.0);
        value.setTarget(this.sellFee.toReference());
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        es.save(cc, true);
    }
}

