/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.agentreport;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.MCOFeesType;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.MCOFeesHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.reports.salesreports.render.agentreport.BaseAgentReportTest;
import java.math.BigDecimal;

public abstract class BaseMCOFeesAgentReportTest
extends BaseAgentReportTest {
    protected MCOFees createMCO(String ticketNo, String origProductUid) throws Exception {
        EntityContainer bfc = null;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)origProductUid));
        bfc = EntityStorage.get().resolve(((ProductIndex)EntityStorage.get().search(ProductIndex.class, query).getData().get(0)).getSource());
        Product relatedProduct = (Product)BookingHelper.findProduct((BookingFile)((BookingFile)bfc.getEntity()), (String)origProductUid);
        if (relatedProduct.getStatus() == ProductStatus.REFUND) {
            for (Reservation res : ((BookingFile)bfc.getEntity()).getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    MCOFees mco;
                    if (!(bp instanceof MCOFees) || !(mco = (MCOFees)bp).getRelatedProductsUids().contains(relatedProduct.getPreviousProduct().getUid())) continue;
                    mco = MCOFeesHelper.createRefund((MCOFees)mco);
                    mco.setIssueDate(this.issueDate);
                    EntityStorage.get().save(bfc, true);
                    return mco;
                }
            }
            return null;
        }
        MCOFees mco = new MCOFees();
        mco.setAgency(this.agencyContainer.toReference());
        mco.setAgent(this.agentContainer.toReference());
        mco.setBlankType((DictionaryReference)new BlankTypeReference("99A K95"));
        mco.setIssueDate(this.issueDate);
        mco.setReservation(relatedProduct.getReservation());
        relatedProduct.getReservation().getProducts().add(mco);
        mco.setScn(ticketNo);
        mco.setStatus(relatedProduct.getStatus());
        mco.setType(MCOFeesType.FEES);
        mco.setTravellerUid(relatedProduct.getTraveller().getUid());
        mco.getRelatedProductsUids().add(relatedProduct.getUid());
        mco.setType(MCOFeesType.FEES);
        mco.setChecked(true);
        mco.setBlankType((DictionaryReference)((BlankType)DictionaryCache.get().getAll(BlankType.class).get("99A K95")).toReference());
        MCOFeesSource source = new MCOFeesSource();
        source.setProductUid(relatedProduct.getUid());
        source.setTicketNumber(relatedProduct.getSystemNumber());
        Money m = new Money();
        m.setCurrency("RUB");
        m.setValue(BigDecimal.valueOf(50L));
        source.setFare(m);
        source.setActive(true);
        mco.getSources().add(source);
        mco.setFare(BigDecimal.valueOf(33L));
        mco.setTotal(BigDecimal.valueOf(33L));
        mco.setPaymentType(PaymentType.CASH);
        MCOFeesHelper.recalculate((MCOFees)mco);
        EntityStorage.get().save(bfc, true);
        return mco;
    }
}

