/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.agentreport;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.commission.RouteType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameter;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterRole;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.LegalFormReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.UniversalProductRuleEnvironment;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.reports.salesreports.render.agentreport.BaseAgentReportTest;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;

public abstract class BaseUniversalProductAgentReportTest
extends BaseAgentReportTest {
    protected EntityReference<UniversalProductDescription> descriptionRef;

    protected UniversalProduct createTicket(String ticketNo, double fare, ProductStatus status, String relUid, PaymentType paymentType, boolean eticket, BigDecimal penalty) throws Exception {
        Reservation reservation;
        EntityContainer bfc = null;
        UniversalProduct ticket = null;
        if (!TextUtil.isBlank((String)relUid)) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)relUid));
            bfc = EntityStorage.get().resolve(((UniversalProductIndex)EntityStorage.get().search(UniversalProductIndex.class, query).getData().get(0)).getSource());
            UniversalProduct relatedProduct = (UniversalProduct)BookingHelper.findProduct((BookingFile)((BookingFile)bfc.getEntity()), (String)relUid);
            reservation = relatedProduct.getReservation();
            this.setRecordLocator(reservation, GdsName.SIRENA);
            ticket = new UniversalProduct();
            reservation.getProducts().add(ticket);
            ticket.setPreviousProduct(relatedProduct);
            ticket.getTravellersUids().add(relatedProduct.getTravellersUids().iterator().next());
        } else {
            bfc = new EntityContainer(BookingFile.class);
            String user = LogicalStorage.get().getUser();
            bfc.setCreated(new Date());
            bfc.setCreatedBy(user);
            bfc.setModified(new Date());
            bfc.setModifiedBy(user);
            BookingFile bf = (BookingFile)bfc.getEntity();
            bf.setCustomerProfile(this.clientContainer.toReference());
            reservation = new Reservation();
            this.setRecordLocator(reservation, GdsName.SIRENA);
            bf.getReservations().add(reservation);
            reservation.setBookingFile(bf);
            ticket = new UniversalProduct();
            reservation.getProducts().add(ticket);
            ticket.setReservation(reservation);
            Traveller traveller = new Traveller();
            traveller.setName("Testov");
            bf.getTravellers().add(traveller);
            ticket.getTravellersUids().add(traveller.getUid());
        }
        ticket.setDescription(this.descriptionRef);
        BookingFile bookingFile = (BookingFile)bfc.getEntity();
        bookingFile.setCustomerProfile(this.clientContainer.toReference());
        bookingFile.setAgency(this.agencyContainer.toReference());
        UniversalProductHelper.setAgency((UniversalProduct)ticket, (EntityReference)this.agencyContainer.toReference());
        ticket.setBlankOwner(this.tchReference);
        ticket.setAgent(this.agentContainer.toReference());
        ticket.setEquivalentFare(BigDecimal.valueOf(fare));
        ticket.setBlankType((DictionaryReference)new BlankTypeReference(eticket ? "99A \u042d61" : "99A 661"));
        ticket.setEticket(eticket);
        ticket.setIssueDate(this.issueDate);
        ticket.setStatus(ProductStatus.SELL);
        UniversalProductHelper.setSubagency((UniversalProduct)ticket, (EntityReference)this.agencyContainer.toReference());
        UniversalProductHelper.setSupplier((UniversalProduct)ticket, (EntityReference)this.tchReference);
        ticket.setSystemNumber(ticketNo);
        ticket.setTicketType(TicketType.OWN);
        UniversalProductCustomParameter customParameter = new UniversalProductCustomParameter();
        customParameter.setId("route");
        customParameter.setValue((Object)"test route");
        ticket.getCustomParameters().add(customParameter);
        GeneralProductFop vendorFop = new GeneralProductFop();
        vendorFop.setType(paymentType);
        vendorFop.setEquivalentAmount(BigDecimal.valueOf(fare));
        vendorFop.setAgent(this.agentContainer.toReference());
        vendorFop.setOperationDate(this.issueDate);
        UniversalProductHelper.getVendorFops((UniversalProduct)ticket).add(vendorFop);
        GeneralProductFop clientFop = new GeneralProductFop();
        clientFop.setType(paymentType);
        clientFop.setEquivalentAmount(BigDecimal.valueOf(fare));
        clientFop.setAgent(this.agentContainer.toReference());
        clientFop.setOperationDate(this.issueDate);
        UniversalProductHelper.getClientFops((UniversalProduct)ticket).add(clientFop);
        EntityStorage.get().save(bfc, true);
        return (UniversalProduct)BookingHelper.findProduct((BookingFile)((BookingFile)bfc.getEntity()), (String)ticket.getUid());
    }

    @Override
    protected void createProfiles() throws Exception {
        String user = LogicalStorage.get().getUser();
        EntityStorage es = EntityStorage.get();
        UniversalProductDescription description = new UniversalProductDescription();
        description.setExchangeSupported(true);
        description.setName("custom product");
        description.setRefundSupported(true);
        description.setRulesSupported(true);
        description.setTaxesSupported(true);
        UniversalProductCustomParameterDescription customParameterDescription = new UniversalProductCustomParameterDescription();
        customParameterDescription.setDisplayName("route");
        customParameterDescription.setId("route");
        customParameterDescription.setRole(UniversalProductCustomParameterRole.ROUTE_LINE);
        customParameterDescription.setType(UniversalProductCustomParameterType.STRING);
        description.getCustomParameters().add(customParameterDescription);
        EntityContainer descriptionCtr = EntityContainer.create((BaseEntity)description);
        es.save(descriptionCtr, true);
        this.descriptionRef = descriptionCtr.toReference();
        new UniversalProductRuleEnvironment().initializeEnvironment(Arrays.asList(this.descriptionRef));
        this.sellFee = new EntityContainer(FeeProperties.class);
        FeeProperties prop = (FeeProperties)this.sellFee.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("fee"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setOperation(Operation.SELL);
        prop.getProductTypes().add(ProductType.AIR_TICKET);
        prop.getProductTypes().add(ProductType.MISC_PRODUCT);
        prop.getReturnCases().add(ReturnCase.EXCHANGE);
        prop.getReturnCases().add(ReturnCase.FORCED_EXCHANGE);
        prop.getReturnCases().add(ReturnCase.REFUND);
        prop.getReturnCases().add(ReturnCase.FORCED_REFUND);
        prop.getRouteTypes().add(RouteType.ONE_WAY);
        prop.getRouteTypes().add(RouteType.ROUND_TRIP);
        prop.setDisplayName("sell fee");
        es.save(this.sellFee, true);
        this.refundFee = new EntityContainer(FeeProperties.class);
        prop = (FeeProperties)this.refundFee.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("refundFee"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setOperation(Operation.REFUND);
        prop.getProductTypes().add(ProductType.AIR_TICKET);
        prop.getProductTypes().add(ProductType.MISC_PRODUCT);
        prop.getReturnCases().add(ReturnCase.REFUND);
        prop.getReturnCases().add(ReturnCase.FORCED_REFUND);
        prop.getRouteTypes().add(RouteType.ONE_WAY);
        prop.getRouteTypes().add(RouteType.ROUND_TRIP);
        prop.setDisplayName("refund fee");
        es.save(this.refundFee, true);
        this.exchangeFee = new EntityContainer(FeeProperties.class);
        prop = (FeeProperties)this.exchangeFee.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("exchangeFee"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setOperation(Operation.EXCHANGE);
        prop.getProductTypes().add(ProductType.AIR_TICKET);
        prop.getProductTypes().add(ProductType.MISC_PRODUCT);
        prop.getRouteTypes().add(RouteType.ONE_WAY);
        prop.getRouteTypes().add(RouteType.ROUND_TRIP);
        prop.setDisplayName("exchange fee");
        es.save(this.exchangeFee, true);
        this.commission = new EntityContainer(CommissionProperties.class);
        prop = (CommissionProperties)this.commission.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("commission"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setDisplayName("commission");
        es.save(this.commission, true);
        this.clientContainer = new EntityContainer(Organization.class);
        this.clientContainer.setCreatedBy(user);
        this.clientContainer.setModifiedBy(user);
        Organization profile = (Organization)this.clientContainer.getEntity();
        L10nStringHelper.setValue((L10nString)profile.getShortName(), (String)"Client", (Locale)Locale.ENGLISH);
        profile.setActive(true);
        profile.setCode("001");
        profile.setRegistrationId("0000000016");
        es.save(this.clientContainer, true);
        this.agencyContainer = new EntityContainer(Organization.class);
        this.agencyContainer.setCreatedBy(user);
        this.agencyContainer.setModifiedBy(user);
        Organization agency = (Organization)this.agencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"testAgency", (Locale)Locale.ENGLISH);
        agency.setActive(true);
        agency.setCode("testAgency");
        L10nStringHelper.setValue((L10nString)agency.getFullName(), (String)"testAgency", (Locale)Locale.ENGLISH);
        agency.setLegalForm((DictionaryReference)new LegalFormReference("\u041e\u041e\u041e"));
        SystemHelper.setMetadataValue((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_TCH_AGENCY_CODE, (Object)"\u041c\u041e\u042110");
        es.save(this.agencyContainer, true);
        this.subagencyContainer = new EntityContainer(Organization.class);
        this.subagencyContainer.setCreatedBy(user);
        this.subagencyContainer.setModifiedBy(user);
        agency = (Organization)this.subagencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"testSubagency", (Locale)Locale.ENGLISH);
        agency.setActive(true);
        agency.setCode("testSubagency");
        L10nStringHelper.setValue((L10nString)agency.getFullName(), (String)"testSubagency", (Locale)Locale.ENGLISH);
        agency.setLegalForm((DictionaryReference)new LegalFormReference("\u041e\u041e\u041e"));
        SystemHelper.setMetadataValue((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_TCH_AGENCY_CODE, (Object)"\u041c\u041e\u042110");
        es.save(this.subagencyContainer, true);
        this.agentContainer = new EntityContainer(Person.class);
        Person agent = (Person)this.agentContainer.getEntity();
        agent.setActive(true);
        PersonEmployment placeOfEmployment = new PersonEmployment();
        placeOfEmployment.setOrganization(this.agencyContainer.toReference());
        agent.getEmployments().add(placeOfEmployment);
        L10nStringHelper.setValue((L10nString)agent.getLastName(), (String)"Ivanov", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)agent.getFirstName(), (String)"Ivan", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)agent.getMiddleName(), (String)"Ivanovich", (Locale)Locale.ENGLISH);
        es.save(this.agentContainer, true);
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        cc.setCreatedBy(user);
        cc.setModifiedBy(user);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(this.tchReference);
        info.setCustomer(new EntityReference(this.agencyContainer));
        contract.setVendor(this.tchReference);
        info.setNumber("01");
        RuleTarget ruleTarget = RulesEnvironment.get().findTarget(UniversalProductHelper.getRuleTargetId(this.descriptionRef));
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget(ruleTarget);
        rs.setName("fare1");
        RuleResult res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(this.commission.toReference());
        value.setValue(5.0);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        es.save(cc, true);
        EntityContainer clientContractCtr = new EntityContainer(Contract.class);
        contract = (Contract)clientContractCtr.getEntity();
        XCloneModelHelper.copy((BaseEntity)cc, (BaseEntity)clientContractCtr, (boolean)true);
        contract.setContractType(ContractType.CLIENT);
        contract.setSupplier(this.agencyContainer.toReference());
        ((ContractCustomerInfo)contract.getCustomers().get(0)).setCustomer(this.clientContainer.toReference());
        contract.setVendor(null);
        RuleSet rules2 = new RuleSet();
        RuleSettings rs2 = new RuleSettings();
        rs2.setTarget(ruleTarget);
        rs2.setName("fee");
        RuleResult res2 = new RuleResult();
        res2.setAction((RuleAction)Actions.SIMPLE_FEE);
        RuleResultValue value2 = new RuleResultValue();
        value2.setCurrencyCode("RUB");
        value2.setValue(30.0);
        value2.setTarget(this.sellFee.toReference());
        res2.setValue((Object)value2);
        rs2.getResults().add(res2);
        res2 = new RuleResult();
        res2.setAction((RuleAction)Actions.SIMPLE_FEE);
        value2 = new RuleResultValue();
        value2.setCurrencyCode("RUB");
        value2.setValue(10.0);
        value2.setTarget(this.refundFee.toReference());
        res2.setValue((Object)value2);
        rs2.getResults().add(res2);
        res2 = new RuleResult();
        res2.setAction((RuleAction)Actions.SIMPLE_FEE);
        value2 = new RuleResultValue();
        value2.setCurrencyCode("RUB");
        value2.setValue(10.0);
        value2.setTarget(this.exchangeFee.toReference());
        res2.setValue((Object)value2);
        rs2.getResults().add(res2);
        rules2.getRules().add(rs2);
        contract.setRuleSet(rules2);
        es.save(clientContractCtr, true);
    }
}

