/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.agentreport;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.commission.RouteType;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportRenderHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.agentreport.BaseAgentReportTest;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class Bug1130Test
extends BaseAgentReportTest {
    private final double fare1 = 100.0;
    private static final String TICKET_NO_SELL_INFANT = "002";
    private static final String TICKET_NO_ADDITIONAL_FEE = "003";

    @Override
    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("agentReportTestDictionaries.xml");
    }

    @Test
    public void testReport() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        String prodUid = this.createProduct(TICKET_NO_SELL_INFANT, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        ProductSearchResult searchResult = BookingDao.findProductByUid((String)prodUid);
        Product prod = (Product)searchResult.getProduct();
        prod.getFares().clear();
        ProductFare fare = new ProductFare();
        fare.setBaseFare(SystemHelper.getMoney((double)0.0, (String)"RUB"));
        fare.setEquivalentFare(BigDecimal.ZERO);
        prod.getFares().add(fare);
        AirProductHelper.clearCommissions((Product)prod);
        AirProductHelper.clearFops((Product)prod);
        prod.getTaxes().clear();
        this.updateGeneralContractRelationsData(prod);
        EntityStorage.get().save(searchResult.getContainer(), false);
        EntityContainer addFee = new EntityContainer(FeeProperties.class);
        FeeProperties prop = (FeeProperties)addFee.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("addFee"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setOperation(Operation.SELL);
        prop.getProductTypes().add(ProductType.AIR_TICKET);
        prop.getReturnCases().add(ReturnCase.EXCHANGE);
        prop.getReturnCases().add(ReturnCase.FORCED_EXCHANGE);
        prop.getReturnCases().add(ReturnCase.REFUND);
        prop.getReturnCases().add(ReturnCase.FORCED_REFUND);
        prop.getRouteTypes().add(RouteType.ONE_WAY);
        prop.getRouteTypes().add(RouteType.ROUND_TRIP);
        EntityStorage.get().save(addFee, true);
        String prodUid2 = this.createProduct(TICKET_NO_ADDITIONAL_FEE, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        ProductSearchResult searchResult2 = BookingDao.findProductByUid((String)prodUid2);
        Product prod2 = (Product)searchResult2.getProduct();
        AirProductContractRelationData clientContractRelation = AirProductHelper.getClientContractRelation((Product)prod2);
        Commission comm = new Commission();
        comm.setAmount(SystemHelper.getMoney((double)100.0, (String)"RUB"));
        comm.setCommissionProperties(addFee.toReference());
        comm.setContractType(ContractType.CLIENT);
        comm.setEquivalentAmount(BigDecimal.valueOf(100L));
        clientContractRelation.getCommissions().add(comm);
        for (ProductFop fop : clientContractRelation.getFops()) {
            if (fop.getCommissions().isEmpty()) continue;
            fop.getAmount().setValue(fop.getAmount().getValue().add(BigDecimal.valueOf(100L)));
        }
        prod2.setIssueDate(new Date(prod2.getIssueDate().getTime() - 259200000L));
        this.updateGeneralContractRelationsData(prod2);
        EntityStorage.get().save(searchResult2.getContainer(), false);
        File outFile = new File(this.getOutFolder(), "bug1130.xls");
        HashMap<String, Object> data = new HashMap<String, Object>();
        AgentReportParameters params = new AgentReportParameters();
        Calendar cl = Calendar.getInstance();
        cl.setTime(this.issueDate);
        cl.add(5, -1);
        params.setPeriodBegin(cl.getTime());
        cl.add(5, 2);
        params.setPeriodEnd(cl.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        data.put("key-report-params", params);
        params.setAgent(this.agentContainer.toReference());
        params.getVendors().add(this.tchReference);
        params.getVendors().add(this.suReference);
        params.setTemplate(new EntityReference("agentReportTemplate", TemplateDocument.class, null));
        AgentReportPrepareHandler prepareHandler = new AgentReportPrepareHandler();
        prepareHandler.prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)message.getMessage().getKey(), (boolean)true);
        }
        AgentReportRenderHandler renderHandler = new AgentReportRenderHandler();
        EntityContainer renderReport = renderHandler.renderReport(data);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(((ReportFile)((AgentReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("bug1130.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    private void updateGeneralContractRelationsData(Product product) {
        String pccCurrency = product.getGdsCurrency();
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations((Product)product)) {
            if (GeneralProductHelper.getContractType((EntityReference)item.getDescription()) != ContractType.VENDOR && pccCurrency != null && item.getGeneralData().getCurrency() != null && !item.getGeneralData().getCurrency().getCode().equals(pccCurrency)) continue;
            BigDecimal fare = AirProductHelper.getEquivalentFare((Product)product);
            if (fare == null) {
                fare = BigDecimal.ZERO;
            }
            BigDecimal price = fare;
            BigDecimal taxes = AirProductTaxHelper.getEquivalentTaxesAmount((Product)product);
            price = price.add(taxes);
            BigDecimal penalty = product.getPenalty();
            if (penalty == null) {
                penalty = BigDecimal.ZERO;
            }
            price = product.getStatus() == ProductStatus.EXCHANGE || product.getStatus() == ProductStatus.REFUND ? price.subtract(penalty) : price.add(penalty);
            BigDecimal obFeesValue = AirProductHelper.getObFeesValue((Product)product);
            price = price.add(obFeesValue);
            item.getServiceData().setTotalPrice(price);
            item.getServiceData().setPaymentPrice(price);
            item.getServiceData().getDetalization().setFare(fare);
            item.getServiceData().getDetalization().getTaxes().clear();
            item.getServiceData().getDetalization().getTaxes().addAll(AirProductTaxHelper.getSimpleTaxes((Product)product));
            item.getServiceData().getDetalization().setPenalty(penalty);
            item.getServiceData().getDetalization().setObFees(obFeesValue);
            BigDecimal penaltyWithMcoValue = AirProductHelper.getPenaltyWithMcoValue((Product)product);
            item.getServiceData().getDetalization().setPenaltyWithMcoValue(penaltyWithMcoValue == null ? BigDecimal.ZERO : penaltyWithMcoValue);
        }
    }
}

