/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.agentreport;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportRenderHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.agentreport.BaseAgentReportTest;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class Bug1190Test
extends BaseAgentReportTest {
    private final double fare2 = 200.0;
    private final double fare3 = 300.0;

    @Override
    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("agentReportTestDictionaries.xml");
    }

    @Test
    public void testReport() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        String pr1 = this.createProduct((EntityReference<Organization>)this.subagencyContainer.toReference(), "01", 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, null, PaymentType.INVOICE, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        String pr2 = this.createProduct((EntityReference<Organization>)this.subagencyContainer.toReference(), "01", 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.EXCHANGE, pr1, PaymentType.INVOICE, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        String pr3 = this.createProduct((EntityReference<Organization>)this.subagencyContainer.toReference(), "02", 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 300.0, ProductStatus.SELL, pr2, PaymentType.TICKET, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        ProductSearchResult searchResult = BookingDao.findProductByUid((String)pr3);
        Product prod = (Product)searchResult.getProduct();
        Product exchange = (Product)BookingDao.findProductByUid((String)pr2).getProduct();
        Product firstSell = (Product)BookingDao.findProductByUid((String)pr1).getProduct();
        exchange.setPreviousProduct(firstSell);
        exchange.setNextProduct(prod);
        firstSell.setNextProduct(exchange);
        prod.setPreviousProduct(exchange);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)prod), false);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)exchange), false);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)firstSell), false);
        EntityStorage.get().save(BookingDao.findProductByUid((String)pr1).getContainer(), false);
        ProductFare fare = (ProductFare)prod.getFares().get(0);
        fare.setEquivalentFare(BigDecimal.valueOf(300.0));
        fare.getBaseFare().setValue(BigDecimal.valueOf(300.0));
        ProductFop clFop = (ProductFop)AirProductHelper.getClientContractRelation((Product)prod).getFops().get(0);
        List vendorFops = AirProductHelper.getVendorContractRelation((Product)prod).getFops();
        List clientFops = AirProductHelper.getClientContractRelation((Product)prod).getFops();
        ProductFop fop = new ProductFop();
        fop.setType(PaymentType.INVOICE);
        fop.setAgent(clFop.getAgent());
        fop.setOperationDate(clFop.getOperationDate());
        fop.setAmount(SystemHelper.getMoney((double)100.0, (String)"RUB"));
        vendorFops.add(fop);
        fop = new ProductFop();
        fop.setType(PaymentType.INVOICE);
        fop.setAgent(clFop.getAgent());
        fop.setOperationDate(clFop.getOperationDate());
        fop.setAmount(SystemHelper.getMoney((double)100.0, (String)"RUB"));
        clientFops.add(fop);
        EntityStorage.get().save(BookingDao.findProductByUid((String)pr3).getContainer(), true);
        File outFile = new File(this.getOutFolder(), "bug1190.xls");
        HashMap<String, Object> data = new HashMap<String, Object>();
        AgentReportParameters params = new AgentReportParameters();
        Calendar cl = Calendar.getInstance();
        cl.setTime(this.issueDate);
        cl.add(5, -1);
        params.setPeriodBegin(cl.getTime());
        cl.add(5, 2);
        params.setPeriodEnd(cl.getTime());
        params.setAgency(this.subagencyContainer.toReference());
        data.put("key-report-params", params);
        params.setAgent(this.agentContainer.toReference());
        params.getVendors().add(this.tchReference);
        params.getVendors().add(this.suReference);
        params.setTemplate(new EntityReference("agentReportTemplate", TemplateDocument.class, null));
        AgentReportPrepareHandler prepareHandler = new AgentReportPrepareHandler();
        prepareHandler.prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)message.getMessage().getKey(), (boolean)true);
        }
        AgentReportRenderHandler renderHandler = new AgentReportRenderHandler();
        EntityContainer renderReport = renderHandler.renderReport(data);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(((ReportFile)((AgentReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("bug1190.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

