/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.agentreport;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportRenderHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.agentreport.BaseAgentReportTest;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class DoplineBSPAgentReportTest
extends BaseAgentReportTest {
    @Override
    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("agentReportTestDictionaries.xml");
    }

    @Test
    public void testReport() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        this.createProduct("001", 0, "LH", (EntityReference<Organization>)this.bspReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, "220", null);
        this.createProduct("002", 0, "LH", (EntityReference<Organization>)this.bspReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, "220", null);
        this.createProduct("003", 0, "SU", (EntityReference<Organization>)this.bspReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, "555", null);
        this.createProduct("004", 0, "SU", (EntityReference<Organization>)this.bspReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, "555", null);
        File outFile = new File(this.getOutFolder(), "DoplineBSPAgentReport.xls");
        HashMap<String, Object> data = new HashMap<String, Object>();
        AgentReportParameters params = new AgentReportParameters();
        Calendar cl = Calendar.getInstance();
        cl.setTime(this.issueDate);
        cl.add(5, -1);
        params.setPeriodBegin(cl.getTime());
        cl.add(5, 2);
        params.setPeriodEnd(cl.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        data.put("key-report-params", params);
        params.setAgent(this.agentContainer.toReference());
        params.getVendors().add(this.bspReference);
        params.setTemplate(new EntityReference("doplineAgentReportTemplate", TemplateDocument.class, null));
        AgentReportPrepareHandler prepareHandler = new AgentReportPrepareHandler();
        prepareHandler.prepareData(data);
        AgentReportRenderHandler renderHandler = new AgentReportRenderHandler();
        EntityContainer renderReport = renderHandler.renderReport(data);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(((ReportFile)((AgentReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("DoplineBSPAgentReport.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

