/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.agentreport;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportRenderHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.agentreport.BaseMCOFeesAgentReportTest;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class MCOFeesAgentReportTest
extends BaseMCOFeesAgentReportTest {
    @Override
    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("agentReportTestDictionaries.xml");
    }

    @Test
    public void testReport() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        String uid = this.createProduct("001", 0, this.airlineCode2, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber2, null);
        this.createMCO("101", uid);
        uid = this.createProduct("002", 0, this.airlineCode2, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.VOID, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber2, null);
        this.createMCO("102", uid);
        uid = this.createProduct("003", 0, this.airlineCode1, (EntityReference<Organization>)this.suReference, 200.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, true, this.airlineNumber1, null);
        this.createMCO("103", uid);
        uid = this.createProduct("003", 0, this.airlineCode1, (EntityReference<Organization>)this.suReference, 150.0, ProductStatus.REFUND, uid, PaymentType.CASH, ProductCategory.AIR, null, true, this.airlineNumber1, null);
        this.createMCO("103", uid);
        File outFile = new File(this.getOutFolder(), "MCOFeesAgentReport.xls");
        HashMap<String, Object> data = new HashMap<String, Object>();
        AgentReportParameters params = new AgentReportParameters();
        Calendar cl = Calendar.getInstance();
        cl.setTime(this.issueDate);
        cl.add(5, -1);
        params.setPeriodBegin(cl.getTime());
        cl.add(5, 2);
        params.setPeriodEnd(cl.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        data.put("key-report-params", params);
        params.setAgent(this.agentContainer.toReference());
        params.getVendors().add(this.tchReference);
        params.getVendors().add(this.suReference);
        params.setTemplate(new EntityReference("agentReportTemplate", TemplateDocument.class, null));
        AgentReportPrepareHandler prepareHandler = new AgentReportPrepareHandler();
        prepareHandler.prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)message.getMessage().getKey(), (boolean)true);
        }
        AgentReportRenderHandler renderHandler = new AgentReportRenderHandler();
        EntityContainer renderReport = renderHandler.renderReport(data);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(((ReportFile)((AgentReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("MCOFeesAgentReport.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

