/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.agentreport;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportRenderHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.agentreport.BaseAgentReportTest;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class RefusedTicketsTest
extends BaseAgentReportTest {
    private final double fare1 = 100.0;
    private static final String TICKET_SELL = "001";
    private static final String TICKET_REFUSED = "002";
    private final DateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("agentReportTestDictionaries.xml");
    }

    @Test
    public void testNormalOrder() throws Exception {
        this.testReport("2010-01-01", "2010-01-02", "2010-01-02", "2009-12-31", "2010-01-05", "refusedNormalOrder.xls", "refusedNormalOrder.xls");
    }

    @Test
    public void testDelayedRefund1() throws Exception {
        this.testReport("2010-01-01", "2010-01-02", "2010-01-03", "2010-01-01", "2010-01-01", "refusedDelayed1.xls", "refusedDelayed1.xls");
    }

    @Test
    public void testDelayedRefund2() throws Exception {
        this.testReport("2010-01-01", "2010-01-02", "2010-01-03", "2010-01-02", "2010-01-02", "refusedDelayed2.xls", "refusedDelayed2.xls");
    }

    @Test
    public void testDelayedRefund3() throws Exception {
        this.testReport("2010-01-01", "2010-01-02", "2010-01-03", "2010-01-03", "2010-01-03", "refusedDelayed3.xls", "refusedDelayed3.xls");
    }

    private void testReport(String issueDateStr, String refundDateStr, String cancelDateStr, String reportBeginDate, String reportEndDate, String outputFileStr, String expectedFileStr) throws Exception {
        this.issueDate = this.df.parse(issueDateStr);
        Date refundDate = this.df.parse(refundDateStr);
        Date cancelDate = this.df.parse(cancelDateStr);
        this.createProfiles();
        this.createProduct(TICKET_SELL, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        String prodUid = this.createProduct(TICKET_REFUSED, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        this.cancelProduct(prodUid, cancelDate, this.issueDate);
        prodUid = this.createProduct(TICKET_REFUSED, 0, this.airlineCode1, (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.REFUND, prodUid, PaymentType.CASH, ProductCategory.AIR, null, false, this.airlineNumber1, null);
        this.cancelProduct(prodUid, cancelDate, refundDate);
        File outFile = new File(this.getOutFolder(), outputFileStr);
        HashMap<String, Object> data = new HashMap<String, Object>();
        AgentReportParameters params = new AgentReportParameters();
        params.setPeriodBegin(this.df.parse(reportBeginDate));
        params.setPeriodEnd(this.df.parse(reportEndDate));
        params.setAgency(new EntityReference(this.agencyContainer));
        data.put("key-report-params", params);
        params.setAgent(this.agentContainer.toReference());
        params.getVendors().add(this.tchReference);
        params.getVendors().add(this.suReference);
        params.setTemplate(new EntityReference("agentReportTemplate", TemplateDocument.class, null));
        AgentReportPrepareHandler prepareHandler = new AgentReportPrepareHandler();
        prepareHandler.prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)message.getMessage().getKey(), (boolean)true);
        }
        AgentReportRenderHandler renderHandler = new AgentReportRenderHandler();
        EntityContainer renderReport = renderHandler.renderReport(data);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(((ReportFile)((AgentReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource(expectedFileStr)), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    private void cancelProduct(String prodUid, Date cancelDate, Date anIssueDate) throws Exception {
        ProductSearchResult searchResult = BookingDao.findProductByUid((String)prodUid);
        Product product = (Product)searchResult.getProduct();
        product.setIssueDate(anIssueDate);
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)product).getFops()) {
            fop.setAgent(this.agentContainer.toReference());
            fop.setOperationDate(cancelDate);
            fop.setRefused(true);
        }
        EntityStorage.get().save(searchResult.getContainer(), false);
    }
}

