/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.bsp;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.RenderHandlersRegistry;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.model.test.TestSalesPointBuilder;
import com.gridnine.xtrip.server.reports.prepare.PrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;

public abstract class BSPReportTestBase
extends RenderSalesReportTestBase {
    protected EntityReference<Organization> agency;
    protected EntityReference<Organization> client;
    protected EntityReference<CommissionProperties> commission;
    protected EntityContainer<Person> agentContainer;
    protected EntityReference<SalesPoint> salesPointRef;
    protected String validator = "000001";
    protected Date issueDate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createReport(String outFile, String templateCtrUid, String reportId) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ReportParameters params = new ReportParameters();
        Calendar cl = Calendar.getInstance();
        cl.setTime(this.issueDate);
        cl.add(1, -1);
        params.setPeriodBegin(cl.getTime());
        cl.add(1, 2);
        params.setPeriodEnd(cl.getTime());
        params.setAgency(this.agency);
        params.setBlankOwner(this.bspReference);
        params.setTemplate(new EntityReference(templateCtrUid, TemplateDocument.class, templateCtrUid));
        data.put("key-report-params", params);
        ((PrepareHandlersRegistry)Environment.getPublished(PrepareHandlersRegistry.class)).get(reportId).prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage()), (boolean)true);
        }
        EntityContainer renderReport = ((RenderHandlersRegistry)Environment.getPublished(RenderHandlersRegistry.class)).get(reportId).renderReport(data);
        try (FileOutputStream os = new FileOutputStream(new File(this.getOutFolder(), outFile));){
            os.write(((ReportFile)((ReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
        }
    }

    protected String createProduct(String ticketNo, int conj, String airline, EntityReference<Organization> blOwner, double fare, ProductStatus status, String relUid, PaymentType paymentType, ProductCategory productCategory, MCOCategory mcoCategory, boolean eticket, String airlineNumber, boolean mvl, boolean setBSPValue) throws Exception {
        EntityContainer bfc = null;
        Product product = null;
        if (!TextUtil.isBlank((String)relUid)) {
            ProductSearchResult searchResult = BookingDao.findProductByUid((String)relUid);
            bfc = searchResult.getContainer();
            Reservation reservation = searchResult.getReservation();
            product = new Product();
            product.setTicketType(TicketType.OWN);
            product.setTariffType(TariffType.REGULAR);
            product.setValidatorCode("12345678");
            reservation.getProducts().add(product);
            product.setReservation(reservation);
            Product relatedProduct = (Product)searchResult.getProduct();
            if (productCategory == ProductCategory.AIR) {
                product.setPreviousProduct(relatedProduct);
                relatedProduct.setNextProduct(product);
            } else {
                product.getRelatedProducts().add(relatedProduct);
            }
        } else {
            bfc = new EntityContainer(BookingFile.class);
            String user = LogicalStorage.get().getUser();
            bfc.setCreated(new Date());
            bfc.setCreatedBy(user);
            bfc.setModified(new Date());
            bfc.setModifiedBy(user);
            BookingFile bf = (BookingFile)bfc.getEntity();
            Reservation reservation = new Reservation();
            bf.getReservations().add(reservation);
            reservation.setBookingFile(bf);
            product = new Product();
            product.setTicketType(TicketType.OWN);
            product.setTariffType(TariffType.REGULAR);
            product.setValidatorCode("12345678");
            reservation.getProducts().add(product);
            product.setReservation(reservation);
        }
        BookingFile bf = (BookingFile)bfc.getEntity();
        bf.setCustomerProfile(this.client);
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        bf.getTravellers().add(traveller);
        product.setTraveller(traveller);
        product.setBlankOwnerRef(blOwner);
        product.setStatus(ProductStatus.SELL);
        product.setCarrier((DictionaryReference)new AirlineReference(airline));
        bf.setAgency(this.agency);
        product.setProductCategory(productCategory);
        product.setMcoCategory(mcoCategory);
        product.setEticket(eticket);
        product.setCashier(this.agent);
        product.setTariffType(TariffType.REGULAR);
        product.setBlankType((DictionaryReference)new BlankTypeReference(eticket ? "BSP ETKT" : "BSP 24"));
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(BigDecimal.valueOf(fare));
        AirProductHelper.setBaseFare((Product)product, (Money)money);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.valueOf(fare));
        double taxAmount = 100.0;
        Tax tax = new Tax();
        tax.setCode("ZZ");
        tax.setEquivalentAmount(BigDecimal.valueOf(taxAmount));
        product.getTaxes().add(tax);
        product.setStatus(status);
        product.setSystemNumber(ticketNo);
        product.setConjCount(conj);
        product.getScns().add(ticketNo);
        product.setIssueDate(this.issueDate);
        product.setTicketType(TicketType.OWN);
        product.setCarrierNumber(airlineNumber);
        product.setSalesPoint(this.salesPointRef);
        product.setValidatorCode(this.validator);
        ProductFop pt = new ProductFop();
        pt.setOperationDate(this.issueDate);
        AirProductHelper.setAgency((Product)product, this.agency);
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        if (status == ProductStatus.REFUND || product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            product.setPenalty(BigDecimal.TEN);
        }
        pt.setType(paymentType);
        if (product.getStatus() != ProductStatus.VOID) {
            AirProductHelper.getVendorContractRelation((Product)product).getFops().add(pt);
        }
        Segment segment = new Segment();
        segment.setStartDate(this.issueDate);
        segment.setAirline((DictionaryReference)new AirlineReference(airline));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("SVO"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference(!mvl ? "KJA" : "PAR"));
        segment.setFareBasis("farebasis");
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        segment = new Segment();
        segment.setStartDate(this.issueDate);
        segment.setAirline((DictionaryReference)new AirlineReference(airline));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference(!mvl ? "KJA" : "PAR"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("SVO"));
        segment.setFareBasis("farebasis");
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        if (paymentType.equals((Object)PaymentType.CREDIT_CARD)) {
            Card card = new Card();
            card.setVendor(CardVendor.AMEX);
            pt.setCard(card);
        }
        Money money2 = new Money();
        money2.setCurrency("RUB");
        money2.setValue(BigDecimal.valueOf(fare + taxAmount));
        if (status == ProductStatus.REFUND) {
            money2.setValue(money2.getValue().subtract(product.getPenalty()));
        }
        if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            money2.setValue(money2.getValue().add(product.getPenalty()));
        }
        pt.setAmount(money2);
        if (setBSPValue) {
            product.setBspCommissionRate(Double.valueOf(10.0));
            Money m = new Money();
            m.setCurrency("RUB");
            m.setValue(BigDecimal.TEN);
            product.setBspCommissionValue(m);
        }
        EntityStorage.get().save(bfc, false);
        return product.getUid();
    }

    protected String createProduct(String ticketNo, int conj, String airline, EntityReference<Organization> blOwner, double fare, ProductStatus status, String relUid, PaymentType paymentType, ProductCategory productCategory, MCOCategory mcoCategory, boolean eticket, String airlineNumber, boolean mvl) throws Exception {
        return this.createProduct(ticketNo, conj, airline, blOwner, fare, status, relUid, paymentType, productCategory, mcoCategory, eticket, airlineNumber, mvl, false);
    }

    protected void createProfiles() throws Exception {
        String user = LogicalStorage.get().getUser();
        EntityStorage es = EntityStorage.get();
        EntityContainer commissionCtr = new EntityContainer(CommissionProperties.class);
        CommissionProperties prop = (CommissionProperties)commissionCtr.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("commission"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setDisplayName("commission");
        prop.setBspCommission(true);
        es.save(commissionCtr, true);
        this.commission = commissionCtr.toReference();
        this.agentContainer = new EntityContainer(Person.class);
        this.agentContainer.setCreatedBy(user);
        this.agentContainer.setModifiedBy(user);
        Person agent = (Person)this.agentContainer.getEntity();
        agent.setUid("Test uid");
        agent.setCode("testAgent");
        agent.setLoginName(user);
        es.save(this.agentContainer, true);
        EntityContainer clientContainer = es.load(Organization.class, "test_client_container_uid");
        this.client = clientContainer.toReference();
        EntityContainer agencyContainer = es.load(Organization.class, "test_agency_container_uid");
        this.agency = agencyContainer.toReference();
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        cc.setCreatedBy(user);
        cc.setModifiedBy(user);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(this.bspReference);
        info.setCustomer(this.agency);
        contract.setVendor(this.bspReference);
        info.setNumber("01");
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("fare1");
        RuleResult res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(this.commission);
        value.setValue(10.0);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        es.save(cc, true);
        this.salesPointRef = new TestSalesPointBuilder().agency(agencyContainer.toReference()).validator(this.bspReference, this.agency, this.validator).create().toReference();
    }
}

