/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.bsp.registry;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageDeleteParameters;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.RequestedParameterCustomType;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.GeneralProductsTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.TemplateReportPageCustomParameterValue;
import com.gridnine.xtrip.common.reports.model.TemplateReportPageTemplate;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.system.model.SortOrderData;
import com.gridnine.xtrip.server.model.test.TestCommissionPropertiesBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.reports.salesreports.render.template.common.TemplateReportTestBase;

public class BspRegistryTestBase
extends TemplateReportTestBase {
    protected EntityReference<AirTicketsTemplateReportDescription> descriptionReference;

    protected void createReportDescription() throws Exception {
        EntityContainer ctr = new EntityContainer(AirTicketsTemplateReportDescription.class, "bps-registry-reportDescription");
        AirTicketsTemplateReportDescription description = (AirTicketsTemplateReportDescription)ctr.getEntity();
        description.setTitle("\u0420\u0435\u0435\u0441\u0442\u0440 \u043f\u0440\u043e\u0434\u0430\u0436 BSP");
        description.setContentType(ContentType.EXCEL);
        description.setHideExchanges(true);
        TemplateReportPageTemplate template = new TemplateReportPageTemplate();
        template.setName("Letter");
        template.setContent(this.getTemplate("bsp_registry_all.groovy", ContentType.GROOVY));
        description.getTemplates().add(template);
        description.getPages().add(this.createTicketPageDescription("Registry All", null, template));
        template = new TemplateReportPageTemplate();
        template.setName("Letter");
        template.setContent(this.getTemplate("bsp_registry_vvl.groovy", ContentType.GROOVY));
        description.getTemplates().add(template);
        description.getPages().add(this.createTicketPageDescription("Registry VVL", TransportationType.DOMESTIC, template));
        EntityStorage.get().save(ctr, true);
        this.descriptionReference = ctr.toReference();
    }

    private GeneralProductsTemplateReportPageDescription createTicketPageDescription(String title, TransportationType transportationType, TemplateReportPageTemplate template) {
        GeneralProductsTemplateReportPageDescription description = new GeneralProductsTemplateReportPageDescription();
        description.setName(title);
        description.setTemplate(template);
        TemplateReportPageCustomParameterValue param = new TemplateReportPageCustomParameterValue();
        param.setType(RequestedParameterCustomType.STRING);
        param.setKey("title");
        param.setValue((Object)title);
        description.getCustomParameters().add(param);
        if (transportationType != null) {
            param = new TemplateReportPageCustomParameterValue();
            param.setType(RequestedParameterCustomType.STRING);
            param.setKey("transportationType");
            param.setValue((Object)transportationType.name());
            description.getCustomParameters().add(param);
        }
        SortOrderData sortOrderData = new SortOrderData();
        sortOrderData.setPropertyName("sortingTicketNumber");
        sortOrderData.setOrder(SortOrder.ASC);
        description.setSortOrderScript("[[{it.validatingCarrierNumber}, false],   [{it.sortingTicketNumber}, false],    [{it.productCategory?.name().equals('AIR')? Integer.valueOf(0):Integer.valueOf(1)}, false],   [{it.status?.name().equals('EXCHANGE')? Integer.valueOf(0):Integer.valueOf(1)}, false] ]");
        if (transportationType != null) {
            description.getPageCriterions().add(SearchCriterion.eq((String)"transportationType", (Object)transportationType.name()));
        }
        return description;
    }

    @Override
    protected void createProfiles() throws Exception {
        super.createProfiles();
        this.supplierRef = this.blankOwner = this.bspReference;
        EntityReference cpRef = new TestCommissionPropertiesBuilder().rate(true).calculationBasis(CalculationBasis.FARE).bsp(true).displayName("Commission").create().toReference();
        EntityStorage.get().delete(this.supplierContractRef, new EntityStorageDeleteParameters());
        new TestContractBuilderBuilder().airCommission(10.0, "%", cpRef).blankOwner(this.blankOwner).supplier(this.blankOwner).contractType(ContractType.VENDOR).customer(this.agency).create();
    }
}

