/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.fv;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.fv.FvRegistryRender;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.xml.SuXmlReportRender;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.salesreports.fv.FvSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Test;

public class FvRegistryReportRenderTest
extends RenderSalesReportTestBase {
    private final String validatorCode = "111111";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFvReportRender() throws Exception {
        HashMap<MetadataKey, Object> metadatas = new HashMap<MetadataKey, Object>();
        metadatas.put(MetadataKey.KEY_FV_AGENCY_CODE, "0001");
        EntityContainer<Organization> agencyContainer = this.createOrganization("agency_code", "Agency short name", "Agency full name", metadatas);
        EntityReference agencyReference = agencyContainer.toReference();
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile bf = (BookingFile)bfc.getEntity();
        Product sell = this.createTicket(bf, agencyContainer, agencyContainer, "agency1", "9999999999", "0012345678", ProductStatus.SELL);
        Product ref = this.createTicket(bf, agencyContainer, agencyContainer, "agency1", "9999999999", "0012345678", ProductStatus.REFUND);
        ref.setPreviousProduct(sell);
        sell.setNextProduct(ref);
        ref.setPenalty(new BigDecimal(50));
        for (int i = 9000; i < 9010; ++i) {
            String ticketNo = String.valueOf(i);
            Product prevSell = this.createTicket(bf, agencyContainer, agencyContainer, "TESTPNR", ticketNo, "0012345679", ProductStatus.SELL);
            Product exch = this.createTicket(bf, agencyContainer, agencyContainer, "TESTPNR", ticketNo, "0012345679", ProductStatus.EXCHANGE);
            Product newSell = this.createTicket(bf, agencyContainer, agencyContainer, "TESTPNR", String.valueOf(i), "0012345680", ProductStatus.SELL);
            newSell.setPreviousProduct(exch);
            exch.setPreviousProduct(prevSell);
            exch.setNextProduct(newSell);
            prevSell.setNextProduct(exch);
        }
        this.save(bfc);
        this.createContract(agencyContainer, (EntityReference<Organization>)this.fvReference);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("CONTRACT_NO", "123");
        parameters.put("CONTRACT_ISSUE_DATE", new Date());
        parameters.put("AGENCY_NAME", "Organization ABC");
        parameters.put("AGENCY_IATA_CODE", "3214");
        parameters.put("REPORT_PERIOD", "01-10/01/2009");
        parameters.put("AGENCY_PHONE", "0950123457");
        parameters.put("AGENCY_EMAIL", "report@abc.ru");
        parameters.put("CONTRACT_NO", "0001");
        parameters.put("CONTRACT_ISSUE_DATE", new Date());
        parameters.put("REPORT_PERIOD", "01-10.2008");
        parameters.put("DIRECTOR", "Director");
        parameters.put("ACCOUNTANT", "Accountant");
        parameters.put("AGENCY_PHONE", "123-1234");
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)new Date()));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)new Date()));
        repParam.setAgency(agencyReference);
        repParam.setBlankOwner(this.fvReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.fvReference).getEntity());
        FvSalesReportPrepareHandler prepHandler = new FvSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        SuXmlReportRender handler = new SuXmlReportRender();
        handler.renderReport(parameters);
        TestFvRegistryRender registryHandler = new TestFvRegistryRender();
        EntityContainer repDoc = registryHandler.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)repDoc.getEntity()).getFiles().get(0);
        try (FileOutputStream fileOut = new FileOutputStream(this.buildOutputFileName("FvReg.xls"));){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
    }

    private void createContract(EntityContainer<Organization> agencyRef, EntityReference<Organization> vendorRef) throws Exception {
        EntityContainer commPercentCtr = new EntityContainer(CommissionProperties.class);
        ((CommissionProperties)commPercentCtr.getEntity()).setDisplayName("Commission %");
        ((CommissionProperties)commPercentCtr.getEntity()).setRate(true);
        ((CommissionProperties)commPercentCtr.getEntity()).setRoundingMode(RoundingMode.NONE);
        ((CommissionProperties)commPercentCtr.getEntity()).setRate(true);
        EntityStorage.get().save(commPercentCtr, false);
        EntityContainer commValueCtr = new EntityContainer(CommissionProperties.class);
        ((CommissionProperties)commValueCtr.getEntity()).setDisplayName("Commission");
        ((CommissionProperties)commValueCtr.getEntity()).setRate(true);
        ((CommissionProperties)commValueCtr.getEntity()).setRoundingMode(RoundingMode.NONE);
        ((CommissionProperties)commValueCtr.getEntity()).setRate(false);
        EntityStorage.get().save(commValueCtr, false);
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        contract.setVendor(vendorRef);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(new Date());
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(vendorRef);
        info.setCustomer(new EntityReference(agencyRef));
        contract.setVendor(vendorRef);
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("A1");
        RuleRestriction restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)"FV");
        rs.getRestrictions().add(restr);
        RuleResult res = new RuleResult();
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(commPercentCtr.toReference());
        value.setValue(2.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        res = new RuleResult();
        value = new RuleResultValue();
        value.setCurrencyCode("RUB");
        value.setTarget(commValueCtr.toReference());
        value.setValue(5.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        this.save(cc);
    }

    private Product createTicket(BookingFile bf, EntityContainer<Organization> agencyRef, EntityContainer<Organization> subAgencyRef, String pnr, String ticketNo, String scn, ProductStatus productStatus) throws Exception {
        Reservation res = new Reservation();
        this.setRecordLocator(res, pnr);
        res.setBookingFile(bf);
        Product product = new Product();
        Traveller traveller = new Traveller();
        traveller.setName("PUTIN MR.");
        product.setTraveller(traveller);
        product.setReservation(res);
        product.setSystemNumber(ticketNo);
        product.getScns().add(scn);
        product.setConjCount(0);
        product.setStatus(productStatus);
        product.setProductCategory(ProductCategory.AIR);
        product.setTariffType(TariffType.REGULAR);
        product.setValidatorCode("111111");
        product.setIssueDate(new Date());
        if (productStatus == ProductStatus.EXCHANGE) {
            AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)new BigDecimal(1.0));
        } else {
            AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)new BigDecimal(100.0));
        }
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setEquivalentAmount(new BigDecimal(37));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("YR");
        tax.setEquivalentAmount(new BigDecimal(1200));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("CZ");
        tax.setEquivalentAmount(new BigDecimal(788));
        product.getTaxes().add(tax);
        Money baseFare = new Money();
        baseFare.setCurrency("EUR");
        baseFare.setValue(new BigDecimal(10.0));
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)new BigDecimal(105.0));
        Airline airline = DictHelper.findAirlineByAnyCode((String)"195");
        product.setBlankOwnerRef(((EntityContainer)ProfileDao.getBlankOwnersByAirline((DictionaryReference)airline.toReference()).get(0)).toReference());
        product.setBlankOwnerNumber("195");
        Iterator iterator = BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef()).iterator();
        if (iterator.hasNext()) {
            BlankType bt = (BlankType)iterator.next();
            bt.getCode().equals("195 24");
            product.setBlankType((DictionaryReference)new BlankTypeReference(bt));
        }
        SegmentTariff st = new SegmentTariff();
        Segment seg = new Segment();
        seg.setAirline((DictionaryReference)airline.toReference());
        seg.setFlightNo("101");
        seg.setDepartCityCode("SVO");
        seg.setArriveCityCode("LHR");
        seg.setRecordNumber(1);
        st.getSegments().add(seg);
        seg = new Segment();
        seg.setAirline((DictionaryReference)airline.toReference());
        seg.setFlightNo("102");
        seg.setDepartCityCode("LHR");
        seg.setArriveCityCode("SVO");
        seg.setRecordNumber(3);
        st.getSegments().add(seg);
        product.getSegmentTariffs().add(st);
        product.setTicketType(TicketType.OWN);
        bf.setAgency(new EntityReference(agencyRef));
        AirProductHelper.setSubagency((Product)product, (EntityReference)new EntityReference(subAgencyRef));
        AirProductHelper.setAgency((Product)product, (EntityReference)agencyRef.toReference());
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        EntityContainer subAgencyContainer = EntityStorage.get().resolve(new EntityReference(subAgencyRef));
        product.setAgencyCode(((Organization)subAgencyContainer.getEntity()).getCode());
        ProductFop fop = new ProductFop();
        Money fopMoney = new Money();
        fopMoney.setCurrency("RUB");
        fopMoney.setValue(new BigDecimal(110));
        fop.setAmount(fopMoney);
        fop.setType(PaymentType.CASH);
        fop.setOperationDate(product.getIssueDate());
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setChecked(true);
        List blankTypes = BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef());
        for (BlankType type : blankTypes) {
            if (type.getBlankCategory() != BlankCategory.ETICKET) continue;
            product.setBlankType((DictionaryReference)type.toReference());
            product.setProductCategory(type.getProductCategory());
            break;
        }
        res.getProducts().add(product);
        bf.getReservations().add(res);
        return product;
    }

    private void setMultyAgencyReport(boolean enable) throws Exception {
        DictionaryStorage ds = DictionaryStorage.get();
        Collection dicts = ds.loadAll(null, Preference.class);
        for (BaseDictionary dict : dicts) {
            if (!((Preference)dict).getKey().equals((Object)PreferenceKey.XML_REPORT_TICKET_ORDER_FOR_MULTYAGENCY_REPORT)) continue;
            if (enable) {
                ((Preference)dict).setValue("YES");
            } else {
                ((Preference)dict).setValue("NO");
            }
            ds.save(dict);
            break;
        }
    }

    class TestFvRegistryRender
    extends FvRegistryRender<SuTicket> {
        TestFvRegistryRender() {
        }

        protected File getTemplateFile() throws IOException {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            if (!result.exists()) {
                throw new IOException("Template " + result.getCanonicalPath() + " was not found");
            }
            return result;
        }
    }
}

