/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.fv;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.fv.FvRegistryRender;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.xml.SuXmlReportRender;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.RandomUtil;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.parsers.test.ParsersTestHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.fv.FvSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class FvReportRenderTest
extends RenderSalesReportTestBase {
    private final String validatorCode = "111111";

    @Test
    public void testFvReportRender() throws Exception {
        Product exch;
        HashMap<MetadataKey, Object> metadatas = new HashMap<MetadataKey, Object>();
        metadatas.put(MetadataKey.KEY_XF_AGENCY_CODE, "0001");
        EntityContainer<Organization> agencyContainer = this.createOrganization("agency_code", "Agency short name", "Agency full name", metadatas);
        EntityReference agencyReference = agencyContainer.toReference();
        EntityContainer<Organization> subagencyContainer = this.createOrganization("subagency_code", "Subagency short name", "Subagency full name", Collections.emptyMap());
        Product sell = this.createTicket(agencyContainer, agencyContainer, "agency1", "9999999999", "0012345678", ProductStatus.SELL, null, null);
        this.createTicket(agencyContainer, agencyContainer, "agency1", "9999999999", "0012345678", ProductStatus.REFUND, sell, null);
        HashSet<String> createdTicketsNumbers = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            String ticketNo;
            while (createdTicketsNumbers.contains(ticketNo = String.valueOf(RandomUtil.getRandomInt((int)1000, (int)9999)))) {
            }
            createdTicketsNumbers.add(ticketNo);
            exch = this.createTicket(agencyContainer, agencyContainer, "TESTPNR", ticketNo, "0012345678", ProductStatus.EXCHANGE, sell, sell);
            sell = this.createTicket(agencyContainer, agencyContainer, "TESTPNR", ticketNo, "0012345678", ProductStatus.SELL, exch, null);
        }
        Product sell1 = this.createTicket(agencyContainer, subagencyContainer, "agency2", "001", "0012345678", ProductStatus.SELL, null, null);
        this.createTicket(agencyContainer, subagencyContainer, "agency2", "101", "0012345678", ProductStatus.REFUND, sell1, null);
        Product sell2 = this.createTicket(agencyContainer, subagencyContainer, "agency2", "002", "0022345678", ProductStatus.SELL, null, null);
        exch = this.createTicket(agencyContainer, subagencyContainer, "agency2", "030", "0022345678", ProductStatus.EXCHANGE, sell1, sell2);
        ProductSearchResult psr = ParsersTestHelper.findProduct((String)"002", (ProductStatus)ProductStatus.SELL);
        ((Product)psr.getProduct()).setPreviousProduct(exch);
        this.save(psr.getContainer());
        this.createContract(agencyContainer, (EntityReference<Organization>)this.fvReference);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)new Date()));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)new Date()));
        repParam.setAgency(agencyReference);
        repParam.setBlankOwner(this.fvReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.fvReference).getEntity());
        FvSalesReportPrepareHandler prepHandler = new FvSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        SuXmlReportRender handler = new SuXmlReportRender();
        EntityContainer repDoc = handler.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)repDoc.getEntity()).getFiles().get(0);
        byte[] content = repFile.getContent();
        this.log.debug(new String(content));
        this.setMultyAgencyReport(true);
        prepHandler.prepareData(parameters);
        repDoc = handler.renderReport(parameters);
        repFile = (ReportFile)((ReportDocument)repDoc.getEntity()).getFiles().get(0);
        content = repFile.getContent();
        this.log.debug(new String(content));
        TestFvRegistryRender registryHandler = new TestFvRegistryRender();
        EntityContainer regRepDoc = registryHandler.renderReport(parameters);
        repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        try (FileOutputStream fileOut = new FileOutputStream(this.buildOutputFileName("FvReg.xls"));){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        Assert.assertTrue((content.length != 0 ? 1 : 0) != 0);
    }

    private void createContract(EntityContainer<Organization> agencyRef, EntityReference<Organization> vendorRef) throws Exception {
        EntityContainer commCtr = new EntityContainer(CommissionProperties.class);
        ((CommissionProperties)commCtr.getEntity()).setDisplayName("Commission %");
        ((CommissionProperties)commCtr.getEntity()).setRate(true);
        ((CommissionProperties)commCtr.getEntity()).setRoundingMode(RoundingMode.NONE);
        ((CommissionProperties)commCtr.getEntity()).setRate(true);
        EntityStorage.get().save(commCtr, false);
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        contract.setVendor(vendorRef);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(new Date());
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(vendorRef);
        info.setCustomer(new EntityReference(agencyRef));
        contract.setVendor(vendorRef);
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("A1");
        RuleRestriction restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)"FV");
        rs.getRestrictions().add(restr);
        RuleResult res = new RuleResult();
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(commCtr.toReference());
        value.setValue(2.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        this.save(cc);
    }

    private Product createTicket(EntityContainer<Organization> agencyRef, EntityContainer<Organization> subAgencyRef, String pnr, String ticketNo, String scn, ProductStatus productStatus, Product prevTicket, Product nextTicket) throws Exception {
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile bf = (BookingFile)bfc.getEntity();
        Reservation res = new Reservation();
        this.setRecordLocator(res, pnr);
        res.setBookingFile(bf);
        Product product = new Product();
        Traveller traveller = new Traveller();
        traveller.setName("PUTIN MR.");
        product.setTraveller(traveller);
        product.setPreviousProduct(prevTicket);
        product.setNextProduct(nextTicket);
        product.setReservation(res);
        product.setSystemNumber(ticketNo);
        product.getScns().add(scn);
        product.setConjCount(0);
        product.setStatus(productStatus);
        product.setProductCategory(ProductCategory.AIR);
        product.setTariffType(TariffType.REGULAR);
        product.setValidatorCode("111111");
        product.setIssueDate(new Date());
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)new BigDecimal("1000.0"));
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setEquivalentAmount(new BigDecimal(37));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("YR");
        tax.setEquivalentAmount(new BigDecimal(1200));
        product.getTaxes().add(tax);
        Money baseFare = new Money();
        baseFare.setCurrency("RUB");
        baseFare.setValue(new BigDecimal(1000));
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        Airline airline = DictHelper.findAirlineByAnyCode((String)"195");
        product.setBlankOwnerRef(((EntityContainer)ProfileDao.getBlankOwnersByAirline((DictionaryReference)airline.toReference()).get(0)).toReference());
        product.setBlankOwnerNumber("195");
        for (BlankType bt : BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef())) {
            if (!bt.getCode().equals("195 24")) continue;
            product.setBlankType((DictionaryReference)new BlankTypeReference(bt));
            break;
        }
        SegmentTariff st = new SegmentTariff();
        Segment seg = new Segment();
        seg.setAirline((DictionaryReference)airline.toReference());
        seg.setFlightNo("101");
        seg.setDepartCityCode("SVO");
        seg.setArriveCityCode("LHR");
        seg.setRecordNumber(1);
        seg.setFareBasis("500");
        st.getSegments().add(seg);
        seg = new Segment();
        seg.setAirline((DictionaryReference)airline.toReference());
        seg.setFlightNo("102");
        seg.setDepartCityCode("LHR");
        seg.setArriveCityCode("SVO");
        seg.setRecordNumber(3);
        seg.setFareBasis("500");
        st.getSegments().add(seg);
        product.getSegmentTariffs().add(st);
        product.setTicketType(TicketType.OWN);
        product.setChecked(true);
        List blankTypes = BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef());
        for (BlankType type : blankTypes) {
            if (type.getBlankCategory() != BlankCategory.ETICKET) continue;
            product.setBlankType((DictionaryReference)type.toReference());
            product.setProductCategory(type.getProductCategory());
            break;
        }
        bf.setAgency(new EntityReference(agencyRef));
        AirProductHelper.setSubagency((Product)product, (EntityReference)new EntityReference(subAgencyRef));
        AirProductHelper.setAgency((Product)product, (EntityReference)agencyRef.toReference());
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        EntityContainer subAgencyContainer = EntityStorage.get().resolve(new EntityReference(subAgencyRef));
        product.setAgencyCode(((Organization)subAgencyContainer.getEntity()).getCode());
        ProductFop fop = new ProductFop();
        fop.setType(PaymentType.CASH);
        Money fopMoney = new Money();
        fopMoney.setCurrency("RUB");
        fopMoney.setValue(new BigDecimal(2237));
        fop.setAmount(fopMoney);
        fop.setOperationDate(product.getIssueDate());
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        res.getProducts().add(product);
        bf.getReservations().add(res);
        product.setCashier(new EntityReference("cashier_uid", Person.class, null));
        this.save(bfc);
        return product;
    }

    private void setMultyAgencyReport(boolean enable) throws Exception {
        DictionaryStorage ds = DictionaryStorage.get();
        Collection dicts = ds.loadAll(null, Preference.class);
        for (BaseDictionary dict : dicts) {
            if (!((Preference)dict).getKey().equals((Object)PreferenceKey.XML_REPORT_TICKET_ORDER_FOR_MULTYAGENCY_REPORT)) continue;
            if (enable) {
                ((Preference)dict).setValue("YES");
            } else {
                ((Preference)dict).setValue("NO");
            }
            ds.save(dict);
            break;
        }
    }

    static class TestFvRegistryRender
    extends FvRegistryRender<SuTicket> {
        TestFvRegistryRender() {
        }

        protected File getTemplateFile() throws IOException {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            if (!result.exists()) {
                throw new IOException("Template " + result.getCanonicalPath() + " was not found");
            }
            return result;
        }
    }
}

