/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.kv;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.kv.KVSalesReportRenderHandler;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.reports.prepare.salesreports.kv.KVSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Test;

public class KVSalesReportRenderTest
extends RenderSalesReportTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReportRender() throws Exception {
        HashMap<MetadataKey, Object> metadatas = new HashMap<MetadataKey, Object>();
        metadatas.put(MetadataKey.KEY_KV_AGENCY_CODE, "0001");
        EntityContainer<Organization> agencyContainer = this.createOrganization("agency_code", "Agency short name", "Agency full name", metadatas);
        EntityReference agencyReference = agencyContainer.toReference();
        EntityContainer bookingFileContainer = new EntityContainer(BookingFile.class);
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        Product sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00001", "SELL0001-1", "TCKT0001-1", ProductStatus.SELL, "MOW", "VVO");
        Product ref = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00001", "RFND0001-1", "TCKT0001-1", ProductStatus.REFUND, "MOW", "VVO");
        sell.setNextProduct(ref);
        ref.setPreviousProduct(sell);
        ref.setPenalty(new BigDecimal(50));
        Money fopAmount = ((ProductFop)AirProductHelper.getVendorContractRelation((Product)ref).getFops().get(0)).getAmount();
        fopAmount.setValue(fopAmount.getValue().subtract(new BigDecimal(50)));
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00002", "SELL0002-1", "TCKT0002-1", ProductStatus.SELL, "MOW", "VVO");
        ref = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00002", "RFND0002-1", "TCKT0002-1", ProductStatus.REFUND, "MOW", "VVO");
        sell.setNextProduct(ref);
        ref.setPreviousProduct(sell);
        ref.setPenalty(new BigDecimal(50));
        fopAmount = ((ProductFop)AirProductHelper.getVendorContractRelation((Product)ref).getFops().get(0)).getAmount();
        fopAmount.setValue(fopAmount.getValue().subtract(new BigDecimal(50)));
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00003", "SELL0003-1", "TCKT0003-1", ProductStatus.SELL, "MOW", "VVO");
        ref = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00003", "RFND0003-1", "TCKT0003-1", ProductStatus.REFUND, "MOW", "VVO");
        Money baseFare = AirProductHelper.getBaseFare((Product)ref);
        baseFare.setValue(baseFare.getValue().subtract(new BigDecimal(1)));
        AirProductHelper.setBaseFare((Product)ref, (Money)baseFare);
        BigDecimal equivalentBaseFare = AirProductHelper.getEquivalentFare((Product)ref);
        AirProductHelper.setEquivalentFare((Product)ref, (BigDecimal)equivalentBaseFare.subtract(new BigDecimal(10)));
        fopAmount = ((ProductFop)AirProductHelper.getVendorContractRelation((Product)ref).getFops().get(0)).getAmount();
        fopAmount.setValue(fopAmount.getValue().subtract(new BigDecimal(10)));
        sell.setNextProduct(ref);
        ref.setPreviousProduct(sell);
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00004", "SELL0004-1", "TCKT0004-1", ProductStatus.SELL, "MOW", "VVO");
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00004", "SELL0004-1", "TCKT0004-1", ProductStatus.SELL, "MOW", "VVO");
        sell.setDuplicate(true);
        ref = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00004", "RFND0004-1", "TCKT0004-1", ProductStatus.REFUND, "MOW", "VVO");
        baseFare = AirProductHelper.getBaseFare((Product)ref);
        baseFare.setValue(baseFare.getValue().subtract(new BigDecimal(2)));
        AirProductHelper.setBaseFare((Product)ref, (Money)baseFare);
        equivalentBaseFare = AirProductHelper.getEquivalentFare((Product)ref);
        AirProductHelper.setEquivalentFare((Product)ref, (BigDecimal)equivalentBaseFare.subtract(new BigDecimal(20)));
        fopAmount = ((ProductFop)AirProductHelper.getVendorContractRelation((Product)ref).getFops().get(0)).getAmount();
        fopAmount.setValue(fopAmount.getValue().subtract(new BigDecimal(20)));
        ref.setPreviousProduct(sell);
        sell.setNextProduct(ref);
        this.createExceesBagage(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00004", "EXBG0004-1", "EXBG0004-1", ProductStatus.SELL);
        this.createExceesBagage(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00004", "EXBG0004-1", "EXBG0004-2", ProductStatus.SELL);
        this.createMCO(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00004", "MCO00004-1", "MCO00004-1", MCOCategory.EXCESS_LUGGAGE, ProductStatus.SELL, sell);
        this.createMCO(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00004", "MCO00004-2", "MCO00004-2", MCOCategory.RETURN_TICKET, ProductStatus.SELL, ref);
        this.createMCO(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00004", "MCO00004-3", "MCO00004-3", MCOCategory.PENALTY, ProductStatus.SELL, ref);
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00005", "SELL0005-1", "TCKT0005-1", ProductStatus.SELL, "MOW", "VVO");
        Product exch = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00005", "EXCH0005-1", "TCKT0005-1", ProductStatus.EXCHANGE, "MOW", "VVO");
        sell.setNextProduct(exch);
        exch.setPreviousProduct(sell);
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00005", "SELL0005-2", "TCKT0005-2", ProductStatus.SELL, "MOW", "VVO");
        exch.setNextProduct(sell);
        sell.setPreviousProduct(exch);
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00006", "SELL0006-1", "TCKT0006-1", ProductStatus.SELL, "MOW", "VVO");
        exch = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00006", "EXCH0006-1", "TCKT0006-1", ProductStatus.EXCHANGE, "MOW", "VVO");
        baseFare = AirProductHelper.getBaseFare((Product)exch);
        baseFare.setValue(baseFare.getValue().subtract(new BigDecimal(3)));
        AirProductHelper.setBaseFare((Product)exch, (Money)baseFare);
        equivalentBaseFare = AirProductHelper.getEquivalentFare((Product)exch);
        AirProductHelper.setEquivalentFare((Product)exch, (BigDecimal)equivalentBaseFare.subtract(new BigDecimal(30)));
        fopAmount = ((ProductFop)AirProductHelper.getVendorContractRelation((Product)exch).getFops().get(0)).getAmount();
        fopAmount.setValue(fopAmount.getValue().subtract(new BigDecimal(30)));
        sell.setNextProduct(exch);
        exch.setPreviousProduct(sell);
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00006", "SELL0006-2", "TCKT0006-2", ProductStatus.SELL, "MOW", "VVO");
        exch.setNextProduct(sell);
        sell.setPreviousProduct(exch);
        this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00007", "VOID0007-1", "TCKT0007-1", ProductStatus.VOID, "MOW", "VVO");
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00008", "SELL0008-1", "TCKT0008-1", ProductStatus.SELL, "MOW", "LON");
        ref = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00008", "RFND0008-1", "TCKT0008-1", ProductStatus.REFUND, "MOW", "LON");
        sell.setNextProduct(ref);
        ref.setPreviousProduct(sell);
        ref.setPenalty(new BigDecimal(30));
        fopAmount = ((ProductFop)AirProductHelper.getVendorContractRelation((Product)ref).getFops().get(0)).getAmount();
        fopAmount.setValue(fopAmount.getValue().subtract(new BigDecimal(30)));
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00009", "SELL0009-1", "TCKT0009-1", ProductStatus.SELL, "MOW", "LON");
        ref = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00009", "RFND0009-1", "TCKT0009-1", ProductStatus.REFUND, "MOW", "LON");
        sell.setNextProduct(ref);
        ref.setPreviousProduct(sell);
        ref.setPenalty(new BigDecimal(40));
        fopAmount = ((ProductFop)AirProductHelper.getVendorContractRelation((Product)ref).getFops().get(0)).getAmount();
        fopAmount.setValue(fopAmount.getValue().subtract(new BigDecimal(40)));
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00010", "SELL0010-1", "TCKT0010-1", ProductStatus.SELL, "MOW", "LON");
        ref = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00010", "RFND0010-1", "TCKT0010-1", ProductStatus.REFUND, "MOW", "LON");
        baseFare = AirProductHelper.getBaseFare((Product)ref);
        baseFare.setValue(baseFare.getValue().subtract(new BigDecimal(1)));
        AirProductHelper.setBaseFare((Product)ref, (Money)baseFare);
        equivalentBaseFare = AirProductHelper.getEquivalentFare((Product)ref);
        AirProductHelper.setEquivalentFare((Product)ref, (BigDecimal)equivalentBaseFare.subtract(new BigDecimal(5)));
        fopAmount = ((ProductFop)AirProductHelper.getVendorContractRelation((Product)ref).getFops().get(0)).getAmount();
        fopAmount.setValue(fopAmount.getValue().subtract(new BigDecimal(5)));
        sell.setNextProduct(ref);
        ref.setPreviousProduct(sell);
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00011", "SELL0011-1", "TCKT0011-1", ProductStatus.SELL, "MOW", "LON");
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00011", "SELL0011-1", "TCKT0011-1", ProductStatus.SELL, "MOW", "LON");
        sell.setDuplicate(true);
        ref = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00011", "RFND0011-1", "TCKT0011-1", ProductStatus.REFUND, "MOW", "LON");
        baseFare = AirProductHelper.getBaseFare((Product)ref);
        baseFare.setValue(baseFare.getValue().subtract(new BigDecimal(2)));
        AirProductHelper.setBaseFare((Product)ref, (Money)baseFare);
        equivalentBaseFare = AirProductHelper.getEquivalentFare((Product)ref);
        AirProductHelper.setEquivalentFare((Product)ref, (BigDecimal)equivalentBaseFare.subtract(new BigDecimal(15)));
        fopAmount = ((ProductFop)AirProductHelper.getVendorContractRelation((Product)ref).getFops().get(0)).getAmount();
        fopAmount.setValue(fopAmount.getValue().subtract(new BigDecimal(15)));
        ref.setPreviousProduct(sell);
        sell.setNextProduct(ref);
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00012", "SELL0012-1", "TCKT0012-1", ProductStatus.SELL, "MOW", "LON");
        exch = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00012", "EXCH0012-1", "TCKT0012-1", ProductStatus.EXCHANGE, "MOW", "LON");
        sell.setNextProduct(exch);
        exch.setPreviousProduct(sell);
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00012", "SELL0012-2", "TCKT0012-2", ProductStatus.SELL, "MOW", "LON");
        exch.setNextProduct(sell);
        sell.setPreviousProduct(exch);
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00013", "SELL0013-1", "TCKT0013-1", ProductStatus.SELL, "MOW", "LON");
        exch = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00013", "EXCH0013-1", "TCKT0013-1", ProductStatus.EXCHANGE, "MOW", "LON");
        baseFare = AirProductHelper.getBaseFare((Product)exch);
        baseFare.setValue(baseFare.getValue().subtract(new BigDecimal(3)));
        AirProductHelper.setBaseFare((Product)exch, (Money)baseFare);
        equivalentBaseFare = AirProductHelper.getEquivalentFare((Product)exch);
        AirProductHelper.setEquivalentFare((Product)exch, (BigDecimal)equivalentBaseFare.subtract(new BigDecimal(30)));
        fopAmount = ((ProductFop)AirProductHelper.getVendorContractRelation((Product)exch).getFops().get(0)).getAmount();
        fopAmount.setValue(fopAmount.getValue().subtract(new BigDecimal(30)));
        sell.setNextProduct(exch);
        exch.setPreviousProduct(sell);
        sell = this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00013", "SELL0013-2", "TCKT0013-2", ProductStatus.SELL, "MOW", "LON");
        exch.setNextProduct(sell);
        sell.setPreviousProduct(exch);
        this.createTicket(bookingFile, (EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "PNR00014", "VOID0014-1", "TCKT0014-1", ProductStatus.VOID, "MOW", "LON");
        this.save(bookingFileContainer);
        this.createContract((EntityReference<Organization>)agencyReference, (EntityReference<Organization>)this.kvReference);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)new Date()));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)new Date()));
        repParam.setAgency(agencyReference);
        repParam.setSupplier(this.kvReference);
        repParam.setBlankOwner(this.kvReference);
        repParam.setAgency(agencyReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.kvReference).getEntity());
        parameters.put("AGENT_CODE", "1234");
        TestKVSalesReportPrepareHandler prepHandler = new TestKVSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        TestKVRegistryRender handler = new TestKVRegistryRender();
        EntityContainer reportDocumentContainer = handler.renderReport(parameters);
        ReportFile reportFile = (ReportFile)((ReportDocument)reportDocumentContainer.getEntity()).getFiles().get(0);
        try (FileOutputStream fileOut = new FileOutputStream(this.buildOutputFileName("KVSalesReport.xls"));){
            ByteArrayInputStream is = new ByteArrayInputStream(reportFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
    }

    private EntityContainer<Contract> createContract(EntityReference<Organization> agencyRef, EntityReference<Organization> vendorRef) throws Exception {
        EntityContainer commPercent = new EntityContainer(CommissionProperties.class);
        ((CommissionProperties)commPercent.getEntity()).setDisplayName("Commission %");
        ((CommissionProperties)commPercent.getEntity()).setRate(true);
        ((CommissionProperties)commPercent.getEntity()).setRoundingMode(RoundingMode.NONE);
        ((CommissionProperties)commPercent.getEntity()).setRate(true);
        EntityStorage.get().save(commPercent, false);
        EntityContainer commValue = new EntityContainer(CommissionProperties.class);
        ((CommissionProperties)commValue.getEntity()).setDisplayName("Commission");
        ((CommissionProperties)commValue.getEntity()).setRate(true);
        ((CommissionProperties)commValue.getEntity()).setRoundingMode(RoundingMode.NONE);
        ((CommissionProperties)commValue.getEntity()).setRate(true);
        EntityStorage.get().save(commValue, false);
        EntityContainer result = new EntityContainer(Contract.class);
        Contract contract = (Contract)result.getEntity();
        contract.setVendor(vendorRef);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(new Date());
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setNumber("1");
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(vendorRef);
        info.setCustomer(agencyRef);
        contract.setVendor(vendorRef);
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("A1");
        RuleRestriction restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)"HY");
        rs.getRestrictions().add(restr);
        RuleResult res = new RuleResult();
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(commPercent.toReference());
        value.setValue(2.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        res = new RuleResult();
        value = new RuleResultValue();
        value.setCurrencyCode("RUB");
        value.setTarget(commValue.toReference());
        value.setValue(5.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        this.save(result);
        return result;
    }

    private Product createTicket(BookingFile bf, EntityReference<Organization> agencyRef, EntityReference<Organization> subAgencyRef, String pnr, String ticketNo, String scn, ProductStatus productStatus, String locationCode01, String locationCode02) throws Exception {
        Reservation res = new Reservation();
        this.setRecordLocator(res, pnr);
        res.setBookingFile(bf);
        Product product = new Product();
        Traveller traveller = new Traveller();
        traveller.setName("PUTIN MR.");
        product.setTraveller(traveller);
        product.setReservation(res);
        product.setSystemNumber(ticketNo);
        product.getScns().add(scn);
        product.setConjCount(0);
        product.setValidatorCode("11112222");
        product.setStatus(productStatus);
        product.setProductCategory(ProductCategory.AIR);
        product.setTariffType(TariffType.REGULAR);
        product.setIssueDate(new Date());
        if (productStatus == ProductStatus.EXCHANGE) {
            AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)new BigDecimal(1.0));
        } else {
            AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)new BigDecimal(100.0));
        }
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setEquivalentAmount(new BigDecimal(37));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("YQ");
        tax.setEquivalentAmount(new BigDecimal(1200));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("CZ");
        tax.setEquivalentAmount(new BigDecimal(788));
        product.getTaxes().add(tax);
        Money baseFare = new Money();
        baseFare.setCurrency("EUR");
        baseFare.setValue(new BigDecimal(10.0));
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        Airline airline = DictHelper.findAirlineByAnyCode((String)"348");
        product.setBlankOwnerRef(this.kvReference);
        product.setBlankOwnerNumber("348");
        for (BlankType type : BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef())) {
            if (type.getProductCategory() != ProductCategory.AIR) continue;
            product.setBlankType((DictionaryReference)new BlankTypeReference(type));
            break;
        }
        SegmentTariff st = new SegmentTariff();
        Segment seg = new Segment();
        seg.setAirline((DictionaryReference)airline.toReference());
        seg.setFlightNo("101");
        seg.setDepartCityCode(locationCode01);
        seg.setArriveCityCode(locationCode02);
        GeoLocation departureLocation = DictHelper.findGeoLocationByCodeVariant((String)locationCode01);
        GeoLocation arriveLocation = DictHelper.findGeoLocationByCodeVariant((String)locationCode02);
        seg.setDepartureLocation((DictionaryReference)departureLocation.toReference());
        seg.setArriveLocation((DictionaryReference)arriveLocation.toReference());
        seg.setRecordNumber(1);
        seg.setFareBasis("5");
        st.getSegments().add(seg);
        seg = new Segment();
        seg.setAirline((DictionaryReference)airline.toReference());
        seg.setFlightNo("102");
        seg.setDepartCityCode(locationCode02);
        seg.setArriveCityCode(locationCode01);
        departureLocation = DictHelper.findGeoLocationByCodeVariant((String)locationCode02);
        arriveLocation = DictHelper.findGeoLocationByCodeVariant((String)locationCode01);
        seg.setDepartureLocation((DictionaryReference)departureLocation.toReference());
        seg.setArriveLocation((DictionaryReference)arriveLocation.toReference());
        seg.setRecordNumber(3);
        seg.setFareBasis("5");
        st.getSegments().add(seg);
        product.getSegmentTariffs().add(st);
        product.setTicketType(TicketType.OWN);
        bf.setAgency(agencyRef);
        AirProductHelper.setSubagency((Product)product, subAgencyRef);
        AirProductHelper.setAgency((Product)product, agencyRef);
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setAgencyCode(((Organization)EntityStorage.get().resolve(subAgencyRef).getEntity()).getCode());
        ProductFop fop = new ProductFop();
        Money fopMoney = new Money();
        fopMoney.setCurrency("RUB");
        fopMoney.setValue(new BigDecimal(2125));
        fop.setAmount(fopMoney);
        fop.setType(PaymentType.CASH);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setChecked(true);
        res.getProducts().add(product);
        bf.getReservations().add(res);
        this.setCommissions(product);
        return product;
    }

    private Product createExceesBagage(BookingFile bf, EntityReference<Organization> agencyRef, EntityReference<Organization> subAgencyRef, String pnr, String ticketNo, String scn, ProductStatus productStatus) throws Exception {
        Reservation res = new Reservation();
        this.setRecordLocator(res, pnr);
        res.setBookingFile(bf);
        Product product = new Product();
        Traveller traveller = new Traveller();
        traveller.setName("PUTIN MR.");
        product.setTraveller(traveller);
        product.setReservation(res);
        product.setSystemNumber(ticketNo);
        product.getScns().add(scn);
        product.setConjCount(0);
        product.setValidatorCode("11112222");
        product.setStatus(productStatus);
        product.setProductCategory(ProductCategory.EXCESS_BAGAGE);
        product.setTariffType(TariffType.REGULAR);
        product.setLuggageWeight(Double.valueOf(100.0));
        product.setIssueDate(new Date());
        Money baseFare = new Money();
        baseFare.setCurrency("EUR");
        baseFare.setValue(new BigDecimal(10.0));
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)new BigDecimal(100.0));
        product.setBlankOwnerRef(this.kvReference);
        product.setBlankOwnerNumber("348");
        for (BlankType type : BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef())) {
            if (type.getProductCategory() != ProductCategory.EXCESS_BAGAGE) continue;
            product.setBlankType((DictionaryReference)new BlankTypeReference(type));
            break;
        }
        product.setTicketType(TicketType.OWN);
        bf.setAgency(agencyRef);
        AirProductHelper.setSubagency((Product)product, subAgencyRef);
        AirProductHelper.setAgency((Product)product, agencyRef);
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setAgencyCode(((Organization)EntityStorage.get().resolve(subAgencyRef).getEntity()).getCode());
        ProductFop fop = new ProductFop();
        Money fopMoney = new Money();
        fopMoney.setCurrency("RUB");
        fopMoney.setValue(new BigDecimal(110));
        fop.setAmount(fopMoney);
        fop.setType(PaymentType.CASH);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setChecked(true);
        res.getProducts().add(product);
        bf.getReservations().add(res);
        this.setCommissions(product);
        return product;
    }

    private Product createMCO(BookingFile bf, EntityReference<Organization> agencyRef, EntityReference<Organization> subAgencyRef, String pnr, String ticketNo, String scn, MCOCategory mcoCategory, ProductStatus productStatus, Product relatedProduct) throws Exception {
        Reservation res = new Reservation();
        this.setRecordLocator(res, pnr);
        res.setBookingFile(bf);
        Product product = new Product();
        if (relatedProduct != null) {
            product.getRelatedProducts().add(relatedProduct);
        }
        Traveller traveller = new Traveller();
        traveller.setName("PUTIN MR.");
        product.setTraveller(traveller);
        product.setReservation(res);
        product.setSystemNumber(ticketNo);
        product.getScns().add(scn);
        product.setConjCount(0);
        product.setValidatorCode("11112222");
        product.setStatus(productStatus);
        product.setProductCategory(ProductCategory.MCO);
        product.setMcoCategory(mcoCategory);
        product.setTariffType(TariffType.REGULAR);
        product.setIssueDate(new Date());
        Money baseFare = new Money();
        baseFare.setCurrency("EUR");
        baseFare.setValue(new BigDecimal(10.0));
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)new BigDecimal(100.0));
        product.setBlankOwnerRef(this.kvReference);
        product.setBlankOwnerNumber("348");
        for (BlankType type : BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef())) {
            if (type.getProductCategory() != ProductCategory.MCO) continue;
            product.setBlankType((DictionaryReference)new BlankTypeReference(type));
            break;
        }
        product.setTicketType(TicketType.OWN);
        bf.setAgency(agencyRef);
        AirProductHelper.setSubagency((Product)product, subAgencyRef);
        AirProductHelper.setAgency((Product)product, agencyRef);
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setAgencyCode(((Organization)EntityStorage.get().resolve(subAgencyRef).getEntity()).getCode());
        ProductFop fop = new ProductFop();
        Money fopMoney = new Money();
        fopMoney.setCurrency("RUB");
        fopMoney.setValue(new BigDecimal(110));
        fop.setAmount(fopMoney);
        fop.setType(PaymentType.CASH);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setChecked(true);
        res.getProducts().add(product);
        bf.getReservations().add(res);
        this.setCommissions(product);
        return product;
    }

    private void setMultyAgencyReport(boolean enable) throws Exception {
        DictionaryStorage ds = DictionaryStorage.get();
        Collection dicts = ds.loadAll(null, Preference.class);
        for (BaseDictionary dict : dicts) {
            if (!((Preference)dict).getKey().equals((Object)PreferenceKey.XML_REPORT_TICKET_ORDER_FOR_MULTYAGENCY_REPORT)) continue;
            if (enable) {
                ((Preference)dict).setValue("YES");
            } else {
                ((Preference)dict).setValue("NO");
            }
            ds.save(dict);
            break;
        }
    }

    private void setCommissions(Product product) {
        BigDecimal commissionRate = new BigDecimal(7);
        Commission commission = new Commission();
        commission.setContractType(ContractType.VENDOR);
        commission.setRate(Double.valueOf(commissionRate.doubleValue()));
        commission.setEquivalentAmount(AirProductHelper.getEquivalentFare((Product)product).multiply(commissionRate.divide(new BigDecimal(100))));
        AirProductHelper.getVendorContractRelation((Product)product).getCommissions().add(commission);
    }

    private class TestKVSalesReportPrepareHandler
    extends KVSalesReportPrepareHandler {
        private TestKVSalesReportPrepareHandler() {
        }

        @Override
        protected void validateProductToReport(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        }
    }

    class TestKVRegistryRender
    extends KVSalesReportRenderHandler {
        TestKVRegistryRender() {
        }

        protected InputStream getInputStream(Map<String, Object> data) throws Exception {
            FileInputStream result = new FileInputStream("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/KVSalesReport.xls");
            return result;
        }
    }
}

