/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.nn;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.RequestedParameterCustomType;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.GeneralProductsTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.TemplateReportPageCustomParameterValue;
import com.gridnine.xtrip.common.reports.model.TemplateReportPageTemplate;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.system.model.SortOrderData;
import com.gridnine.xtrip.server.model.test.TestCommissionPropertiesBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestOrganizationBuilder;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNTransportationType;
import com.gridnine.xtrip.server.reports.salesreports.render.template.common.TemplateReportTestBase;
import java.util.Collection;

public class NNReportTestBase
extends TemplateReportTestBase {
    protected EntityReference<AirTicketsTemplateReportDescription> descriptionReference;

    protected void createReportDescription() throws Exception {
        EntityContainer ctr = new EntityContainer(AirTicketsTemplateReportDescription.class, "nn-reportDescription");
        AirTicketsTemplateReportDescription description = (AirTicketsTemplateReportDescription)ctr.getEntity();
        description.setTitle("Vim Avia report");
        description.setContentType(ContentType.EXCEL);
        description.setHideExchanges(true);
        TemplateReportPageTemplate template = new TemplateReportPageTemplate();
        template.setName("Letter");
        template.setContent(this.getTemplate("nn/nn-letter.groovy", ContentType.GROOVY));
        description.getTemplates().add(template);
        description.getPages().add(this.createTicketPageDescription("\u0440\u0430\u0441\u0447.\u043f\u0438\u0441\u044c\u043c\u043e", null, null, template));
        template = new TemplateReportPageTemplate();
        template.setName("Sell Template");
        template.setContent(this.getTemplate("nn/nn-sell-registry.groovy", ContentType.GROOVY));
        description.getTemplates().add(template);
        description.getPages().add(this.createTicketPageDescription("\u043f\u0440\u043e\u0434\u0430\u0436\u0430 \u0412\u0412\u041b", OperationBatch.SELL, NNTransportationType.VVL, template));
        description.getPages().add(this.createTicketPageDescription("\u043f\u0440\u043e\u0434\u0430\u0436\u0438 \u043f\u043e \u041a\u0440\u044b\u043c\u0443", OperationBatch.SELL, NNTransportationType.CRIMEA, template));
        description.getPages().add(this.createTicketPageDescription("\u043f\u0440\u043e\u0434\u0430\u0436\u0430 \u041c\u0412\u041b", OperationBatch.SELL, NNTransportationType.MVL, template));
        template = new TemplateReportPageTemplate();
        template.setName("Exchange Template");
        template.setContent(this.getTemplate("nn/nn-exchange-registry.groovy", ContentType.GROOVY));
        description.getTemplates().add(template);
        description.getPages().add(this.createTicketPageDescription("\u043e\u0431\u043c\u0435\u043d \u0412\u0412\u041b", OperationBatch.EXCHANGE, NNTransportationType.VVL, template));
        description.getPages().add(this.createTicketPageDescription("\u043e\u0431\u043c\u0435\u043d \u041a\u0440\u044b\u043c", OperationBatch.EXCHANGE, NNTransportationType.CRIMEA, template));
        description.getPages().add(this.createTicketPageDescription("\u043e\u0431\u043c\u0435\u043d \u041c\u0412\u041b", OperationBatch.EXCHANGE, NNTransportationType.MVL, template));
        template = new TemplateReportPageTemplate();
        template.setName("Refund Template");
        template.setContent(this.getTemplate("nn/nn-refund-registry.groovy", ContentType.GROOVY));
        description.getTemplates().add(template);
        description.getPages().add(this.createTicketPageDescription("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0412\u0412\u041b", OperationBatch.REFUND, NNTransportationType.VVL, template));
        description.getPages().add(this.createTicketPageDescription("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u041a\u0440\u044b\u043c", OperationBatch.REFUND, NNTransportationType.CRIMEA, template));
        description.getPages().add(this.createTicketPageDescription("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u041c\u0412\u041b", OperationBatch.REFUND, NNTransportationType.MVL, template));
        template = new TemplateReportPageTemplate();
        template.setName("Void Template");
        template.setContent(this.getTemplate("nn/nn-void-registry.groovy", ContentType.GROOVY));
        description.getTemplates().add(template);
        description.getPages().add(this.createTicketPageDescription("\u0430\u043d\u043d\u0443\u043b\u044f\u0446\u0438\u044f", OperationBatch.VOID, NNTransportationType.VVL, template));
        template = new TemplateReportPageTemplate();
        template.setName("Adm Template");
        template.setContent(this.getTemplate("nn/nn-adm.groovy", ContentType.GROOVY));
        description.getTemplates().add(template);
        description.getPages().add(this.createTicketPageDescription("\u0420\u0435\u0435\u0441\u0442\u0440 \u043f\u043e \u043f\u0440\u0435\u0442\u0435\u043d\u0437\u0438\u044f\u043c", null, null, template));
        EntityStorage.get().save(ctr, true);
        this.descriptionReference = ctr.toReference();
    }

    private GeneralProductsTemplateReportPageDescription createTicketPageDescription(String title, OperationBatch batch, NNTransportationType transportationType, TemplateReportPageTemplate template) {
        GeneralProductsTemplateReportPageDescription description = new GeneralProductsTemplateReportPageDescription();
        description.setName(title);
        description.setTemplate(template);
        TemplateReportPageCustomParameterValue param = new TemplateReportPageCustomParameterValue();
        param.setType(RequestedParameterCustomType.STRING);
        param.setKey("title");
        param.setValue((Object)title);
        description.getCustomParameters().add(param);
        if (transportationType != null) {
            param = new TemplateReportPageCustomParameterValue();
            param.setType(RequestedParameterCustomType.STRING);
            param.setKey("transportationType");
            param.setValue((Object)transportationType.name());
            description.getCustomParameters().add(param);
        }
        SortOrderData sortOrderData = new SortOrderData();
        sortOrderData.setPropertyName("sortingTicketNumber");
        sortOrderData.setOrder(SortOrder.ASC);
        description.getSortOrders().add(sortOrderData);
        sortOrderData = new SortOrderData();
        sortOrderData.setPropertyName("productCategory");
        sortOrderData.setOrder(SortOrder.ASC);
        description.getSortOrders().add(sortOrderData);
        if (batch != null) {
            description.getPageCriterions().add(SearchCriterion.eq((String)"operationBatch", (Object)batch.name()));
        }
        description.getPageCriterions().add(SearchCriterion.eq((String)"type", (Object)"PRODUCT"));
        return description;
    }

    @Override
    protected void createProfiles() throws Exception {
        super.createProfiles();
        this.blankOwner = new TestOrganizationBuilder().airline("NN").code("NN").types(new OrganizationType[]{OrganizationType.BLANK_OWNER}).create().toReference();
        EntityContainer agencyCtr = EntityStorage.get().resolve(this.agencyReference);
        SystemHelper.setMetadataValue((Collection)((Organization)agencyCtr.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_NN_AGENCY_CODE, (Object)"NN Agency");
        EntityStorage.get().save(agencyCtr, true);
        this.supplierRef = this.blankOwner;
        this.yqTaxCode = "SA";
        EntityReference cpRef = new TestCommissionPropertiesBuilder().rate(true).calculationBasis(CalculationBasis.FARE).displayName("Commission").create().toReference();
        new TestContractBuilderBuilder().airCommission(10.0, "%", cpRef).blankOwner(this.blankOwner).supplier(this.blankOwner).contractType(ContractType.VENDOR).customer(this.agency).create();
    }
}

