/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.s7;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntry;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryAssociationType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductRelatedProductGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.s7.S7RegistryRender;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.xml.SuXmlReportRender;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.parsers.test.ParsersTestHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.s7.S7SalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class S7ReportRenderTest
extends RenderSalesReportTestBase {
    private final String validatorCode = "111111";
    private Date currentDate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testS7ReportRender() throws Exception {
        Date currentDate0 = MiscUtil.clearTime((Date)new SimpleDateFormat("yyyy-MM-dd").parse("2011-11-10"));
        this.currentDate = MiscUtil.clearTime((Date)new SimpleDateFormat("yyyy-MM-dd").parse("2011-11-14"));
        this.createCurrencyRate("RUB", "EUR", currentDate0, 45.05, CurrencyRateType.CBR, null, TariffType.REGULAR);
        HashMap<MetadataKey, Object> agencyMetadatas = new HashMap<MetadataKey, Object>();
        agencyMetadatas.put(MetadataKey.KEY_S7_AGENCY_CODE, "0001");
        EntityContainer<Organization> agencyContainer = this.createOrganization("agency1", "ABC", "ABC agency", agencyMetadatas);
        EntityReference agencyReference = agencyContainer.toReference();
        EntityContainer<Organization> subagencyContainer = this.createOrganization("agency2", "ABC", "ABC agency", Collections.emptyMap());
        Pcc pcc = this.createPcc(GdsName.SABRE, "1234", (EntityReference<Organization>)agencyReference, null, null);
        Validator validator = this.createValidator("111111", (EntityReference<Organization>)this.s7Reference, (EntityReference<Organization>)this.s7Reference, (EntityReference<Organization>)agencyReference, pcc, null, null);
        HashMap<MetadataKey, Object> salesPointMetadatas = new HashMap<MetadataKey, Object>();
        this.createSalesPoint("agency1_salespoint1", "ABC Sales point", "ABC agecny Sales point", (EntityReference<Organization>)agencyReference, Arrays.asList(pcc), Arrays.asList(validator), salesPointMetadatas);
        Product sell = this.createTicket(agencyContainer, agencyContainer, "agency1", "9999999999", "0012345678", ProductStatus.SELL, PaymentType.CASH, null, null);
        this.createTicket(agencyContainer, agencyContainer, "agency1", "9999999999", "0012345678", ProductStatus.REFUND, PaymentType.CASH, sell, null);
        int startTicketNumber = 1000;
        for (int i = 0; i < 10; i += 2) {
            String ticketNo = String.valueOf(startTicketNumber + i);
            String ticketNoPlusOne = String.valueOf(startTicketNumber + i + 1);
            Product testSell1 = this.createTicket(agencyContainer, agencyContainer, "TESTPNR", ticketNo, "0012345678", ProductStatus.SELL, PaymentType.CASH, null, null);
            Product testSell2 = this.createTicket(agencyContainer, agencyContainer, "TESTPNR", ticketNoPlusOne, "0012345678", ProductStatus.SELL, PaymentType.CASH, null, null);
            Product testExch = this.createTicket(agencyContainer, agencyContainer, "TESTPNR", ticketNo, "0012345678", ProductStatus.EXCHANGE, PaymentType.CASH, testSell1, testSell2);
            ProductSearchResult psrSell1 = ParsersTestHelper.findProduct((String)ticketNo, (ProductStatus)ProductStatus.SELL);
            ((Product)psrSell1.getProduct()).setNextProduct(testExch);
            ProductSearchResult psrSell2 = ParsersTestHelper.findProduct((String)ticketNoPlusOne, (ProductStatus)ProductStatus.SELL);
            ((Product)psrSell2.getProduct()).setPreviousProduct(testExch);
            if (i == 8) {
                String ticketNoPlusTwo = String.valueOf(startTicketNumber + i + 2);
                Product testSell3 = this.createTicket(agencyContainer, agencyContainer, "TESTPNR", ticketNoPlusTwo, "0012345678", ProductStatus.SELL, PaymentType.CASH, null, null);
                Product testExch2 = this.createTicket(agencyContainer, agencyContainer, "TESTPNR", ticketNoPlusOne, "0012345678", ProductStatus.EXCHANGE, PaymentType.CASH, testSell2, testSell3);
                ((Product)psrSell2.getProduct()).setNextProduct(testExch2);
                ProductSearchResult psrSell3 = ParsersTestHelper.findProduct((String)ticketNoPlusTwo, (ProductStatus)ProductStatus.SELL);
                ((Product)psrSell3.getProduct()).setPreviousProduct(testExch2);
                this.save(psrSell3.getContainer());
            }
            this.save(psrSell1.getContainer());
            this.save(psrSell2.getContainer());
        }
        Product sell1 = this.createTicket(agencyContainer, subagencyContainer, "agency2", "001", "0012345678", ProductStatus.SELL, PaymentType.CASH, null, null);
        this.createTicket(agencyContainer, subagencyContainer, "agency2", "101", "0012345678", ProductStatus.REFUND, PaymentType.CASH, sell1, null);
        Product sell2 = this.createTicket(agencyContainer, subagencyContainer, "agency2", "002", "0022345678", ProductStatus.SELL, PaymentType.CASH, null, null);
        Product exch = this.createTicket(agencyContainer, subagencyContainer, "agency2", "030", "0022345678", ProductStatus.EXCHANGE, PaymentType.CASH, sell1, sell2);
        ProductSearchResult psr = ParsersTestHelper.findProduct((String)"002", (ProductStatus)ProductStatus.SELL);
        ((Product)psr.getProduct()).setPreviousProduct(exch);
        this.save(psr.getContainer());
        this.createTicket(agencyContainer, subagencyContainer, "sell100", "100", "100", ProductStatus.SELL, PaymentType.CASH, null, null).getUid();
        psr = ParsersTestHelper.findProduct((String)"100", (ProductStatus)ProductStatus.SELL);
        Product prod = (Product)psr.getProduct();
        Product mcoSell = new Product();
        AirProductHelper.copy((Product)prod, (Product)mcoSell, (boolean)true);
        mcoSell.setProductCategory(ProductCategory.MCO);
        mcoSell.setMcoCategory(MCOCategory.PTA);
        AirProductHelper.clearCommissions((Product)mcoSell);
        AirProductHelper.clearFops((Product)mcoSell);
        mcoSell.getTaxes().clear();
        mcoSell.setChecked(true);
        mcoSell.setCashier(this.agent);
        ProductFop fop = new ProductFop();
        fop.setOperationDate(mcoSell.getIssueDate());
        fop.setAgent(mcoSell.getCashier());
        fop.setType(PaymentType.CASH);
        fop.setAmount(SystemHelper.getMoney((double)0.0, (String)"RUB"));
        List vendorFops = AirProductHelper.getVendorContractRelation((Product)mcoSell).getFops();
        List clientFops = AirProductHelper.getClientContractRelation((Product)mcoSell).getFops();
        vendorFops.add(fop);
        clientFops.add(XCloneHelper.clone((XCloneable)fop, (boolean)true));
        AirProductHelper.setEquivalentFare((Product)mcoSell, (BigDecimal)BigDecimal.ZERO);
        mcoSell.getSegmentTariffs().clear();
        mcoSell.getRelatedProducts().add(prod);
        mcoSell.setSystemNumber("1011");
        Product mcoRefund = new Product();
        AirProductHelper.copy((Product)mcoSell, (Product)mcoRefund, (boolean)true);
        mcoRefund.setStatus(ProductStatus.REFUND);
        mcoRefund.setPreviousProduct(mcoSell);
        mcoSell.setNextProduct(mcoRefund);
        AirProductHelper.setEquivalentFare((Product)mcoRefund, (BigDecimal)BigDecimal.valueOf(200L));
        ((ProductFop)AirProductHelper.getVendorContractRelation((Product)mcoRefund).getFops().get(0)).getAmount().setValue(BigDecimal.valueOf(200L));
        ((ProductFop)AirProductHelper.getClientContractRelation((Product)mcoRefund).getFops().get(0)).getAmount().setValue(BigDecimal.valueOf(200L));
        this.save(psr.getContainer());
        sell = this.createTicket(agencyContainer, agencyContainer, "agency1", "9999999MTD", "0012345MTD", ProductStatus.SELL, PaymentType.MTD, null, null);
        sell = this.createTicket(agencyContainer, agencyContainer, "agency1", "9999999INT", "0012345INT", ProductStatus.SELL, PaymentType.INTERLINE, null, null);
        ((ProductFop)AirProductHelper.getVendorContractRelation((Product)sell).getFops().get(0)).setType(PaymentType.INTERLINE);
        this.createAgencyMemoProduct(agencyContainer, "agency1", "AGNCMEMO01", AgencyMemoProductType.ADM, true);
        this.createAgencyMemoProduct(agencyContainer, "agency1", "AGNCMEMO02", AgencyMemoProductType.ACM, false);
        this.createContract(agencyContainer, (EntityReference<Organization>)this.s7Reference);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.currentDate));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.currentDate));
        repParam.setAgency(agencyReference);
        repParam.setBlankOwner(this.s7Reference);
        repParam.setSupplier(this.s7Reference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.s7Reference).getEntity());
        S7SalesReportPrepareHandler prepHandler = new S7SalesReportPrepareHandler();
        this.setMultyAgencyReport(true);
        prepHandler.prepareData(parameters);
        SuXmlReportRender handler = new SuXmlReportRender();
        EntityContainer repDoc = handler.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)repDoc.getEntity()).getFiles().iterator().next();
        byte[] content = repFile.getContent();
        this.log.debug(new String(content));
        TestS7RegistryRender registryHandler = new TestS7RegistryRender();
        EntityContainer regRepDoc = registryHandler.renderReport(parameters);
        repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        File outFile = this.buildOutputFileName("S7Reg.xls");
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(repFile.getContent());
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("testReport.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    private void createContract(EntityContainer<Organization> agencyRef, EntityReference<Organization> vendorRef) throws Exception {
        EntityContainer commPercent = new EntityContainer(CommissionProperties.class);
        ((CommissionProperties)commPercent.getEntity()).setDisplayName("Commission %");
        ((CommissionProperties)commPercent.getEntity()).setRate(true);
        ((CommissionProperties)commPercent.getEntity()).setRoundingMode(RoundingMode.NONE);
        ((CommissionProperties)commPercent.getEntity()).setRate(true);
        EntityStorage.get().save(commPercent, false);
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        contract.setVendor(vendorRef);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.currentDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(vendorRef);
        info.setCustomer(new EntityReference(agencyRef));
        contract.setVendor(vendorRef);
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("A1");
        RuleRestriction restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)"S7");
        rs.getRestrictions().add(restr);
        RuleResult res = new RuleResult();
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(commPercent.toReference());
        value.setValue(2.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        this.save(cc);
    }

    private AgencyMemoProduct createAgencyMemoProduct(EntityContainer<Organization> agencyContainer, String pnr, String systemNumber, AgencyMemoProductType type, boolean reportAssociated) throws Exception {
        EntityContainer bookingFileContainer = new EntityContainer(BookingFile.class);
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        Reservation reservation = new Reservation();
        this.setRecordLocator(reservation, pnr);
        reservation.setBookingFile(bookingFile);
        AgencyMemoProduct agencyMemoProduct = new AgencyMemoProduct();
        agencyMemoProduct.setReservation(reservation);
        agencyMemoProduct.setAirlineCode("421");
        agencyMemoProduct.setSystemNumber(systemNumber);
        agencyMemoProduct.setType(type);
        agencyMemoProduct.setBlankOwner(this.s7Reference);
        agencyMemoProduct.setSupplier(this.s7Reference);
        agencyMemoProduct.setAgency(agencyContainer.toReference());
        bookingFile.setAgency(agencyContainer.toReference());
        agencyMemoProduct.setIssueDate(this.currentDate);
        agencyMemoProduct.setAcceptDate(this.currentDate);
        agencyMemoProduct.setSourceReportDate(this.currentDate);
        agencyMemoProduct.setTargetReportDate(this.currentDate);
        agencyMemoProduct.setIncludeToReport(true);
        if (reportAssociated) {
            Money amount = new Money();
            amount.setValue(BigDecimal.valueOf(120.0));
            amount.setCurrency("RUB");
            BigDecimal equivalentAmount = BigDecimal.valueOf(120.0);
            AgencyMemoProductEntry entry = new AgencyMemoProductEntry();
            entry.setProduct(agencyMemoProduct);
            entry.setType(AgencyMemoProductEntryType.PENALTY);
            entry.setAssociationType(AgencyMemoProductEntryAssociationType.REPORT);
            entry.setRelatedProductNumber(null);
            entry.setAmount(amount);
            entry.setEquivalentAmount(equivalentAmount);
            agencyMemoProduct.getEntries().add(entry);
            AgencyMemoProductItemGroup itemGroup = new AgencyMemoProductItemGroup();
            itemGroup.setType(AgencyMemoProductEntryType.PENALTY);
            itemGroup.setAmount(amount);
            itemGroup.setEquivalentAmount(equivalentAmount);
            itemGroup.getEntries().add(entry);
            agencyMemoProduct.getItemGroups().add(itemGroup);
            AgencyMemoProductRelatedProductGroup relatedProductGroup = new AgencyMemoProductRelatedProductGroup();
            relatedProductGroup.setAssociationType(AgencyMemoProductEntryAssociationType.REPORT);
            relatedProductGroup.setRelatedProductNumber(null);
            relatedProductGroup.getEntries().add(entry);
            agencyMemoProduct.getRelatedProductGroups().add(relatedProductGroup);
        } else {
            Money amount = new Money();
            amount.setValue(BigDecimal.valueOf(4.5));
            amount.setCurrency("EUR");
            BigDecimal equivalentAmount = BigDecimal.valueOf(202.725);
            AgencyMemoProductEntry entry01 = new AgencyMemoProductEntry();
            entry01.setProduct(agencyMemoProduct);
            entry01.setType(AgencyMemoProductEntryType.CONTRACT_PENALTY);
            entry01.setAssociationType(AgencyMemoProductEntryAssociationType.PRODUCT);
            entry01.setRelatedProductNumber("001");
            entry01.setAmount(amount);
            entry01.setEquivalentAmount(equivalentAmount);
            AgencyMemoProductEntry entry02 = new AgencyMemoProductEntry();
            entry02.setProduct(agencyMemoProduct);
            entry02.setType(AgencyMemoProductEntryType.TAX_FUEL);
            entry02.setAssociationType(AgencyMemoProductEntryAssociationType.PRODUCT);
            entry02.setRelatedProductNumber("002");
            entry02.setAmount(amount);
            entry02.setEquivalentAmount(equivalentAmount);
            agencyMemoProduct.getEntries().add(entry01);
            agencyMemoProduct.getEntries().add(entry02);
            AgencyMemoProductItemGroup itemGroup = new AgencyMemoProductItemGroup();
            itemGroup.setType(AgencyMemoProductEntryType.CONTRACT_PENALTY);
            itemGroup.setAmount(amount);
            itemGroup.setEquivalentAmount(equivalentAmount);
            itemGroup.getEntries().add(entry01);
            agencyMemoProduct.getItemGroups().add(itemGroup);
            amount = new Money();
            amount.setValue(BigDecimal.valueOf(1.0));
            amount.setCurrency("EUR");
            equivalentAmount = BigDecimal.valueOf(45.05);
            itemGroup = new AgencyMemoProductItemGroup();
            itemGroup.setType(AgencyMemoProductEntryType.TAX_FUEL);
            itemGroup.setAmount(amount);
            itemGroup.setEquivalentAmount(equivalentAmount);
            itemGroup.getEntries().add(entry02);
            agencyMemoProduct.getItemGroups().add(itemGroup);
            AgencyMemoProductRelatedProductGroup relatedProductGroup = new AgencyMemoProductRelatedProductGroup();
            relatedProductGroup.setAssociationType(AgencyMemoProductEntryAssociationType.PRODUCT);
            relatedProductGroup.setRelatedProductNumber("001");
            relatedProductGroup.getEntries().add(entry01);
            agencyMemoProduct.getRelatedProductGroups().add(relatedProductGroup);
            relatedProductGroup = new AgencyMemoProductRelatedProductGroup();
            relatedProductGroup.setAssociationType(AgencyMemoProductEntryAssociationType.PRODUCT);
            relatedProductGroup.setRelatedProductNumber("002");
            relatedProductGroup.getEntries().add(entry02);
            agencyMemoProduct.getRelatedProductGroups().add(relatedProductGroup);
        }
        reservation.getProducts().add(agencyMemoProduct);
        bookingFile.getReservations().add(reservation);
        this.save(bookingFileContainer);
        return agencyMemoProduct;
    }

    private Product createTicket(EntityContainer<Organization> agencyContainer, EntityContainer<Organization> subagencyContainer, String pnr, String systemNumber, String scn, ProductStatus productStatus, PaymentType paymentType, Product previousProduct, Product nextProduct) throws Exception {
        EntityContainer bookingFileContainer = new EntityContainer(BookingFile.class);
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        Reservation reservation = new Reservation();
        this.setRecordLocator(reservation, pnr);
        reservation.setBookingFile(bookingFile);
        Product product = new Product();
        product.setReservation(reservation);
        Traveller traveller = new Traveller();
        traveller.setName("PUTIN MR.");
        product.setTraveller(traveller);
        product.setPreviousProduct(previousProduct);
        product.setNextProduct(nextProduct);
        product.setSystemNumber(systemNumber);
        product.getScns().add(scn);
        product.setConjCount(0);
        product.setStatus(productStatus);
        product.setProductCategory(ProductCategory.AIR);
        product.setTariffType(TariffType.REGULAR);
        product.setValidatorCode("111111");
        product.setIssueDate(this.currentDate);
        product.setCashier(this.agent);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)new BigDecimal(100.0));
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setEquivalentAmount(new BigDecimal(37));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("YR");
        tax.setEquivalentAmount(new BigDecimal(1200));
        product.getTaxes().add(tax);
        Money baseFare = new Money();
        baseFare.setCurrency("EUR");
        baseFare.setValue(new BigDecimal(10.0));
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        Airline airline = DictHelper.findAirlineByAnyCode((String)"421");
        product.setBlankOwnerRef(((EntityContainer)ProfileDao.getBlankOwnersByAirline((DictionaryReference)airline.toReference()).get(0)).toReference());
        product.setBlankOwnerNumber("421");
        for (BlankType blankType : BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef())) {
            if (!blankType.getCode().equals("421 24")) continue;
            product.setBlankType((DictionaryReference)new BlankTypeReference(blankType));
            break;
        }
        SegmentTariff segmentTariff = new SegmentTariff();
        Segment segment = new Segment();
        segment.setAirline((DictionaryReference)airline.toReference());
        segment.setFlightNo("101");
        segment.setDepartCityCode("SVO");
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("SVO"));
        segment.setArriveCityCode("LHR");
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("LHR"));
        segment.setRecordNumber(1);
        segment.setFareBasis("5");
        segmentTariff.getSegments().add(segment);
        segment = new Segment();
        segment.setAirline((DictionaryReference)airline.toReference());
        segment.setFlightNo("102");
        segment.setDepartCityCode("LHR");
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("LHR"));
        segment.setArriveCityCode("SVO");
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("SVO"));
        segment.setRecordNumber(3);
        segment.setFareBasis("5");
        segmentTariff.getSegments().add(segment);
        product.getSegmentTariffs().add(segmentTariff);
        product.setTicketType(TicketType.OWN);
        bookingFile.setAgency(new EntityReference(agencyContainer));
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        AirProductHelper.setAgency((Product)product, (EntityReference)agencyContainer.toReference());
        AirProductHelper.setSubagency((Product)product, (EntityReference)new EntityReference(subagencyContainer));
        product.setAgencyCode(((Organization)subagencyContainer.getEntity()).getCode());
        ProductFop fop = new ProductFop();
        fop.setType(paymentType);
        if (paymentType == PaymentType.MTD) {
            fop.setRelatedTicketNumber("RT 12345");
            fop.setPassengerStatus(PassengerStatus.VS_MVD);
        }
        Money fopMoney = new Money();
        fopMoney.setValue(new BigDecimal(1337));
        fopMoney.setCurrency("RUB");
        fop.setAmount(fopMoney);
        fop.setOperationDate(product.getIssueDate());
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setChecked(true);
        List blankTypes = BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef());
        for (BlankType type : blankTypes) {
            if (type.getBlankCategory() != BlankCategory.ETICKET) continue;
            product.setBlankType((DictionaryReference)type.toReference());
            product.setProductCategory(type.getProductCategory());
            break;
        }
        reservation.getProducts().add(product);
        bookingFile.getReservations().add(reservation);
        this.save(bookingFileContainer);
        return product;
    }

    private void setMultyAgencyReport(boolean enable) throws Exception {
        DictionaryStorage sictionaryStorage = DictionaryStorage.get();
        Collection baseDictionaries = sictionaryStorage.loadAll(null, Preference.class);
        for (BaseDictionary baseDictionary : baseDictionaries) {
            if (!((Preference)baseDictionary).getKey().equals((Object)PreferenceKey.XML_REPORT_TICKET_ORDER_FOR_MULTYAGENCY_REPORT)) continue;
            if (enable) {
                ((Preference)baseDictionary).setValue("YES");
            } else {
                ((Preference)baseDictionary).setValue("NO");
            }
            sictionaryStorage.save(baseDictionary);
            break;
        }
    }

    class TestS7RegistryRender
    extends S7RegistryRender<SuTicket> {
        TestS7RegistryRender() {
        }

        protected File getTemplateFile() throws IOException {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            if (!result.exists()) {
                throw new IOException("Template " + result.getCanonicalPath() + " was not found");
            }
            return result;
        }
    }
}

