/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.s7;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.reports.salesreports.render.s7.S7SalesReportTestBase;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;

public class S7ResidualValueForRefundReportTest
extends S7SalesReportTestBase {
    @Test
    public void testReport() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.currentDate = sdf.parse("2019-01-03");
        String productUid = this.createTicket((EntityReference<Organization>)TestBookingFileBuilder.agency, (EntityReference<Organization>)TestBookingFileBuilder.agency, "0001", "0001", null, ProductStatus.SELL).getUid();
        ProductSearchResult productSearchResult = BookingDao.findProductByUid((String)productUid);
        Product prod = (Product)BookingHelper.findProduct((BookingFile)productSearchResult.getBookingFile(), (String)productUid);
        prod.setProductCategory(ProductCategory.MCO);
        prod.setMcoCategory(MCOCategory.RESIDUAL_VALUE_FOR_REFUND);
        prod.getFares().clear();
        prod.getTaxes().clear();
        prod.getSegmentTariffs().clear();
        AirProductHelper.setEquivalentFare((Product)prod, (BigDecimal)BigDecimal.valueOf(-13L));
        AirProductHelper.setBaseFare((Product)prod, (Money)SystemHelper.getMoney((double)-13.0, (String)DictHelper.getEquivCurrency()));
        ((ProductFop)AirProductHelper.getVendorFops((Product)prod).get(0)).setAmount(SystemHelper.getMoney((double)-13.0, (String)DictHelper.getEquivCurrency()));
        ((ProductFop)AirProductHelper.getClientFops((Product)prod).get(0)).setAmount(SystemHelper.getMoney((double)-13.0, (String)DictHelper.getEquivCurrency()));
        EntityStorage.get().save(productSearchResult.getContainer(), true);
        File result = this.createReport("residualReport.xls", sdf.parse("2019-01-01"), sdf.parse("2019-01-10"));
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("residualReport.xls")), (File)result);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

