/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.s7;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.s7.S7RegistryRender;
import com.gridnine.xtrip.common.reports.render.salesreports.s7.S7Ticket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.reports.prepare.salesreports.s7.S7SalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

abstract class S7SalesReportTestBase
extends RenderSalesReportTestBase {
    protected final String validatorCode = "111111";
    protected Date currentDate;
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    S7SalesReportTestBase() {
    }

    protected Product createTicket(EntityReference<Organization> agencyRef, EntityReference<Organization> subAgencyRef, String pnr, String ticketNo, String scn, ProductStatus productStatus) throws Exception {
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile bf = (BookingFile)bfc.getEntity();
        Reservation res = new Reservation();
        this.setRecordLocator(res, pnr);
        res.setBookingFile(bf);
        Product product = new Product();
        Traveller traveller = new Traveller();
        traveller.setName("PUTIN MR.");
        product.setTraveller(traveller);
        product.setReservation(res);
        product.setSystemNumber(ticketNo);
        product.getScns().add(scn);
        product.setConjCount(0);
        product.setStatus(productStatus);
        product.setProductCategory(ProductCategory.AIR);
        product.setTariffType(TariffType.REGULAR);
        product.setIssueDate(this.currentDate);
        product.setValidatorCode("111111");
        product.setCashier(this.directorRef);
        BigDecimal fopAmount = BigDecimal.ZERO;
        BigDecimal amount = new BigDecimal(37);
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setEquivalentAmount(amount);
        product.getTaxes().add(tax);
        fopAmount = fopAmount.add(amount);
        amount = new BigDecimal(1200);
        tax = new Tax();
        tax.setCode("YR");
        tax.setEquivalentAmount(amount);
        product.getTaxes().add(tax);
        fopAmount = fopAmount.add(amount);
        amount = new BigDecimal(788);
        tax = new Tax();
        tax.setCode("CZ");
        tax.setEquivalentAmount(amount);
        product.getTaxes().add(tax);
        fopAmount = fopAmount.add(amount);
        Money baseFare = new Money();
        baseFare.setCurrency("EUR");
        baseFare.setValue(new BigDecimal(10.0));
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        BigDecimal equivlanetFare = new BigDecimal(105.0);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)equivlanetFare);
        fopAmount = fopAmount.add(equivlanetFare);
        Airline airline = DictHelper.findAirlineByAnyCode((String)"421");
        product.setBlankOwnerRef(((EntityContainer)ProfileDao.getBlankOwnersByAirline((DictionaryReference)airline.toReference()).get(0)).toReference());
        product.setBlankOwnerNumber("421");
        Iterator iterator = BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef()).iterator();
        if (iterator.hasNext()) {
            BlankType bt = (BlankType)iterator.next();
            bt.getCode().equals("421 24");
            product.setBlankType((DictionaryReference)new BlankTypeReference(bt));
        }
        SegmentTariff st = new SegmentTariff();
        Segment seg = new Segment();
        seg.setAirline((DictionaryReference)airline.toReference());
        seg.setFlightNo("101");
        seg.setDepartCityCode("SVO");
        seg.setDepartureLocation((DictionaryReference)new GeoLocationReference("SVO"));
        seg.setArriveCityCode("LHR");
        seg.setArriveLocation((DictionaryReference)new GeoLocationReference("LHR"));
        seg.setRecordNumber(1);
        seg.setFareBasis("10");
        st.getSegments().add(seg);
        seg = new Segment();
        seg.setAirline((DictionaryReference)airline.toReference());
        seg.setFlightNo("102");
        seg.setDepartCityCode("LHR");
        seg.setDepartureLocation((DictionaryReference)new GeoLocationReference("LHR"));
        seg.setArriveCityCode("SVO");
        seg.setArriveLocation((DictionaryReference)new GeoLocationReference("SVO"));
        seg.setRecordNumber(2);
        seg.setFareBasis("10");
        st.getSegments().add(seg);
        product.getSegmentTariffs().add(st);
        product.setTicketType(TicketType.OWN);
        bf.setAgency(agencyRef);
        AirProductHelper.setSubagency((Product)product, subAgencyRef);
        AirProductHelper.setAgency((Product)product, agencyRef);
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        EntityContainer subAgencyContainer = EntityStorage.get().resolve(subAgencyRef);
        product.setAgencyCode(((Organization)subAgencyContainer.getEntity()).getCode());
        ProductFop fop = new ProductFop();
        Money fopMoney = new Money();
        fopMoney.setCurrency("RUB");
        fopMoney.setValue(fopAmount);
        fop.setAmount(fopMoney);
        fop.setType(PaymentType.CASH);
        fop.setOperationDate(product.getIssueDate());
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setChecked(true);
        List blankTypes = BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef());
        for (BlankType type : blankTypes) {
            if (type.getBlankCategory() != BlankCategory.ETICKET) continue;
            product.setBlankType((DictionaryReference)type.toReference());
            product.setProductCategory(type.getProductCategory());
            break;
        }
        res.getProducts().add(product);
        bf.getReservations().add(res);
        EntityStorage.get().save(bfc, false);
        return product;
    }

    protected void setMultyAgencyReport(boolean enable) throws Exception {
        DictionaryStorage ds = DictionaryStorage.get();
        Collection dicts = ds.loadAll(null, Preference.class);
        for (BaseDictionary dict : dicts) {
            if (!((Preference)dict).getKey().equals((Object)PreferenceKey.XML_REPORT_TICKET_ORDER_FOR_MULTYAGENCY_REPORT)) continue;
            if (enable) {
                ((Preference)dict).setValue("YES");
            } else {
                ((Preference)dict).setValue("NO");
            }
            ds.save(dict);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createReport(String fileName, Date startDate, Date endDate) throws Exception {
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)startDate));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)endDate));
        repParam.setAgency(TestBookingFileBuilder.agency);
        repParam.setBlankOwner(this.s7Reference);
        repParam.setSupplier(this.s7Reference);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.s7Reference).getEntity());
        S7SalesReportPrepareHandler prepHandler = new S7SalesReportPrepareHandler();
        prepHandler.prepareData(parameters);
        TestS7RegistryRender registryHandler = new TestS7RegistryRender();
        EntityContainer regRepDoc = registryHandler.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        File outFile = this.buildOutputFileName(fileName);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(repFile.getContent());
        }
        return outFile;
    }

    static class TestS7RegistryRender
    extends S7RegistryRender<S7Ticket> {
        TestS7RegistryRender() {
        }

        protected File getTemplateFile() throws IOException {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            if (!result.exists()) {
                throw new IOException("Template " + result.getCanonicalPath() + " was not found");
            }
            return result;
        }
    }
}

