/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.s7.tripartite.newform;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LegalFormReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.TripartiteReportDocument;
import com.gridnine.xtrip.common.reports.model.TripartiteReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.s7.tripartite.newform.S7TripartiteReportNewFormRenderHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.reports.prepare.salesreports.s7.tripartite.newform.S7TripartiteReportNewFormPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class S7TripartiteReportNewFormTest
extends RenderSalesReportTestBase {
    private EntityReference<Organization> agencyRef;
    private EntityReference<Organization> clientRef;
    private EntityReference<Contract> contractRef;
    private String contractCode;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReport() throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.createProfiles();
        TripartiteReportParameters params = new TripartiteReportParameters();
        params.setPeriodBegin(this.sdf.parse("2009.04.01"));
        params.setPeriodEnd(this.sdf.parse("2009.05.01"));
        params.setAgency(this.agencyRef);
        params.setClient(this.clientRef);
        params.setContract(this.contractRef);
        params.setContractCode(this.contractCode);
        this.createTickets();
        S7TripartiteReportNewFormPrepareHandler handler = new S7TripartiteReportNewFormPrepareHandler();
        data.put("key-report-params", params);
        handler.prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage()), (boolean)true);
        }
        File outFile = new File(this.getOutFolder(), "S7tripartiteNewForm.xls");
        S7TripartiteReportNewFormRenderHandler renderHandler = new S7TripartiteReportNewFormRenderHandler(){

            protected InputStream getInputStream(Map<String, Object> aData) throws Exception {
                return new FileInputStream(new File("./plugins/com.gridnine.xtrip.common.reports/templates/salesreports/S7TripartiteNewForm.xls"));
            }
        };
        EntityContainer renderReport = renderHandler.renderReport(data);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(((TripartiteReportDocument)renderReport.getEntity()).getFile().getContent());
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("S7tripartiteNewForm.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    private void createTickets() throws Exception {
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile result = (BookingFile)bfc.getEntity();
        result.setCustomerProfile(this.clientRef);
        String user = LogicalStorage.get().getUser();
        bfc.setCreatedBy(user);
        bfc.setModifiedBy(user);
        Reservation reservation = new Reservation();
        reservation.setBookingFile(result);
        result.getReservations().add(reservation);
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        result.getTravellers().add(traveller);
        result.setAgency(this.agencyRef);
        Product product = new Product();
        product.setIssueDate(this.sdf.parse("2009.04.05"));
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setTraveller(traveller);
        product.setProductCategory(ProductCategory.AIR);
        product.setBlankOwnerRef(this.s7Reference);
        product.setBlankOwnerNumber("421");
        product.setStatus(ProductStatus.SELL);
        product.setValidatorCode("123");
        product.setTariffType(TariffType.REGULAR);
        product.setTicketType(TicketType.OWN);
        product.setCarrier((DictionaryReference)new AirlineReference("S7"));
        product.setCarrierNumber("421");
        product.setBlankType((DictionaryReference)new BlankTypeReference("421 42"));
        product.getTripartiteContractDetails().setContract(this.contractRef);
        product.getTripartiteContractDetails().setContractCode(this.contractCode);
        product.getTripartiteContractDetails().setDiscountValue(BigDecimal.valueOf(10L));
        AirProductHelper.setAgency((Product)product, this.agencyRef);
        AirProductHelper.setSupplier((Product)product, (EntityReference)this.s7Reference);
        product.setChecked(true);
        product.setCashier(this.agent);
        Segment segment = new Segment();
        segment.setStartDate(this.sdf.parse("2009.04.05"));
        segment.setAirline((DictionaryReference)new AirlineReference("S7"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("MOW"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("PAR"));
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        segment.setFlightNo("n1");
        segment.setFareBasis("fb1");
        segment.setRecordNumber(1);
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(50L));
        AirProductHelper.setSegmentBaseFare((Product)product, (SegmentTariff)sppPsgr, (Money)SystemHelper.getMoney((double)50.0, (String)"RUB"));
        Tax tax = new Tax();
        tax.setCode("TTcode");
        tax.setEquivalentAmount(BigDecimal.valueOf(50L));
        tax.setSegmentTariff(sppPsgr);
        product.getTaxes().add(tax);
        segment = new Segment();
        segment.setStartDate(this.sdf.parse("2009.04.05"));
        segment.setAirline((DictionaryReference)new AirlineReference("S7"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("PAR"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("MOW"));
        segment.setFlightNo("n2");
        segment.setFareBasis("fb1");
        segment.setRecordNumber(2);
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(50L));
        AirProductHelper.setSegmentBaseFare((Product)product, (SegmentTariff)sppPsgr, (Money)SystemHelper.getMoney((double)50.0, (String)"RUB"));
        tax = new Tax();
        tax.setCode("TTcode");
        tax.setEquivalentAmount(BigDecimal.valueOf(50L));
        tax.setSegmentTariff(sppPsgr);
        product.getTaxes().add(tax);
        ProductFop fop = new ProductFop();
        fop.setType(PaymentType.CASH);
        fop.setOperationDate(product.getIssueDate());
        fop.setAmount(SystemHelper.getMoney((double)200.0, (String)"RUB"));
        product.setSystemNumber("A1");
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product = new Product();
        product.setIssueDate(this.sdf.parse("2009.04.05"));
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setTraveller(traveller);
        product.setProductCategory(ProductCategory.AIR);
        product.setBlankOwnerRef(this.s7Reference);
        product.setBlankOwnerNumber("421");
        product.setStatus(ProductStatus.SELL);
        product.setValidatorCode("123");
        product.setTariffType(TariffType.REGULAR);
        product.setCarrier((DictionaryReference)new AirlineReference("S7"));
        product.setCarrierNumber("421");
        product.setBlankType((DictionaryReference)new BlankTypeReference("421 42"));
        product.setTicketType(TicketType.OWN);
        product.getTripartiteContractDetails().setContract(this.contractRef);
        product.getTripartiteContractDetails().setContractCode(this.contractCode);
        product.getTripartiteContractDetails().setDiscountValue(BigDecimal.valueOf(10L));
        AirProductHelper.setAgency((Product)product, this.agencyRef);
        AirProductHelper.setSupplier((Product)product, (EntityReference)this.s7Reference);
        product.setChecked(true);
        product.setCashier(this.agent);
        segment = new Segment();
        segment.setStartDate(this.sdf.parse("2009.04.05"));
        segment.setAirline((DictionaryReference)new AirlineReference("S7"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("MOW"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("PAR"));
        segment.setFlightNo("n1");
        segment.setFareBasis("f21");
        segment.setRecordNumber(1);
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(50L));
        AirProductHelper.setSegmentBaseFare((Product)product, (SegmentTariff)sppPsgr, (Money)SystemHelper.getMoney((double)50.0, (String)"RUB"));
        tax = new Tax();
        tax.setCode("TTcode");
        tax.setEquivalentAmount(BigDecimal.valueOf(50L));
        tax.setSegmentTariff(sppPsgr);
        product.getTaxes().add(tax);
        segment = new Segment();
        segment.setStartDate(this.sdf.parse("2009.04.05"));
        segment.setAirline((DictionaryReference)new AirlineReference("S7"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("PAR"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("MOW"));
        segment.setFlightNo("n2");
        segment.setFareBasis("fb2");
        segment.setRecordNumber(2);
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(50L));
        AirProductHelper.setSegmentBaseFare((Product)product, (SegmentTariff)sppPsgr, (Money)SystemHelper.getMoney((double)50.0, (String)"RUB"));
        tax = new Tax();
        tax.setCode("TTcode");
        tax.setEquivalentAmount(BigDecimal.valueOf(50L));
        tax.setSegmentTariff(sppPsgr);
        product.getTaxes().add(tax);
        fop = new ProductFop();
        fop.setType(PaymentType.CASH);
        fop.setOperationDate(product.getIssueDate());
        fop.setAmount(SystemHelper.getMoney((double)200.0, (String)"RUB"));
        product.setSystemNumber("A2");
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        EntityStorage.get().save(bfc, true);
    }

    private void createProfiles() throws Exception {
        String user = LogicalStorage.get().getUser();
        EntityContainer agencyContainer = new EntityContainer(Organization.class);
        agencyContainer.setCreatedBy(user);
        agencyContainer.setModifiedBy(user);
        Organization agency = (Organization)agencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"testAgency", (Locale)Locale.ENGLISH);
        agency.setActive(true);
        agency.setCode("testAgency");
        EntityStorage es = EntityStorage.get();
        SystemHelper.setMetadataValue((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_S7_AGENCY_CODE, (Object)"testCode");
        es.save(agencyContainer, true);
        this.agencyRef = agencyContainer.toReference();
        EntityContainer clientContainer = new EntityContainer(Organization.class);
        clientContainer.setCreatedBy(user);
        clientContainer.setModifiedBy(user);
        Organization client = (Organization)clientContainer.getEntity();
        L10nStringHelper.setValue((L10nString)client.getShortName(), (String)"testClient", (Locale)Locale.ENGLISH);
        client.setActive(true);
        client.setCode("testClient");
        L10nStringHelper.setValue((L10nString)client.getFullName(), (String)"Test client", (Locale)Locale.ENGLISH);
        client.setLegalForm((DictionaryReference)new LegalFormReference("OOO"));
        es.save(clientContainer, true);
        this.clientRef = clientContainer.toReference();
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        cc.setCreatedBy(user);
        cc.setModifiedBy(user);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(this.sdf.parse("2009.04.01"));
        info.setStartDate(this.sdf.parse("2009.04.01"));
        info.setEndDate(this.sdf.parse("2010.04.01"));
        this.contractCode = "testCode";
        info.setContractCode(this.contractCode);
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(this.s7Reference);
        info.setCustomer(this.clientRef);
        contract.setVendor(this.s7Reference);
        info.setNumber("01");
        es.save(cc, true);
        this.contractRef = cc.toReference();
    }
}

