/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.su;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterTariffInfo;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SuSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.su.SUBCReportTestBase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class Bug1772Test
extends SUBCReportTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.rtEconomyTariff = BigDecimal.valueOf(250L);
        this.owEconomyTariff = BigDecimal.valueOf(350L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOwReportRender() throws Exception {
        this.createProfiles();
        this.createTicket("2010-01-30", "2010-02-02", this.forwardFlight, null, null, "MOW", "LON", null, ProductStatus.SELL);
        ProductSearchResult sr = this.createTicket("2010-01-30", "2010-01-29", this.forwardFlight, "2010-02-06", this.backwardFlight, "MOW", "LON", null, ProductStatus.SELL);
        sr = this.createTicket("2010-01-30", "2010-01-29", this.forwardFlight, "2010-02-06", this.backwardFlight, "MOW", "LON", sr, ProductStatus.REFUND);
        Product product = (Product)sr.getProduct();
        AirProductHelper.clearCommissions((Product)product);
        product.getSegmentTariffs().remove(0);
        AirProductHelper.setBaseFare((Product)product, (Money)SystemHelper.getMoney((double)0.0, (String)"USD"));
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.ZERO);
        ((ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(0)).getAmount().setValue(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product));
        EntityStorage.get().save(sr.getContainer(), false);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.df.parse("2010-02-01")));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.df.parse("2010-02-10")));
        repParam.setAgency(this.agencyRef);
        repParam.setBlankOwner(this.suReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuSalesReportPrepareHandler prepHandler = new SuSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        Map bcDataMap = (Map)parameters.get("KEY_BLOCK_CHARTER_DATA");
        Assert.assertEquals((long)1L, (long)bcDataMap.values().size());
        parameters.put("KEY_BLOCK_CHARTER_DATA", bcDataMap.values().iterator().next());
        SUBCReportTestBase.TestSuBcProgramReportRenderer suBbRender = new SUBCReportTestBase.TestSuBcProgramReportRenderer();
        EntityContainer regRepDoc = suBbRender.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        File fileName = this.buildOutputFileName("bug1772.xls");
        try (FileOutputStream fileOut = new FileOutputStream(fileName);){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("bug1772Pattern.xls")), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    private ProductSearchResult createTicket(String issueDate, String forwardDate, String ffNumber, String backwardDate, String bfNumber, String firstCity, String lastCity, ProductSearchResult previousProduct, ProductStatus status) throws Exception {
        Segment seg;
        SegmentTariff st;
        EntityContainer bfc = null;
        Product product = new Product();
        if (previousProduct != null) {
            bfc = previousProduct.getContainer();
            Product sell = (Product)previousProduct.getProduct();
            product.setTraveller(sell.getTraveller());
            product.setReservation(sell.getReservation());
            sell.getReservation().getProducts().add(product);
            product.setPreviousProduct(sell);
            sell.setNextProduct(product);
            product.setStatus(ProductStatus.REFUND);
            product.setSystemNumber(sell.getSystemNumber());
            product.getScns().addAll(sell.getScns());
            product.setBlankType(sell.getBlankType());
        } else {
            ++this.count;
            bfc = new EntityContainer(BookingFile.class);
            Reservation res = new Reservation();
            this.setRecordLocator(res, "PNR" + this.count);
            res.setBookingFile((BookingFile)bfc.getEntity());
            ((BookingFile)bfc.getEntity()).getReservations().add(res);
            product.setSystemNumber("000" + this.count);
            product.getScns().add(product.getSystemNumber());
            product.setConjCount(0);
            product.setStatus(status);
            product.setReservation(res);
            res.getProducts().add(product);
        }
        BookingFile bf = (BookingFile)bfc.getEntity();
        product.setProductCategory(ProductCategory.AIR);
        product.setTariffType(TariffType.BLOCKCHARTER);
        product.setValidatorCode(this.validatorNumber);
        product.setIssueDate(this.df.parse(issueDate));
        product.setSalesPoint(this.salesPointRef);
        BigDecimal fare = null;
        fare = forwardDate == null || backwardDate == null ? this.owEconomyTariff : this.rtEconomyTariff;
        Money baseFare = new Money();
        baseFare.setCurrency("USD");
        baseFare.setValue(fare.add(BigDecimal.ONE));
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.ONE.add(fare).multiply(this.rate));
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setEquivalentAmount(new BigDecimal(40));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("YQ");
        tax.setEquivalentAmount(new BigDecimal(50));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("CZ");
        tax.setEquivalentAmount(new BigDecimal(60));
        product.getTaxes().add(tax);
        product.setBlankOwnerRef(this.suReference);
        product.setBlankOwnerNumber("555");
        AirlineReference suRef = new AirlineReference("SU");
        product.setCarrier((DictionaryReference)suRef);
        product.setCarrierNumber("555");
        product.setBlankType((DictionaryReference)new BlankTypeReference("555 24"));
        int segCount = 0;
        if (forwardDate != null) {
            st = new SegmentTariff();
            ++segCount;
            seg = new Segment();
            seg.setAirline((DictionaryReference)suRef);
            seg.setFlightNo(ffNumber);
            seg.setDepartureLocation((DictionaryReference)new GeoLocationReference(firstCity));
            seg.setArriveLocation((DictionaryReference)new GeoLocationReference(lastCity));
            seg.setArriveCityCode(lastCity);
            seg.setClassOfSvcCode("N");
            seg.setStartDate(this.df.parse(forwardDate));
            seg.setRecordNumber(segCount);
            seg.setFareBasis(this.owFareBasis);
            st.getSegments().add(seg);
            product.getSegmentTariffs().add(st);
        }
        if (backwardDate != null) {
            ++segCount;
            st = new SegmentTariff();
            seg = new Segment();
            seg.setAirline((DictionaryReference)suRef);
            seg.setFlightNo(bfNumber);
            seg.setDepartureLocation((DictionaryReference)new GeoLocationReference(lastCity));
            seg.setArriveLocation((DictionaryReference)new GeoLocationReference(firstCity));
            seg.setStartDate(this.df.parse(backwardDate));
            seg.setClassOfSvcCode("N");
            seg.setRecordNumber(segCount);
            seg.setFareBasis(this.owFareBasis);
            st.getSegments().add(seg);
            product.getSegmentTariffs().add(st);
        }
        product.setTicketType(TicketType.OWN);
        bf.setAgency(this.agencyRef);
        AirProductHelper.setSubagency((Product)product, (EntityReference)this.agencyRef);
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyRef);
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setAgencyCode(((Organization)EntityStorage.get().resolve(this.agencyRef).getEntity()).getCode());
        ProductFop fop = new ProductFop();
        Money fopMoney = new Money();
        fopMoney.setCurrency("RUB");
        fopMoney.setValue(AirProductHelper.getEquivalentFare((Product)product).add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product)));
        fop.setAmount(fopMoney);
        fop.setType(PaymentType.CASH);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        Commission comm = new Commission();
        comm.setCommissionProperties(this.commissionRef);
        comm.setAmount(SystemHelper.getMoney((double)1.0, (String)"USD"));
        comm.setContractType(ContractType.VENDOR);
        comm.setEquivalentAmount(this.rate);
        AirProductHelper.getVendorContractRelation((Product)product).getCommissions().add(comm);
        product.setChecked(true);
        EntityStorage.get().save(bfc, false);
        return new ProductSearchResult(bf, (BaseProduct)product, product.getReservation(), bfc, true);
    }

    private void createProfiles() throws Exception {
        SUBlockCharterAppendix app = new SUBlockCharterAppendix();
        app.setCurrency("USD");
        app.setItinerary("MOW-LON-MOW");
        app.setType(SUBlockCharterAppendixType.ONE_WAY);
        app.setNumber("OW1");
        app.setFareBasis(this.owFareBasis);
        app.setStartDate(this.df.parse("2010-02-02"));
        app.setEndDate(this.df.parse("2010-02-06"));
        SUBlockCharterTariffInfo tar = this.addTariff(app, this.rtEconomyTariff, this.owEconomyTariff, "N");
        this.addQuota(tar, false, "2010-02-02", this.forwardFlight, 2);
        this.addQuota(tar, true, "2010-02-06", this.backwardFlight, 2);
        this.createProfiles(Collections.singletonList(app));
    }
}

