/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.su;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterTariffInfo;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SuSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.su.SUBCReportTestBase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class FewTariffsBCTest
extends SUBCReportTestBase {
    private final BigDecimal rtEconomyTariff2 = BigDecimal.valueOf(270L);
    private final String backwardFlight2 = "556";
    private final String forwardFlight2 = "555";
    private final BigDecimal rtBusinessTariff2 = BigDecimal.valueOf(310L);
    private final BigDecimal owEconomyTariff2 = BigDecimal.valueOf(260L);
    private final BigDecimal owBusinessTariff2 = BigDecimal.valueOf(310L);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.rtEconomyTariff = BigDecimal.valueOf(250L);
        this.rtBusinessTariff = BigDecimal.valueOf(300L);
        this.owEconomyTariff = BigDecimal.valueOf(250L);
        this.owBusinessTariff = BigDecimal.valueOf(300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOwReportRender() throws Exception {
        this.createProfiles();
        this.createTicket("2010-02-01", "2010-02-02", this.forwardFlight, "2010-02-06", this.backwardFlight, "MOW", "LON", false, null, ProductStatus.SELL);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.df.parse("2010-02-01")));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.df.parse("2010-02-10")));
        repParam.setAgency(this.agencyRef);
        repParam.setBlankOwner(this.suReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuSalesReportPrepareHandler prepHandler = new SuSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        SUBCReportTestBase.TestSuBcProgramReportRenderer suBbRender = new SUBCReportTestBase.TestSuBcProgramReportRenderer();
        Map bcDataMap = (Map)parameters.get("KEY_BLOCK_CHARTER_DATA");
        Assert.assertEquals((long)1L, (long)bcDataMap.values().size());
        parameters.put("KEY_BLOCK_CHARTER_DATA", bcDataMap.values().iterator().next());
        EntityContainer regRepDoc = suBbRender.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        File fileName = this.buildOutputFileName("FewTariffsBCTest.xls");
        try (FileOutputStream fileOut = new FileOutputStream(fileName);){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("FewTariffsBCTestPattern.xls")), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    private void createProfiles() throws Exception {
        SUBlockCharterAppendix app = new SUBlockCharterAppendix();
        app.setCurrency("USD");
        app.setItinerary("MOW-LON-MOW");
        app.setType(SUBlockCharterAppendixType.ONE_WAY);
        app.setNumber("OW1");
        app.setFareBasis(this.owFareBasis);
        app.setStartDate(this.df.parse("2010-02-02"));
        app.setEndDate(this.df.parse("2010-02-06"));
        SUBlockCharterTariffInfo tar = this.addTariff(app, this.rtEconomyTariff, this.owEconomyTariff, "N");
        this.addQuota(tar, false, "2010-02-02", this.forwardFlight, 2);
        this.addQuota(tar, true, "2010-02-06", this.backwardFlight, 2);
        tar = this.addTariff(app, this.rtBusinessTariff, this.owBusinessTariff, "D");
        this.addQuota(tar, false, "2010-02-02", this.forwardFlight, 1);
        this.addQuota(tar, true, "2010-02-06", this.backwardFlight, 1);
        tar = this.addTariff(app, this.rtEconomyTariff2, this.owEconomyTariff2, "N");
        this.addQuota(tar, false, "2010-02-05", "555", 2);
        this.addQuota(tar, true, "2010-02-08", "556", 2);
        tar = this.addTariff(app, this.rtBusinessTariff2, this.owBusinessTariff2, "D");
        this.addQuota(tar, false, "2010-02-05", "555", 1);
        this.addQuota(tar, true, "2010-02-08", "556", 1);
        this.createProfiles(Collections.singletonList(app));
    }
}

