/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.su;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterQuota;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterQuotaReference;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterTariffInfo;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SuSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.su.SUBCReportTestBase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class SUBCManualBindingTest
extends SUBCReportTestBase {
    private final EntityReference<Contract> contractRef = new EntityReference("su-bc-contract", Contract.class, null);
    private final List<SUBlockCharterAppendix> appendices = new ArrayList<SUBlockCharterAppendix>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRtReportRender() throws Exception {
        this.createProfiles(true, false);
        this.createTicket("2010-01-01", "2010-01-01", "2010-01-05", "MOW", "PAR", false, null, ProductStatus.SELL);
        ProductSearchResult psr = this.createTicket("2010-01-01", "2010-01-02", "2010-01-05", "MOW", "PAR", false, null, ProductStatus.SELL);
        Product prod = (Product)psr.getProduct();
        SUBlockCharterQuotaReference forwardQuota = prod.getCharterQuotaBinding().getForwardQuota();
        forwardQuota.setAppendixUid(this.appendices.get(0).getUid());
        forwardQuota.setContract(this.contractRef);
        forwardQuota.setCustomerInfoUid(null);
        forwardQuota.setQuotaUid(((SUBlockCharterQuota)((SUBlockCharterTariffInfo)this.appendices.get(0).getTariffs().get(0)).getQuotas().get(0)).getUid());
        EntityStorage.get().save(psr.getContainer(), false);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.df.parse("2010-01-01")));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.df.parse("2010-01-10")));
        repParam.setAgency(this.agencyRef);
        repParam.setBlankOwner(this.suReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuSalesReportPrepareHandler prepHandler = new SuSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        Map bcDataMap = (Map)parameters.get("KEY_BLOCK_CHARTER_DATA");
        Assert.assertEquals((long)1L, (long)bcDataMap.values().size());
        parameters.put("KEY_BLOCK_CHARTER_DATA", bcDataMap.values().iterator().next());
        SUBCReportTestBase.TestSuBcProgramReportRenderer suBbRender = new SUBCReportTestBase.TestSuBcProgramReportRenderer();
        EntityContainer regRepDoc = suBbRender.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        File fileName = this.buildOutputFileName("su-bc-manual-binding-test-rt.xls");
        try (FileOutputStream fileOut = new FileOutputStream(fileName);){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("testdata/su-bc-manual-binding-test-rt-pattern.xls")), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOWReportRender() throws Exception {
        this.createProfiles(false, true);
        this.createTicket("2010-01-01", "2010-01-02", "2010-01-06", "MOW", "LON", false, null, ProductStatus.SELL);
        ProductSearchResult psr = this.createTicket("2010-01-01", "2010-01-01", "2010-01-05", "MOW", "LON", false, null, ProductStatus.SELL);
        Product prod = (Product)psr.getProduct();
        SUBlockCharterQuotaReference forwardQuota = prod.getCharterQuotaBinding().getForwardQuota();
        forwardQuota.setAppendixUid(this.appendices.get(0).getUid());
        forwardQuota.setContract(this.contractRef);
        forwardQuota.setCustomerInfoUid(null);
        forwardQuota.setQuotaUid(((SUBlockCharterQuota)((SUBlockCharterTariffInfo)this.appendices.get(0).getTariffs().get(0)).getQuotas().get(0)).getUid());
        SUBlockCharterQuotaReference backwardQuota = prod.getCharterQuotaBinding().getBackwardQuota();
        backwardQuota.setAppendixUid(this.appendices.get(0).getUid());
        backwardQuota.setContract(this.contractRef);
        backwardQuota.setCustomerInfoUid(null);
        backwardQuota.setQuotaUid(((SUBlockCharterQuota)((SUBlockCharterTariffInfo)this.appendices.get(0).getTariffs().get(0)).getQuotas().get(2)).getUid());
        EntityStorage.get().save(psr.getContainer(), false);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.df.parse("2010-01-01")));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.df.parse("2010-01-10")));
        repParam.setAgency(this.agencyRef);
        repParam.setBlankOwner(this.suReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuSalesReportPrepareHandler prepHandler = new SuSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        Map bcDataMap = (Map)parameters.get("KEY_BLOCK_CHARTER_DATA");
        Assert.assertEquals((long)1L, (long)bcDataMap.values().size());
        parameters.put("KEY_BLOCK_CHARTER_DATA", bcDataMap.values().iterator().next());
        SUBCReportTestBase.TestSuBcProgramReportRenderer suBbRender = new SUBCReportTestBase.TestSuBcProgramReportRenderer();
        EntityContainer regRepDoc = suBbRender.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        File fileName = this.buildOutputFileName("su-bc-manual-binding-test-ow.xls");
        try (FileOutputStream fileOut = new FileOutputStream(fileName);){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("testdata/su-bc-manual-binding-test-ow-pattern.xls")), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    private void createProfiles(boolean createRT, boolean createOW) throws Exception {
        SUBlockCharterTariffInfo tar;
        SUBlockCharterAppendix app;
        this.appendices.clear();
        if (createRT) {
            app = new SUBlockCharterAppendix();
            app.setCurrency("USD");
            app.setItinerary("MOW-PAR-MOW");
            app.setType(SUBlockCharterAppendixType.ROUND_TRIP);
            app.setNumber("RT");
            app.setFareBasis(this.rtFareBasis);
            tar = this.addTariff(app, this.rtEconomyTariff, null, "N");
            this.addQuota(tar, false, "2010-01-01", this.forwardFlight, 2);
            this.addQuota(tar, false, "2010-01-03", this.forwardFlight, 2);
            this.addQuota(tar, true, "2010-01-05", this.backwardFlight, 2);
            this.addQuota(tar, true, "2010-01-08", this.backwardFlight, 2);
            this.appendices.add(app);
        }
        if (createOW) {
            app = new SUBlockCharterAppendix();
            app.setCurrency("USD");
            app.setItinerary("MOW-LON-MOW");
            app.setType(SUBlockCharterAppendixType.ONE_WAY);
            app.setNumber("OW");
            app.setFareBasis(this.owFareBasis);
            tar = this.addTariff(app, this.rtEconomyTariff, this.owEconomyTariff, "N");
            this.addQuota(tar, false, "2010-01-02", this.forwardFlight, 2);
            this.addQuota(tar, false, "2010-01-03", this.forwardFlight, 2);
            this.addQuota(tar, true, "2010-01-06", this.backwardFlight, 2);
            this.addQuota(tar, true, "2010-01-09", this.backwardFlight, 2);
            this.appendices.add(app);
        }
        this.createProfiles(this.appendices);
    }
}

