/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.su;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LegalFormReference;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.PersonPositionReference;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterQuota;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterTariffInfo;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointType;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCOldDateRegistryRenderer;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCProgramRenderer;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCSellReportRenderer;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SuSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;

abstract class SUBCReportTestBase
extends RenderSalesReportTestBase {
    protected BigDecimal rate = BigDecimal.valueOf(30L);
    protected DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    protected EntityReference<CommissionProperties> commissionRef = null;
    protected EntityReference<Organization> agencyRef = null;
    protected EntityReference<SalesPoint> salesPointRef = null;
    protected String validatorNumber = "55534521";
    protected BigDecimal rtEconomyTariff = BigDecimal.valueOf(200L);
    protected BigDecimal rtBusinessTariff = BigDecimal.valueOf(300L);
    protected BigDecimal owEconomyTariff = BigDecimal.valueOf(150L);
    protected BigDecimal owBusinessTariff = BigDecimal.valueOf(250L);
    protected String forwardFlight = "333";
    protected String backwardFlight = "334";
    protected String rtFareBasis = "NGV6";
    protected String owFareBasis = "NGV6";
    protected int count;

    SUBCReportTestBase() {
    }

    protected void createProfiles(List<SUBlockCharterAppendix> appendices) throws Exception {
        CurrencyRate crate = new CurrencyRate();
        crate.setCode("USD1");
        crate.setDate(this.df.parse("2009-01-01"));
        crate.setRate(this.rate.doubleValue());
        crate.setCurrency("USD");
        crate.setBaseCurrency("RUB");
        crate.setType(CurrencyRateType.IATA);
        DictionaryStorage.get().save((BaseDictionary)crate);
        EntityContainer result = new EntityContainer(CommissionProperties.class);
        CommissionProperties prop = (CommissionProperties)result.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("comm"));
        prop.setDisplayName("commission USD");
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_1);
        EntityStorage.get().save(result, false);
        this.commissionRef = result.toReference();
        result = new EntityContainer(Organization.class, "ABC_AGENCY_CONTAINER");
        Organization agency = (Organization)result.getEntity();
        agency.setActive(true);
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"ABC", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)agency.getFullName(), (String)"ABC agency", (Locale)Locale.ENGLISH);
        agency.setCode("0001");
        agency.setLegalForm((DictionaryReference)new LegalFormReference("\u041e\u041e\u041e"));
        agency.setRegistrationId("895348092850");
        agency.getTypes().add(OrganizationType.AGENCY);
        SystemHelper.setMetadataValue((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_SU_AGENCY_CODE, (Object)"0001");
        Communication comm = new Communication();
        comm.setType(CommunicationType.WORK_PHONE);
        comm.setSense("+7(495)324211234");
        agency.getCommunications().add(comm);
        EntityStorage.get().save(result, false);
        this.agencyRef = result.toReference();
        PersonPositionReference directorPosition = new PersonPositionReference(ManagerType.DIRECTOR.name());
        PersonEmployment directorEmployment = new PersonEmployment();
        directorEmployment.setOrganization(this.agencyRef);
        directorEmployment.setPosition((DictionaryReference)directorPosition);
        directorEmployment.setAuthorized(true);
        directorEmployment.setMainEmployment(true);
        EntityContainer directorContainer = new EntityContainer(Person.class);
        Person director = (Person)directorContainer.getEntity();
        L10nStringHelper.setValue((L10nString)director.getLastName(), (String)"Mr. Director", (Locale)Locale.ENGLISH);
        director.getTypes().add(PersonType.MANAGER);
        director.getEmployments().add(directorEmployment);
        EntityStorage.get().save(directorContainer, false);
        PersonPositionReference chiefAccountantPosition = new PersonPositionReference(ManagerType.CHIEF_ACCOUNTANT.name());
        PersonEmployment chiefAccountantEmployment = new PersonEmployment();
        chiefAccountantEmployment.setOrganization(this.agencyRef);
        chiefAccountantEmployment.setPosition((DictionaryReference)chiefAccountantPosition);
        chiefAccountantEmployment.setAuthorized(true);
        chiefAccountantEmployment.setMainEmployment(true);
        EntityContainer chiefAccountantContainer = new EntityContainer(Person.class);
        Person chiefAccountant = (Person)chiefAccountantContainer.getEntity();
        L10nStringHelper.setValue((L10nString)chiefAccountant.getLastName(), (String)"Mr. Accountant", (Locale)Locale.ENGLISH);
        chiefAccountant.getTypes().add(PersonType.MANAGER);
        chiefAccountant.getEmployments().add(chiefAccountantEmployment);
        EntityStorage.get().save(chiefAccountantContainer, false);
        EntityContainer result2 = new EntityContainer(SalesPoint.class);
        SalesPoint salesPoint = (SalesPoint)result2.getEntity();
        salesPoint.setActive(true);
        salesPoint.setShortName("Sales Point ABC");
        salesPoint.setFullName("");
        salesPoint.setCode("0001");
        salesPoint.setType(SalesPointType.SALES_OFFICE);
        salesPoint.setAgency(this.agencyRef);
        Validator validator = new Validator();
        validator.setAgency(this.agencyRef);
        validator.setSupplier(this.suReference);
        validator.setBlankOwner(this.suReference);
        validator.setNumber(this.validatorNumber);
        salesPoint.getValidators().add(validator);
        EntityStorage.get().save(result2, false);
        this.salesPointRef = result2.toReference();
        if (!appendices.isEmpty()) {
            result2 = new EntityContainer(Contract.class, "su-bc-contract");
            Contract contract = (Contract)result2.getEntity();
            contract.setName("Contract");
            contract.setContractType(ContractType.VENDOR);
            contract.setSupplier(this.suReference);
            contract.setVendor(this.suReference);
            ContractCustomerInfo info = new ContractCustomerInfo();
            info.setCustomer(this.agencyRef);
            info.setNumber("SU BC Contract");
            info.getAppendices().addAll(appendices);
            contract.getCustomers().add(info);
            RuleSet rs = new RuleSet();
            rs.setModified(new Date());
            RuleSettings settings = new RuleSettings();
            settings.setName("standard rule");
            RuleResult rr = new RuleResult();
            rr.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
            RuleResultValue val = new RuleResultValue();
            val.setTarget(this.commissionRef);
            val.setCurrencyCode("USD");
            val.setValue(1.0);
            rr.setValue((Object)val);
            settings.getResults().add(rr);
            rs.getRules().add(settings);
            contract.setRuleSet(rs);
            EntityStorage.get().save(result2, false);
        }
    }

    protected void addQuota(SUBlockCharterTariffInfo tar, boolean backward, String date, String flightNumber, int aQuota) throws ParseException {
        SUBlockCharterQuota quota = new SUBlockCharterQuota();
        quota.setBackwardDirection(backward);
        quota.setFlightDate(this.df.parse(date));
        quota.setFlightNumber(flightNumber);
        quota.setQuota(aQuota);
        tar.getQuotas().add(quota);
    }

    protected SUBlockCharterTariffInfo addTariff(SUBlockCharterAppendix app, BigDecimal fareRt, BigDecimal fareOw, String classOfBooking) {
        SUBlockCharterTariffInfo tariff = new SUBlockCharterTariffInfo();
        tariff.setRtAdultTariff(fareRt);
        tariff.setOwAdultTariff(fareOw);
        tariff.setClassOfBooking(classOfBooking);
        app.getTariffs().add(tariff);
        return tariff;
    }

    protected ProductSearchResult createTicket(String issueDate, String forwardDate, String ffNumber, String backwardDate, String bfNumber, String firstCity, String lastCity, boolean business, ProductSearchResult previousProduct, ProductStatus status) throws Exception {
        String oldForwardFlight = this.forwardFlight;
        String oldBackwardFlight = this.backwardFlight;
        this.forwardFlight = ffNumber;
        this.backwardFlight = bfNumber;
        ProductSearchResult result = this.createTicket(issueDate, forwardDate, backwardDate, firstCity, lastCity, business, previousProduct, status);
        this.forwardFlight = oldForwardFlight;
        this.backwardFlight = oldBackwardFlight;
        return result;
    }

    protected ProductSearchResult createTicket(String issueDate, String forwardDate, String backwardDate, String firstCity, String lastCity, boolean business, ProductSearchResult previousProduct, ProductStatus status) throws Exception {
        Segment seg;
        SegmentTariff st;
        EntityContainer bfc = null;
        Product product = new Product();
        if (previousProduct != null) {
            bfc = previousProduct.getContainer();
            Product sell = (Product)previousProduct.getProduct();
            product.setTraveller(sell.getTraveller());
            product.setReservation(sell.getReservation());
            sell.getReservation().getProducts().add(product);
            product.setPreviousProduct(sell);
            sell.setNextProduct(product);
            product.setStatus(status);
            product.setSystemNumber(sell.getSystemNumber());
            product.getScns().addAll(sell.getScns());
            product.setBlankType(sell.getBlankType());
        } else {
            ++this.count;
            bfc = new EntityContainer(BookingFile.class);
            Reservation res = new Reservation();
            this.setRecordLocator(res, "PNR" + this.count);
            res.setBookingFile((BookingFile)bfc.getEntity());
            ((BookingFile)bfc.getEntity()).getReservations().add(res);
            product.setSystemNumber("000" + this.count);
            product.getScns().add(product.getSystemNumber());
            Traveller traveller = new Traveller();
            traveller.setName("Traveller name");
            product.setTraveller(traveller);
            product.setConjCount(0);
            product.setStatus(status);
            product.setReservation(res);
            res.getProducts().add(product);
        }
        BookingFile bf = (BookingFile)bfc.getEntity();
        product.setProductCategory(ProductCategory.AIR);
        product.setTariffType(TariffType.BLOCKCHARTER);
        product.setValidatorCode(this.validatorNumber);
        product.setIssueDate(this.df.parse(issueDate));
        product.setSalesPoint(this.salesPointRef);
        product.setCashier(this.directorRef);
        BigDecimal fare = null;
        fare = forwardDate == null || backwardDate == null ? (business ? this.owBusinessTariff : this.owEconomyTariff) : (business ? this.rtBusinessTariff : this.rtEconomyTariff);
        Money baseFare = new Money();
        baseFare.setCurrency("USD");
        baseFare.setValue(fare.add(BigDecimal.ONE));
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.ONE.add(fare).multiply(this.rate));
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setEquivalentAmount(new BigDecimal(40));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("YQ");
        tax.setEquivalentAmount(new BigDecimal(50));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("CZ");
        tax.setEquivalentAmount(new BigDecimal(60));
        product.getTaxes().add(tax);
        product.setBlankOwnerRef(this.suReference);
        product.setBlankOwnerNumber("555");
        AirlineReference suRef = new AirlineReference("SU");
        product.setCarrier((DictionaryReference)suRef);
        product.setCarrierNumber("555");
        product.setBlankType((DictionaryReference)new BlankTypeReference("555 24"));
        int segCount = 0;
        if (forwardDate != null) {
            st = new SegmentTariff();
            seg = new Segment();
            this.setSegmentSettings(seg, suRef, this.forwardFlight, firstCity, lastCity, forwardDate, backwardDate, ++segCount, business);
            st.getSegments().add(seg);
            product.getSegmentTariffs().add(st);
        }
        if (backwardDate != null) {
            st = new SegmentTariff();
            seg = new Segment();
            this.setSegmentSettings(seg, suRef, this.backwardFlight, lastCity, firstCity, backwardDate, forwardDate, ++segCount, business);
            st.getSegments().add(seg);
            product.getSegmentTariffs().add(st);
        }
        product.setTicketType(TicketType.OWN);
        bf.setAgency(this.agencyRef);
        AirProductHelper.setSubagency((Product)product, this.agencyRef);
        AirProductHelper.setAgency((Product)product, this.agencyRef);
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setAgencyCode(((Organization)EntityStorage.get().resolve(this.agencyRef).getEntity()).getCode());
        ProductFop fop = new ProductFop();
        Money fopMoney = new Money();
        fopMoney.setCurrency("RUB");
        fopMoney.setValue(AirProductHelper.getEquivalentFare((Product)product).add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product)));
        fop.setAmount(fopMoney);
        fop.setType(PaymentType.CASH);
        fop.setOperationDate(product.getIssueDate());
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        Commission comm = new Commission();
        comm.setCommissionProperties(this.commissionRef);
        comm.setAmount(SystemHelper.getMoney((double)1.0, (String)"USD"));
        comm.setContractType(ContractType.VENDOR);
        comm.setEquivalentAmount(this.rate);
        AirProductHelper.getVendorContractRelation((Product)product).getCommissions().add(comm);
        product.setChecked(true);
        EntityStorage.get().save(bfc, true);
        return new ProductSearchResult(bf, (BaseProduct)product, product.getReservation(), bfc, true);
    }

    protected void setSegmentSettings(Segment seg, AirlineReference airRef, String flightNo, String depLoc, String arrLoc, String startDate, String backDate, int segCount, boolean business) {
        seg.setAirline((DictionaryReference)airRef);
        seg.setFlightNo(flightNo);
        seg.setDepartureLocation((DictionaryReference)new GeoLocationReference(depLoc));
        seg.setArriveLocation((DictionaryReference)new GeoLocationReference(arrLoc));
        seg.setArriveCityCode(arrLoc);
        seg.setClassOfSvcCode(business ? "D" : "N");
        try {
            seg.setStartDate(this.df.parse(startDate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        seg.setRecordNumber(segCount);
        seg.setFareBasis(backDate != null ? this.rtFareBasis : this.owFareBasis);
    }

    protected void setMultyAgencyReport(boolean enable) throws Exception {
        DictionaryStorage ds = DictionaryStorage.get();
        Collection dicts = ds.loadAll(null, Preference.class);
        for (BaseDictionary dict : dicts) {
            if (!((Preference)dict).getKey().equals((Object)PreferenceKey.XML_REPORT_TICKET_ORDER_FOR_MULTYAGENCY_REPORT)) continue;
            if (enable) {
                ((Preference)dict).setValue("YES");
            } else {
                ((Preference)dict).setValue("NO");
            }
            ds.save(dict);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAndCompareBlockCharterReport(String startDate, String endDate, String outputFileName, String expectedFileName) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.df.parse(startDate)));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.df.parse(endDate)));
        repParam.setAgency(this.agencyRef);
        repParam.setBlankOwner(this.suReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuSalesReportPrepareHandler prepHandler = new SuSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        Map bcDataMap = (Map)parameters.get("KEY_BLOCK_CHARTER_DATA");
        Assert.assertEquals((long)1L, (long)bcDataMap.values().size());
        parameters.put("KEY_BLOCK_CHARTER_DATA", bcDataMap.values().iterator().next());
        TestSuBcProgramReportRenderer suBbRender = new TestSuBcProgramReportRenderer();
        EntityContainer regRepDoc = suBbRender.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        File fileName = this.buildOutputFileName(outputFileName);
        try (FileOutputStream fileOut = new FileOutputStream(fileName);){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource(expectedFileName)), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    static class TestSuBcProgramReportRenderer
    extends SUBCProgramRenderer {
        TestSuBcProgramReportRenderer() {
        }

        protected File getTemplateFile() {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            return result;
        }
    }

    static class TestSuBcSellReportRenderer
    extends SUBCSellReportRenderer {
        TestSuBcSellReportRenderer() {
        }

        protected File getTemplateFile() {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            return result;
        }
    }

    static class TestSuBcOldDateRegistryRenderer
    extends SUBCOldDateRegistryRenderer {
        TestSuBcOldDateRegistryRenderer() {
        }

        protected File getTemplateFile() {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            return result;
        }
    }
}

