/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.su;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterTariffInfo;
import com.gridnine.xtrip.common.model.profile.VendorContractType;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SuCharterRenderer;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SuSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.su.SUBCReportTestBase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class SUCharterTest
extends SUBCReportTestBase {
    private final String owBlockCharterFareBasis = "NGV6";
    private final String owCharterFareBasis = "NGV8";
    private final String forwardFlight2 = "335";
    private final String backwardFlight2 = "336";
    private final String forwardFlight3 = "337";
    private final String backwardFlight3 = "338";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.rtEconomyTariff = BigDecimal.valueOf(250L);
        this.rtBusinessTariff = BigDecimal.valueOf(300L);
        this.owEconomyTariff = BigDecimal.valueOf(150L);
        this.owBusinessTariff = BigDecimal.valueOf(200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOwReportRender() throws Exception {
        HSSFWorkbook wb;
        POIFSFileSystem fs;
        ByteArrayInputStream is;
        this.createProfiles();
        this.createTicket("2010-02-01", "2010-02-02", this.forwardFlight, null, null, "MOW", "LON", true, "NGV6", null, ProductStatus.SELL);
        this.createTicket("2010-02-01", null, null, "2010-02-06", this.backwardFlight, "MOW", "LON", true, "NGV6", null, ProductStatus.SELL);
        this.createTicket("2010-02-01", "2010-02-02", this.forwardFlight, "2010-02-06", this.backwardFlight, "MOW", "LON", false, "NGV6", null, ProductStatus.SELL);
        this.createTicket("2010-02-01", "2010-02-05", "335", null, null, "MOW", "PAR", true, "NGV8", null, ProductStatus.SELL);
        this.createTicket("2010-02-01", null, null, "2010-02-08", "336", "MOW", "PAR", true, "NGV8", null, ProductStatus.SELL);
        this.createTicket("2010-02-01", "2010-02-05", "335", "2010-02-08", "336", "MOW", "PAR", false, "NGV8", null, ProductStatus.SELL);
        this.createTicket("2010-02-03", "2010-02-11", "337", "2010-02-13", "338", "MOW", "LON", false, "NGV8", null, ProductStatus.SELL);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.df.parse("2010-02-01")));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.df.parse("2010-02-10")));
        repParam.setAgency(this.agencyRef);
        repParam.setBlankOwner(this.suReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuSalesReportPrepareHandler prepHandler = new SuSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        Object suBbRender = new SUBCReportTestBase.TestSuBcProgramReportRenderer();
        Map bcDataMap = (Map)parameters.get("KEY_BLOCK_CHARTER_DATA");
        Assert.assertEquals((long)1L, (long)bcDataMap.values().size());
        parameters.put("KEY_BLOCK_CHARTER_DATA", bcDataMap.values().iterator().next());
        EntityContainer regRepDoc = suBbRender.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        File fileName = this.buildOutputFileName("suchartertest-bc.xls");
        try (FileOutputStream fileOut = new FileOutputStream(fileName);){
            is = new ByteArrayInputStream(repFile.getContent());
            fs = new POIFSFileSystem((InputStream)is);
            wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("suchartertest-bc-pattern.xls")), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
        suBbRender = new TestSuCharterRender();
        bcDataMap = (Map)parameters.get("KEY_CHARTER_DATA");
        Assert.assertEquals((long)1L, (long)bcDataMap.values().size());
        parameters.put("KEY_CHARTER_DATA", bcDataMap.values().iterator().next());
        regRepDoc = suBbRender.renderReport(parameters);
        repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        fileName = this.buildOutputFileName("suchartertest-charter.xls");
        fileOut = new FileOutputStream(fileName);
        try {
            is = new ByteArrayInputStream(repFile.getContent());
            fs = new POIFSFileSystem((InputStream)is);
            wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        finally {
            fileOut.close();
        }
        res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("suchartertest-charter-pattern.xls")), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    private ProductSearchResult createTicket(String issueDate, String forwardDate, String ffNumber, String backwardDate, String bfNumber, String firstCity, String lastCity, boolean business, String farebasis, ProductSearchResult previousProduct, ProductStatus status) throws Exception {
        String oldOwFareBasis = this.owFareBasis;
        String oldRTFareBasis = this.rtFareBasis;
        this.owFareBasis = farebasis;
        this.rtFareBasis = farebasis;
        ProductSearchResult result = this.createTicket(issueDate, forwardDate, ffNumber, backwardDate, bfNumber, firstCity, lastCity, business, previousProduct, status);
        this.owFareBasis = oldOwFareBasis;
        this.rtFareBasis = oldRTFareBasis;
        return result;
    }

    private void createProfiles() throws Exception {
        this.createProfiles(new ArrayList<SUBlockCharterAppendix>());
        EntityContainer result = new EntityContainer(Contract.class);
        Contract contract = (Contract)result.getEntity();
        contract.setName("Contract");
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(this.suReference);
        contract.setVendor(this.suReference);
        ContractCustomerInfo info = new ContractCustomerInfo();
        info.setCustomer(this.agencyRef);
        info.setNumber("SU BC Contract");
        SUBlockCharterAppendix app = new SUBlockCharterAppendix();
        app.setCurrency("USD");
        app.setItinerary("MOW-LON-MOW");
        app.setType(SUBlockCharterAppendixType.ONE_WAY);
        app.setNumber("OW1");
        app.setFareBasis("NGV6");
        app.setStartDate(this.df.parse("2010-02-02"));
        app.setEndDate(this.df.parse("2010-02-06"));
        SUBlockCharterTariffInfo tar = this.addTariff(app, this.rtEconomyTariff, this.owEconomyTariff, "N");
        this.addQuota(tar, false, "2010-02-02", this.forwardFlight, 2);
        this.addQuota(tar, true, "2010-02-06", this.backwardFlight, 2);
        tar = this.addTariff(app, this.rtBusinessTariff, this.owBusinessTariff, "D");
        this.addQuota(tar, false, "2010-02-02", this.forwardFlight, 1);
        this.addQuota(tar, true, "2010-02-06", this.backwardFlight, 1);
        info.getAppendices().add(app);
        contract.getCustomers().add(info);
        info = new ContractCustomerInfo();
        info.setCustomer(this.agencyRef);
        info.setNumber("SU Charter Contract");
        info.setVendorContractType(VendorContractType.CHARTER);
        app = new SUBlockCharterAppendix();
        app.setCurrency("USD");
        app.setItinerary("MOW-PAR-MOW");
        app.setType(SUBlockCharterAppendixType.ONE_WAY);
        app.setNumber("OW2");
        app.setFareBasis("NGV8");
        app.setStartDate(this.df.parse("2010-02-01"));
        app.setEndDate(this.df.parse("2010-02-10"));
        tar = this.addTariff(app, this.rtEconomyTariff, this.owEconomyTariff, "N");
        this.addQuota(tar, false, "2010-02-05", "335", 2);
        this.addQuota(tar, true, "2010-02-08", "336", 2);
        tar = this.addTariff(app, this.rtBusinessTariff, this.owBusinessTariff, "D");
        this.addQuota(tar, false, "2010-02-05", "335", 2);
        this.addQuota(tar, true, "2010-02-08", "336", 2);
        info.getAppendices().add(app);
        app = new SUBlockCharterAppendix();
        app.setCurrency("USD");
        app.setItinerary("MOW-LON");
        app.setType(SUBlockCharterAppendixType.ONE_WAY);
        app.setNumber("OW3");
        app.setFareBasis("NGV8");
        app.setStartDate(this.df.parse("2010-02-01"));
        app.setEndDate(this.df.parse("2010-02-10"));
        tar = this.addTariff(app, BigDecimal.ZERO, BigDecimal.ZERO, "N");
        this.addQuota(tar, false, "2010-02-11", "337", 2);
        this.addQuota(tar, true, "2010-02-13", "338", 2);
        info.getAppendices().add(app);
        contract.getCustomers().add(info);
        RuleSet rs = new RuleSet();
        rs.setModified(new Date());
        RuleSettings settings = new RuleSettings();
        settings.setName("standard rule");
        RuleResult rr = new RuleResult();
        rr.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        RuleResultValue val = new RuleResultValue();
        val.setTarget(this.commissionRef);
        val.setCurrencyCode("USD");
        val.setValue(1.0);
        rr.setValue((Object)val);
        settings.getResults().add(rr);
        rs.getRules().add(settings);
        contract.setRuleSet(rs);
        EntityStorage.get().save(result, false);
    }

    class TestSuCharterRender
    extends SuCharterRenderer {
        TestSuCharterRender() {
        }

        protected File getTemplateFile() {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            return result;
        }
    }
}

