/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.su;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LegalFormReference;
import com.gridnine.xtrip.common.model.dict.LuggageUnits;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.PersonPositionReference;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointType;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.su.SuPaymentCardSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.registry.SuRegistryRender;
import com.gridnine.xtrip.common.reports.render.salesreports.su.xml.SuXmlReportRender;
import com.gridnine.xtrip.common.reports.render.salesreports.su.xml.SuXmlValidator;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SuPaymentCardSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SuSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;
import org.w3c.dom.Document;

abstract class SURegularReportTestBase
extends RenderSalesReportTestBase {
    protected BigDecimal rate = BigDecimal.valueOf(30L);
    protected DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    protected EntityReference<CommissionProperties> commissionRef = null;
    protected EntityReference<SalesPoint> salesPointRef = null;
    protected String validatorNumber = "55534521";
    protected BigDecimal fare = BigDecimal.valueOf(200L);
    protected String flightNo = "333";
    protected String fareBasis = "YUF5";
    protected int count;

    SURegularReportTestBase() {
    }

    protected void createProfiles() throws Exception {
        CurrencyRate crate = new CurrencyRate();
        crate.setCode("USD1");
        crate.setDate(this.df.parse("2009-01-01"));
        crate.setRate(this.rate.doubleValue());
        crate.setCurrency("USD");
        crate.setBaseCurrency("RUB");
        crate.setType(CurrencyRateType.IATA);
        DictionaryStorage.get().save((BaseDictionary)crate);
        EntityContainer result = new EntityContainer(CommissionProperties.class);
        CommissionProperties prop = (CommissionProperties)result.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("comm"));
        prop.setDisplayName("commission USD");
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_1);
        EntityStorage.get().save(result, false);
        this.commissionRef = result.toReference();
        result = new EntityContainer(Organization.class, "ABC_AGENCY_CONTAINER");
        Organization agency = (Organization)result.getEntity();
        agency.setActive(true);
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"ABC", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)agency.getFullName(), (String)"ABC agency", (Locale)Locale.ENGLISH);
        agency.setCode("0001");
        agency.setLegalForm((DictionaryReference)new LegalFormReference("\u041e\u041e\u041e"));
        agency.setRegistrationId("895348092850");
        agency.getTypes().add(OrganizationType.AGENCY);
        SystemHelper.setMetadataValue((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_SU_AGENCY_CODE, (Object)"0001");
        Communication comm = new Communication();
        comm.setType(CommunicationType.WORK_PHONE);
        comm.setSense("+7(495)324211234");
        agency.getCommunications().add(comm);
        EntityStorage.get().save(result, false);
        this.agencyReference = result.toReference();
        PersonPositionReference directorPosition = new PersonPositionReference(ManagerType.DIRECTOR.name());
        PersonEmployment directorEmployment = new PersonEmployment();
        directorEmployment.setOrganization(this.agencyReference);
        directorEmployment.setPosition((DictionaryReference)directorPosition);
        directorEmployment.setAuthorized(true);
        directorEmployment.setMainEmployment(true);
        EntityContainer directorContainer = new EntityContainer(Person.class);
        Person director = (Person)directorContainer.getEntity();
        L10nStringHelper.setValue((L10nString)director.getLastName(), (String)"Mr. Director", (Locale)Locale.ENGLISH);
        director.getTypes().add(PersonType.MANAGER);
        director.getEmployments().add(directorEmployment);
        EntityStorage.get().save(directorContainer, false);
        PersonPositionReference chiefAccountantPosition = new PersonPositionReference(ManagerType.CHIEF_ACCOUNTANT.name());
        PersonEmployment chiefAccountantEmployment = new PersonEmployment();
        chiefAccountantEmployment.setOrganization(this.agencyReference);
        chiefAccountantEmployment.setPosition((DictionaryReference)chiefAccountantPosition);
        chiefAccountantEmployment.setAuthorized(true);
        chiefAccountantEmployment.setMainEmployment(true);
        EntityContainer chiefAccountantContainer = new EntityContainer(Person.class);
        Person chiefAccountant = (Person)chiefAccountantContainer.getEntity();
        L10nStringHelper.setValue((L10nString)chiefAccountant.getLastName(), (String)"Mr. Accountant", (Locale)Locale.ENGLISH);
        chiefAccountant.getTypes().add(PersonType.MANAGER);
        chiefAccountant.getEmployments().add(chiefAccountantEmployment);
        EntityStorage.get().save(chiefAccountantContainer, false);
        EntityContainer result2 = new EntityContainer(SalesPoint.class);
        SalesPoint salesPoint = (SalesPoint)result2.getEntity();
        salesPoint.setActive(true);
        salesPoint.setShortName("Sales Point ABC");
        salesPoint.setFullName("");
        salesPoint.setCode("0001");
        salesPoint.setType(SalesPointType.SALES_OFFICE);
        salesPoint.setAgency(this.agencyReference);
        Validator validator = new Validator();
        validator.setAgency(this.agencyReference);
        validator.setSupplier(this.suReference);
        validator.setBlankOwner(this.suReference);
        validator.setNumber(this.validatorNumber);
        salesPoint.getValidators().add(validator);
        EntityStorage.get().save(result2, false);
        this.salesPointRef = result2.toReference();
        result2 = new EntityContainer(Contract.class);
        Contract contract = (Contract)result2.getEntity();
        contract.setName("Contract");
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(this.suReference);
        contract.setVendor(this.suReference);
        ContractCustomerInfo info = new ContractCustomerInfo();
        info.setCustomer(this.agencyReference);
        info.setNumber("SU BC Contract");
        contract.getCustomers().add(info);
        RuleSet rs = new RuleSet();
        rs.setModified(new Date());
        RuleSettings settings = new RuleSettings();
        settings.setName("standard rule");
        RuleResult rr = new RuleResult();
        rr.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        RuleResultValue val = new RuleResultValue();
        val.setTarget(this.commissionRef);
        val.setCurrencyCode("USD");
        val.setValue(1.0);
        rr.setValue((Object)val);
        settings.getResults().add(rr);
        rs.getRules().add(settings);
        contract.setRuleSet(rs);
        EntityStorage.get().save(result2, false);
    }

    protected ProductSearchResult createTicket(String issueDate, String flightDate, String firstCity, String lastCity, ProductSearchResult previousProduct, ProductStatus status, PaymentType paymentType) throws Exception {
        EntityContainer bfc = null;
        Product product = new Product();
        if (previousProduct != null) {
            bfc = previousProduct.getContainer();
            Product sell = (Product)previousProduct.getProduct();
            product.setTraveller(sell.getTraveller());
            product.setReservation(sell.getReservation());
            sell.getReservation().getProducts().add(product);
            product.setPreviousProduct(sell);
            sell.setNextProduct(product);
            product.setStatus(status);
            product.setSystemNumber(sell.getSystemNumber());
            product.getScns().addAll(sell.getScns());
            product.setBlankType(sell.getBlankType());
        } else {
            ++this.count;
            bfc = new EntityContainer(BookingFile.class);
            Reservation res = new Reservation();
            this.setRecordLocator(res, "PNR" + this.count);
            res.setBookingFile((BookingFile)bfc.getEntity());
            ((BookingFile)bfc.getEntity()).getReservations().add(res);
            product.setSystemNumber("000" + this.count);
            product.setConjCount(0);
            product.setStatus(status);
            product.setReservation(res);
            Traveller traveller = new Traveller();
            traveller.setName("PUTIN MR.");
            product.setTraveller(traveller);
            ((BookingFile)bfc.getEntity()).getTravellers().add(traveller);
            res.getProducts().add(product);
        }
        BookingFile bf = (BookingFile)bfc.getEntity();
        product.setProductCategory(ProductCategory.AIR);
        product.setTariffType(TariffType.REGULAR);
        product.setValidatorCode(this.validatorNumber);
        product.setIssueDate(this.df.parse(issueDate));
        product.setSalesPoint(this.salesPointRef);
        product.setCashier(this.directorRef);
        Money baseFare = new Money();
        baseFare.setCurrency("USD");
        baseFare.setValue(this.fare.add(BigDecimal.ONE));
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.ONE.add(this.fare).multiply(this.rate));
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setEquivalentAmount(new BigDecimal(40));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("YQ");
        tax.setEquivalentAmount(new BigDecimal(50));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("CZ");
        tax.setEquivalentAmount(new BigDecimal(60));
        product.getTaxes().add(tax);
        product.setBlankOwnerRef(this.suReference);
        product.setBlankOwnerNumber("555");
        AirlineReference suRef = new AirlineReference("SU");
        product.setCarrier((DictionaryReference)suRef);
        product.setCarrierNumber("555");
        product.setBlankType((DictionaryReference)new BlankTypeReference("555 24"));
        SegmentTariff st = new SegmentTariff();
        Segment seg = new Segment();
        seg.setAirline((DictionaryReference)suRef);
        seg.setFlightNo(this.flightNo);
        seg.setDepartureLocation((DictionaryReference)new GeoLocationReference(firstCity));
        seg.setArriveLocation((DictionaryReference)new GeoLocationReference(lastCity));
        seg.setClassOfSvcCode("N");
        seg.setStartDate(this.df.parse(flightDate));
        seg.setFareBasis(this.fareBasis);
        seg.setRecordNumber(1);
        st.getSegments().add(seg);
        product.getSegmentTariffs().add(st);
        product.setTicketType(TicketType.OWN);
        bf.setAgency(this.agencyReference);
        AirProductHelper.setSubagency((Product)product, (EntityReference)this.agencyReference);
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyReference);
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setAgencyCode(((Organization)EntityStorage.get().resolve(this.agencyReference).getEntity()).getCode());
        ProductFop fop = new ProductFop();
        Money fopMoney = new Money();
        fopMoney.setCurrency("RUB");
        fopMoney.setValue(AirProductHelper.getEquivalentFare((Product)product).add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product)));
        fop.setAmount(fopMoney);
        fop.setType(paymentType);
        if (paymentType == PaymentType.CREDIT_CARD) {
            Card card = new Card();
            card.setExpiration(this.df.parse("2030-01-01"));
            card.setNameOnCard("IVANOV");
            card.setNumber("00000" + this.count);
            card.setSecurityCode("0" + this.count);
            card.setVendor(CardVendor.VISA);
            fop.setCard(card);
        }
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        Commission comm = new Commission();
        comm.setCommissionProperties(this.commissionRef);
        comm.setAmount(SystemHelper.getMoney((double)1.0, (String)"USD"));
        comm.setContractType(ContractType.VENDOR);
        comm.setEquivalentAmount(this.rate);
        AirProductHelper.getVendorContractRelation((Product)product).getCommissions().add(comm);
        product.setChecked(true);
        EntityStorage.get().save(bfc, true);
        return new ProductSearchResult(bf, (BaseProduct)product, product.getReservation(), bfc, true);
    }

    protected void createExceesBagage(String ticketNo, String scn, ProductStatus productStatus) throws Exception {
        EntityContainer bfc = null;
        Product product = new Product();
        ++this.count;
        bfc = new EntityContainer(BookingFile.class);
        Reservation res = new Reservation();
        this.setRecordLocator(res, "PNR" + this.count);
        res.setBookingFile((BookingFile)bfc.getEntity());
        ((BookingFile)bfc.getEntity()).getReservations().add(res);
        product.setSystemNumber("000" + this.count);
        product.getScns().add(product.getSystemNumber());
        product.setConjCount(0);
        product.setStatus(productStatus);
        product.setReservation(res);
        res.getProducts().add(product);
        Traveller traveller = new Traveller();
        traveller.setName("PUTIN MR.");
        product.setTraveller(traveller);
        ((BookingFile)bfc.getEntity()).getTravellers().add(traveller);
        product.setReservation(res);
        product.setSystemNumber(ticketNo);
        product.getScns().add(scn);
        product.setConjCount(0);
        product.setStatus(productStatus);
        product.setProductCategory(ProductCategory.EXCESS_BAGAGE);
        product.setLuggageWeight(Double.valueOf(10.0));
        product.setLuggageUnits(LuggageUnits.PIECE);
        product.setIssueDate(new Date());
        product.setTariffType(TariffType.REGULAR);
        product.setValidatorCode(this.validatorNumber);
        Money baseFare = new Money();
        baseFare.setCurrency("EUR");
        baseFare.setValue(this.fare);
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)this.fare);
        product.setBlankOwnerRef(this.suReference);
        product.setBlankOwnerNumber("555");
        Iterator iterator = BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef()).iterator();
        if (iterator.hasNext()) {
            BlankType bt = (BlankType)iterator.next();
            product.setBlankType((DictionaryReference)new BlankTypeReference(bt));
        }
        product.setTicketType(TicketType.OWN);
        ((BookingFile)bfc.getEntity()).setAgency(this.agencyReference);
        AirProductHelper.setSubagency((Product)product, (EntityReference)this.agencyReference);
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyReference);
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setAgencyCode(((Organization)EntityStorage.get().resolve(this.agencyReference).getEntity()).getCode());
        ProductFop fop = new ProductFop();
        Money fopMoney = new Money();
        fopMoney.setCurrency("RUB");
        fopMoney.setValue(this.fare);
        fop.setAmount(fopMoney);
        fop.setType(PaymentType.CASH);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setChecked(true);
        List blankTypes = BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef());
        for (BlankType type : blankTypes) {
            if (type.getBlankCategory() != BlankCategory.PRINTED_NUMBER) continue;
            product.setBlankType((DictionaryReference)type.toReference());
            product.setProductCategory(type.getProductCategory());
            break;
        }
        EntityStorage.get().save(bfc, true);
    }

    protected void setMultyAgencyReport(boolean enable) throws Exception {
        DictionaryStorage ds = DictionaryStorage.get();
        Collection dicts = ds.loadAll(null, Preference.class);
        for (BaseDictionary dict : dicts) {
            if (!((Preference)dict).getKey().equals((Object)PreferenceKey.XML_REPORT_TICKET_ORDER_FOR_MULTYAGENCY_REPORT)) continue;
            if (enable) {
                ((Preference)dict).setValue("YES");
            } else {
                ((Preference)dict).setValue("NO");
            }
            ds.save(dict);
            break;
        }
    }

    protected Map<String, Object> prepareStandardReportReport(String startDate, String endDate) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.df.parse(startDate)));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.df.parse(endDate)));
        repParam.setAgency(this.agencyReference);
        repParam.setBlankOwner(this.suReference);
        repParam.setAgency(this.agencyReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuSalesReportPrepareHandler prepHandler = new SuSalesReportPrepareHandler();
        prepHandler.prepareData(parameters);
        return parameters;
    }

    protected Map<String, Object> prepareCCCardReport(String startDate, String endDate) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.df.parse(startDate)));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.df.parse(endDate)));
        repParam.setAgency(this.agencyReference);
        repParam.setBlankOwner(this.suReference);
        repParam.setAgency(this.agencyReference);
        repParam.setSupplier(this.suReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuPaymentCardSalesReportPrepareHandler prepHandler = new SuPaymentCardSalesReportPrepareHandler();
        prepHandler.prepareData(parameters);
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File renderStandardReportAsXML(Map<String, Object> data, String fileName) throws Exception {
        SuXmlReportRender handler = new SuXmlReportRender();
        ReportFile repFile = (ReportFile)((ReportDocument)handler.renderReport(data).getEntity()).getFiles().get(0);
        byte[] content = repFile.getContent();
        this.setMultyAgencyReport(false);
        this.log.debug(new String(content));
        File outputFile = this.buildOutputFileName(fileName);
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            fos.write(content);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        String validationString = SuXmlValidator.validate((Document)factory.newDocumentBuilder().parse(new ByteArrayInputStream(content)));
        Assert.assertNull((String)validationString, (Object)validationString);
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File renderStandardReportAsExcel(Map<String, Object> data, String fileName) throws Exception {
        TestSuRegistryRender suRepHandler = new TestSuRegistryRender();
        EntityContainer regRepDoc = suRepHandler.renderReport(data);
        File outputFile = this.buildOutputFileName(fileName);
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            ByteArrayInputStream is = new ByteArrayInputStream(((ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0)).getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fos);
        }
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File renderCCReport(Map<String, Object> data, String fileName) throws Exception {
        TestSuCCRenderHandler suRepHandler = new TestSuCCRenderHandler();
        EntityContainer regRepDoc = suRepHandler.renderReport(data);
        File outputFile = this.buildOutputFileName(fileName);
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            ByteArrayInputStream is = new ByteArrayInputStream(((ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0)).getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fos);
        }
        return outputFile;
    }

    protected void checkErrors(Map<String, Object> data) throws Exception {
        List messages = (List)data.get("key-messages");
        for (Message message : messages) {
            if (message.getType() != MessageType.ERROR) continue;
            throw new Exception(String.format("ERROR: %s%s", LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage()), TextUtil.isBlank((String)message.getDetails()) ? "" : "\r\n" + message.getDetails()));
        }
    }

    static class TestSuCCReportRender
    extends SuRegistryRender<SuTicket> {
        TestSuCCReportRender() {
        }

        protected File getTemplateFile() {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            return result;
        }
    }

    static class TestSuCCRenderHandler
    extends SuPaymentCardSalesReportRenderHandler {
        TestSuCCRenderHandler() {
        }

        protected InputStream getInputStream(Map<String, Object> data) throws Exception {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/SuPaymentCardSalesReport.xls");
            if (!result.exists() || !result.canRead()) {
                throw new IOException(String.format("\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d \u043e\u0442\u0447\u0435\u0442\u0430 %s", result.getCanonicalPath()));
            }
            return new FileInputStream(result);
        }
    }

    static class TestSuRegistryRender
    extends SuRegistryRender<SuTicket> {
        TestSuRegistryRender() {
        }

        protected File getTemplateFile() {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            return result;
        }
    }
}

