/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.su;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterTariffInfo;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SuSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.su.SUBCReportTestBase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class SuBcRegionsRenderTest
extends SUBCReportTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRtReportRender() throws Exception {
        this.createProfiles(true, false);
        this.createTicket("2009-12-31", "2010-01-01", "2010-01-05", "MOW", "PAR", false, null, ProductStatus.SELL, null, null);
        this.createTicket("2010-01-01", "2010-01-01", "2010-01-05", "MOW", "PAR", true, null, ProductStatus.SELL, null, null);
        this.createTicket("2009-12-31", "2010-01-01", "2010-01-05", "MOW", "PAR", false, null, ProductStatus.SELL, "31", "32");
        this.createTicket("2010-01-01", "2010-01-01", "2010-01-05", "MOW", "PAR", true, null, ProductStatus.SELL, "31", "32");
        this.createTicket("2010-01-01", "2010-01-03", "2010-01-07", "MOW", "PAR", true, null, ProductStatus.SELL, null, null);
        this.createTicket("2010-01-01", "2010-01-03", "2010-01-07", "MOW", "PAR", true, null, ProductStatus.SELL, "31", "32");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.df.parse("2010-01-01")));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.df.parse("2010-01-10")));
        repParam.setAgency(this.agencyRef);
        repParam.setBlankOwner(this.suReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuSalesReportPrepareHandler prepHandler = new SuSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        Map bcDataMap = (Map)parameters.get("KEY_BLOCK_CHARTER_DATA");
        Assert.assertEquals((long)1L, (long)bcDataMap.values().size());
        parameters.put("KEY_BLOCK_CHARTER_DATA", bcDataMap.values().iterator().next());
        SUBCReportTestBase.TestSuBcProgramReportRenderer suBbRender = new SUBCReportTestBase.TestSuBcProgramReportRenderer();
        EntityContainer regRepDoc = suBbRender.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        File fileName = this.buildOutputFileName("region-rt.xls");
        try (FileOutputStream fileOut = new FileOutputStream(fileName);){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("region-rt-pattern.xls")), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOwReportRender() throws Exception {
        this.createProfiles(false, true);
        this.createTicket("2009-12-31", "2010-01-02", "2010-01-06", "MOW", "LON", false, null, ProductStatus.SELL, null, null);
        this.createTicket("2010-01-01", "2010-01-02", "2010-01-06", "MOW", "LON", true, null, ProductStatus.SELL, null, null);
        this.createTicket("2009-12-31", "2010-01-02", "2010-01-06", "MOW", "LON", false, null, ProductStatus.SELL, "31", "32");
        this.createTicket("2010-01-01", "2010-01-02", "2010-01-06", "MOW", "LON", true, null, ProductStatus.SELL, "31", "32");
        this.createTicket("2010-01-01", "2010-01-03", "2010-01-09", "MOW", "LON", true, null, ProductStatus.SELL, null, null);
        this.createTicket("2010-01-01", "2010-01-03", "2010-01-09", "MOW", "LON", true, null, ProductStatus.SELL, "31", "32");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.df.parse("2010-01-01")));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.df.parse("2010-01-10")));
        repParam.setAgency(this.agencyRef);
        repParam.setBlankOwner(this.suReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuSalesReportPrepareHandler prepHandler = new SuSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        Map bcDataMap = (Map)parameters.get("KEY_BLOCK_CHARTER_DATA");
        Assert.assertEquals((long)1L, (long)bcDataMap.values().size());
        parameters.put("KEY_BLOCK_CHARTER_DATA", bcDataMap.values().iterator().next());
        SUBCReportTestBase.TestSuBcProgramReportRenderer suBbRender = new SUBCReportTestBase.TestSuBcProgramReportRenderer();
        EntityContainer regRepDoc = suBbRender.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        File fileName = this.buildOutputFileName("region-ow.xls");
        try (FileOutputStream fileOut = new FileOutputStream(fileName);){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("region-ow-pattern.xls")), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    private ProductSearchResult createTicket(String issueDate, String forwardDate, String backwardDate, String firstCity, String lastCity, boolean business, ProductSearchResult previousProduct, ProductStatus status, String regionForwardFlight, String regionBackwardFlight) throws Exception {
        ProductSearchResult result = this.createTicket(issueDate, forwardDate, this.forwardFlight, backwardDate, this.backwardFlight, firstCity, lastCity, business, previousProduct, status);
        if (regionForwardFlight == null && regionBackwardFlight == null) {
            return result;
        }
        Product prod = (Product)result.getProduct();
        if (regionForwardFlight != null) {
            this.addSegment(prod, new Date(this.df.parse(forwardDate).getTime() - 86400000L), "KJA", firstCity, regionForwardFlight, business, false);
        }
        if (regionBackwardFlight != null) {
            this.addSegment(prod, new Date(this.df.parse(backwardDate).getTime() + 86400000L), lastCity, "KJA", regionBackwardFlight, business, true);
        }
        EntityStorage.get().save(result.getContainer(), false);
        return result;
    }

    private void addSegment(Product prod, Date date, String firstCity, String lastCity, String flightNo, boolean business, boolean lastSegment) {
        AirProductHelper.setEquivalentFare((Product)prod, (BigDecimal)AirProductHelper.getEquivalentFare((Product)prod).add(BigDecimal.valueOf(3000L)));
        Money baseFare = AirProductHelper.getBaseFare((Product)prod);
        baseFare.setValue(baseFare.getValue().add(BigDecimal.valueOf(100L)));
        AirProductHelper.setBaseFare((Product)prod, (Money)baseFare);
        Segment seg = new Segment();
        SegmentTariff st = new SegmentTariff();
        st.getSegments().add(seg);
        int index = lastSegment ? prod.getSegmentTariffs().size() - 1 : 0;
        seg.setRecordNumber(index + 1);
        prod.getSegmentTariffs().add(index, st);
        seg.setStartDate(date);
        seg.setDepartureLocation((DictionaryReference)new GeoLocationReference(firstCity));
        seg.setArriveLocation((DictionaryReference)new GeoLocationReference(lastCity));
        seg.setFlightNo(flightNo);
        seg.setClassOfSvcCode(business ? "Q" : "W");
        seg.setFareBasis(business ? "QGV6" : "WGV6");
        seg.setAirline((DictionaryReference)new AirlineReference("SU"));
    }

    private void createProfiles(boolean createRT, boolean createOW) throws Exception {
        SUBlockCharterTariffInfo tar;
        SUBlockCharterAppendix app;
        ArrayList<SUBlockCharterAppendix> appendices = new ArrayList<SUBlockCharterAppendix>();
        if (createRT) {
            app = new SUBlockCharterAppendix();
            app.setCurrency("USD");
            app.setItinerary("MOW-PAR-MOW");
            app.setType(SUBlockCharterAppendixType.ROUND_TRIP);
            app.setNumber("RT");
            app.setFareBasis(this.rtFareBasis);
            tar = this.addTariff(app, this.rtEconomyTariff, null, "N");
            this.addQuota(tar, false, "2010-01-01", this.forwardFlight, 2);
            this.addQuota(tar, false, "2010-01-03", this.forwardFlight, 2);
            this.addQuota(tar, true, "2010-01-05", this.backwardFlight, 2);
            this.addQuota(tar, true, "2010-01-08", this.backwardFlight, 2);
            tar = this.addTariff(app, this.rtBusinessTariff, null, "D");
            this.addQuota(tar, false, "2010-01-01", this.forwardFlight, 2);
            this.addQuota(tar, false, "2010-01-03", this.forwardFlight, 2);
            this.addQuota(tar, true, "2010-01-05", this.backwardFlight, 2);
            this.addQuota(tar, true, "2010-01-08", this.backwardFlight, 2);
            appendices.add(app);
        }
        if (createOW) {
            app = new SUBlockCharterAppendix();
            app.setCurrency("USD");
            app.setItinerary("MOW-LON-MOW");
            app.setType(SUBlockCharterAppendixType.ONE_WAY);
            app.setNumber("OW");
            app.setFareBasis(this.owFareBasis);
            tar = this.addTariff(app, this.rtEconomyTariff, this.owEconomyTariff, "N");
            this.addQuota(tar, false, "2010-01-02", this.forwardFlight, 2);
            this.addQuota(tar, false, "2010-01-03", this.forwardFlight, 2);
            this.addQuota(tar, true, "2010-01-06", this.backwardFlight, 2);
            this.addQuota(tar, true, "2010-01-09", this.backwardFlight, 2);
            tar = this.addTariff(app, this.rtBusinessTariff, this.owBusinessTariff, "D");
            this.addQuota(tar, false, "2010-01-02", this.forwardFlight, 2);
            this.addQuota(tar, false, "2010-01-03", this.forwardFlight, 2);
            this.addQuota(tar, true, "2010-01-06", this.backwardFlight, 2);
            this.addQuota(tar, true, "2010-01-09", this.backwardFlight, 2);
            appendices.add(app);
        }
        this.createProfiles(appendices);
    }
}

