/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.su;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterTariffInfo;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SuSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.su.SUBCReportTestBase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class SuBcReportRenderTest
extends SUBCReportTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRtReportRender() throws Exception {
        this.createProfiles(true, false);
        this.createTicket("2009-12-31", "2010-01-01", "2010-01-05", "MOW", "PAR", false, null, ProductStatus.SELL);
        this.createTicket("2009-12-31", "2010-01-01", "2010-01-05", "MOW", "PAR", false, null, ProductStatus.SELL);
        this.createTicket("2010-01-02", "2010-01-03", "2010-01-08", "MOW", "PAR", false, null, ProductStatus.SELL);
        ProductSearchResult sr = this.createTicket("2010-01-02", "2010-01-03", "2010-01-08", "MOW", "PAR", false, null, ProductStatus.SELL);
        this.createTicket("2010-01-02", "2010-01-03", "2010-01-08", "MOW", "PAR", false, sr, ProductStatus.REFUND);
        this.createTicket("2010-01-02", "2010-01-03", "2010-01-08", "MOW", "PAR", true, null, ProductStatus.SELL);
        this.createTicket("2010-01-02", "2010-01-03", "2010-01-08", "MOW", "PAR", true, null, ProductStatus.VOID);
        this.createTicket("2010-01-02", "2010-01-03", "2010-01-08", "MOW", "PAR", true, null, ProductStatus.VOID);
        sr = this.createTicket("2010-01-01", "2010-01-03", "2010-01-05", "MOW", "PAR", false, null, ProductStatus.SELL);
        sr = this.createTicket("2010-01-01", "2010-01-03", "2010-01-05", "MOW", "PAR", false, sr, ProductStatus.REFUND);
        Product product = (Product)sr.getProduct();
        product.setStatus(ProductStatus.EXCHANGE);
        BigDecimal ruTaxAmount = BigDecimal.ZERO;
        Iterator it = product.getTaxes().iterator();
        while (it.hasNext()) {
            Tax tax = (Tax)it.next();
            if (!"RU".equals(tax.getCode())) continue;
            ruTaxAmount = tax.getEquivalentAmount();
            it.remove();
            break;
        }
        Money amount = ((ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(0)).getAmount();
        amount.setValue(amount.getValue().subtract(ruTaxAmount));
        ++this.count;
        product.setSystemNumber("000" + this.count);
        sr = this.createTicket("2010-01-01", "2010-01-03", "2010-01-05", "MOW", "PAR", false, sr, ProductStatus.SELL);
        product.setSystemNumber(product.getPreviousProduct().getSystemNumber());
        EntityStorage.get().save(sr.getContainer(), false);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.df.parse("2010-01-01")));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.df.parse("2010-01-10")));
        repParam.setAgency(this.agencyRef);
        repParam.setBlankOwner(this.suReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuSalesReportPrepareHandler prepHandler = new SuSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        Map bcDataMap = (Map)parameters.get("KEY_BLOCK_CHARTER_DATA");
        Assert.assertEquals((long)1L, (long)bcDataMap.values().size());
        parameters.put("KEY_BLOCK_CHARTER_DATA", bcDataMap.values().iterator().next());
        SUBCReportTestBase.TestSuBcProgramReportRenderer suBbRender = new SUBCReportTestBase.TestSuBcProgramReportRenderer();
        EntityContainer regRepDoc = suBbRender.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        File fileName = this.buildOutputFileName("SUBCRT.xls");
        try (FileOutputStream fileOut = new FileOutputStream(fileName);){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("SUBCRTPattern.xls")), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOwReportRender() throws Exception {
        HSSFWorkbook wb;
        POIFSFileSystem fs;
        ByteArrayInputStream is;
        this.createProfiles(false, true);
        this.createTicket("2010-01-31", "2010-02-02", "2010-02-06", "MOW", "LON", false, null, ProductStatus.SELL);
        this.createTicket("2010-01-31", "2010-02-02", "2010-02-06", "MOW", "LON", true, null, ProductStatus.SELL);
        this.createTicket("2010-01-31", "2010-02-02", null, "MOW", "LON", false, null, ProductStatus.SELL);
        this.createTicket("2010-02-02", "2010-02-03", "2010-02-09", "MOW", "LON", false, null, ProductStatus.SELL);
        this.createTicket("2010-02-02", "2010-02-03", "2010-02-09", "MOW", "LON", false, null, ProductStatus.SELL);
        ProductSearchResult sr = this.createTicket("2010-02-02", "2010-02-03", "2010-02-09", "MOW", "LON", false, null, ProductStatus.SELL);
        this.createTicket("2010-02-02", "2010-02-03", "2010-02-09", "MOW", "LON", false, sr, ProductStatus.REFUND);
        this.createTicket("2010-02-02", null, "2010-02-09", "MOW", "LON", true, null, ProductStatus.SELL);
        this.createTicket("2010-02-02", null, "2010-02-09", "MOW", "LON", true, null, ProductStatus.VOID);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)this.df.parse("2010-02-01")));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)this.df.parse("2010-02-10")));
        repParam.setAgency(this.agencyRef);
        repParam.setBlankOwner(this.suReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuSalesReportPrepareHandler prepHandler = new SuSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        Map bcDataMap = (Map)parameters.get("KEY_BLOCK_CHARTER_DATA");
        Assert.assertEquals((long)1L, (long)bcDataMap.values().size());
        parameters.put("KEY_BLOCK_CHARTER_DATA", bcDataMap.values().iterator().next());
        Object suBbRender = new SUBCReportTestBase.TestSuBcProgramReportRenderer();
        EntityContainer regRepDoc = suBbRender.renderReport(parameters);
        ReportFile repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        File fileName = this.buildOutputFileName("SUBCOW.xls");
        try (FileOutputStream fileOut = new FileOutputStream(fileName);){
            is = new ByteArrayInputStream(repFile.getContent());
            fs = new POIFSFileSystem((InputStream)is);
            wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("SUBCOWPattern.xls")), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
        suBbRender = new SUBCReportTestBase.TestSuBcOldDateRegistryRenderer();
        regRepDoc = suBbRender.renderReport(parameters);
        repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        fileName = this.buildOutputFileName("SUBCOWOldDateRegistry.xls");
        fileOut = new FileOutputStream(fileName);
        try {
            is = new ByteArrayInputStream(repFile.getContent());
            fs = new POIFSFileSystem((InputStream)is);
            wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        finally {
            fileOut.close();
        }
        res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("SUBCOWOldDateRegistryPattern.xls")), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
        suBbRender = new SUBCReportTestBase.TestSuBcSellReportRenderer();
        regRepDoc = suBbRender.renderReport(parameters);
        repFile = (ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(0);
        fileName = this.buildOutputFileName("SUBCOWSellRegistry.xls");
        fileOut = new FileOutputStream(fileName);
        try {
            is = new ByteArrayInputStream(repFile.getContent());
            fs = new POIFSFileSystem((InputStream)is);
            wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
        finally {
            fileOut.close();
        }
        res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("SUBCOWSellRegistryPattern.xls")), (File)fileName);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    private void createProfiles(boolean createRT, boolean createOW) throws Exception {
        SUBlockCharterTariffInfo tar;
        SUBlockCharterAppendix app;
        ArrayList<SUBlockCharterAppendix> appendices = new ArrayList<SUBlockCharterAppendix>();
        if (createRT) {
            app = new SUBlockCharterAppendix();
            app.setCurrency("USD");
            app.setItinerary("MOW-PAR-MOW");
            app.setType(SUBlockCharterAppendixType.ROUND_TRIP);
            app.setNumber("RT");
            app.setFareBasis(this.rtFareBasis);
            tar = this.addTariff(app, this.rtEconomyTariff, null, "N");
            this.addQuota(tar, false, "2010-01-01", this.forwardFlight, 2);
            this.addQuota(tar, false, "2010-01-03", this.forwardFlight, 2);
            this.addQuota(tar, true, "2010-01-05", this.backwardFlight, 2);
            this.addQuota(tar, true, "2010-01-08", this.backwardFlight, 2);
            tar = this.addTariff(app, this.rtBusinessTariff, null, "D");
            this.addQuota(tar, false, "2010-01-01", this.forwardFlight, 1);
            this.addQuota(tar, false, "2010-01-03", this.forwardFlight, 1);
            this.addQuota(tar, true, "2010-01-05", this.backwardFlight, 1);
            this.addQuota(tar, true, "2010-01-08", this.backwardFlight, 1);
            appendices.add(app);
        }
        if (createOW) {
            app = new SUBlockCharterAppendix();
            app.setCurrency("USD");
            app.setItinerary("MOW-LON-MOW");
            app.setType(SUBlockCharterAppendixType.ONE_WAY);
            app.setNumber("OW");
            app.setFareBasis(this.owFareBasis);
            tar = this.addTariff(app, this.rtEconomyTariff, this.owEconomyTariff, "N");
            this.addQuota(tar, false, "2010-02-02", this.forwardFlight, 2);
            this.addQuota(tar, false, "2010-02-03", this.forwardFlight, 2);
            this.addQuota(tar, true, "2010-02-06", this.backwardFlight, 2);
            this.addQuota(tar, true, "2010-02-09", this.backwardFlight, 2);
            tar = this.addTariff(app, this.rtBusinessTariff, this.owBusinessTariff, "D");
            this.addQuota(tar, false, "2010-02-02", this.forwardFlight, 1);
            this.addQuota(tar, false, "2010-02-03", this.forwardFlight, 1);
            this.addQuota(tar, true, "2010-02-06", this.backwardFlight, 1);
            this.addQuota(tar, true, "2010-02-09", this.backwardFlight, 1);
            appendices.add(app);
        }
        this.createProfiles(appendices);
    }
}

