/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.su;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LuggageUnits;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.su.SuReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.registry.SuRegistryRender;
import com.gridnine.xtrip.common.reports.render.salesreports.su.xml.SuXmlReportRender;
import com.gridnine.xtrip.common.reports.render.salesreports.su.xml.SuXmlValidator;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.parsers.test.ParsersTestHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SuSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import com.gridnine.xtrip.server.reports.salesreports.render.su.SUBCReportTestBase;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class SuReportRenderTest
extends RenderSalesReportTestBase {
    private final String validatorCode = "111111";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuReportRender() throws Exception {
        HashMap<MetadataKey, Object> metadatas = new HashMap<MetadataKey, Object>();
        metadatas.put(MetadataKey.KEY_SU_AGENCY_CODE, "0001");
        metadatas.put(MetadataKey.KEY_SU_2013_AGENCY_CODE, "0002");
        EntityContainer<Organization> agencyContainer = this.createOrganization("agency1", "ABC", "ABC agency", metadatas);
        EntityReference agencyReference = agencyContainer.toReference();
        EntityContainer<Organization> subagencyContainer = this.createOrganization("agency2", "ABC", "ABC agency", Collections.emptyMap());
        EntityReference subagencyReference = subagencyContainer.toReference();
        Product sell = this.createTicket((EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "agency1", "9999999999", "0012345678", ProductStatus.SELL, null, null);
        this.createTicket((EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "agency1", "9999999999", "0012345678", ProductStatus.REFUND, sell, null);
        this.createExceesBagage((EntityReference<Organization>)agencyReference, (EntityReference<Organization>)agencyReference, "agency1", "00032132123", "00032132123", ProductStatus.SELL);
        Product sell1 = this.createTicket((EntityReference<Organization>)agencyReference, (EntityReference<Organization>)subagencyReference, "agency2", "001", "0012345678", ProductStatus.SELL, null, null);
        this.createTicket((EntityReference<Organization>)agencyReference, (EntityReference<Organization>)subagencyReference, "agency2", "101", "0012345678", ProductStatus.REFUND, sell1, null);
        Product sell2 = this.createTicket((EntityReference<Organization>)agencyReference, (EntityReference<Organization>)subagencyReference, "agency2", "002", "0022345678", ProductStatus.SELL, null, null);
        Product exch = this.createTicket((EntityReference<Organization>)agencyReference, (EntityReference<Organization>)subagencyReference, "agency2", "030", "0022345678", ProductStatus.EXCHANGE, sell1, sell2);
        ProductSearchResult psr = ParsersTestHelper.findProduct((String)"002", (ProductStatus)ProductStatus.SELL);
        ((Product)psr.getProduct()).setPreviousProduct(exch);
        this.save(psr.getContainer());
        this.createContract((EntityReference<Organization>)agencyReference, (EntityReference<Organization>)this.suReference);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ReportParameters repParam = new ReportParameters();
        repParam.setPeriodBegin(MiscUtil.clearTime((Date)new Date()));
        repParam.setPeriodEnd(MiscUtil.setDayEndTime((Date)new Date()));
        repParam.setAgency(agencyReference);
        repParam.setBlankOwner(this.suReference);
        repParam.setAgency(agencyReference);
        parameters.put("key-report-params", repParam);
        parameters.put("key-vendor", EntityStorage.get().resolve(this.suReference).getEntity());
        SuSalesReportPrepareHandler prepHandler = new SuSalesReportPrepareHandler();
        this.setMultyAgencyReport(false);
        prepHandler.prepareData(parameters);
        SuXmlReportRender handler = new SuXmlReportRender();
        ReportFile repFile = (ReportFile)((ReportDocument)handler.renderReport(parameters).getEntity()).getFiles().get(0);
        byte[] content = repFile.getContent();
        this.setMultyAgencyReport(true);
        this.log.debug(new String(content));
        File outputFile = this.buildOutputFileName("Aeroflot.xml");
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            fos.write(content);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        String validationString = SuXmlValidator.validate((Document)factory.newDocumentBuilder().parse(new ByteArrayInputStream(content)));
        Assert.assertNull((String)validationString, (Object)validationString);
        TestSuReportRenderHandler suRepHandler = new TestSuReportRenderHandler();
        EntityContainer<ReportDocument> regRepDoc = suRepHandler.renderReport(parameters);
        fos = new FileOutputStream(this.buildOutputFileName("AeroflotReg.xls"));
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(((ReportFile)((ReportDocument)regRepDoc.getEntity()).getFiles().get(1)).getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fos);
        }
        finally {
            fos.close();
        }
        Assert.assertTrue((content.length != 0 ? 1 : 0) != 0);
    }

    private EntityContainer<Contract> createContract(EntityReference<Organization> agencyRef, EntityReference<Organization> vendorRef) throws Exception {
        EntityContainer commPercent = new EntityContainer(CommissionProperties.class);
        ((CommissionProperties)commPercent.getEntity()).setDisplayName("Commission %");
        ((CommissionProperties)commPercent.getEntity()).setRate(true);
        ((CommissionProperties)commPercent.getEntity()).setRoundingMode(RoundingMode.NONE);
        ((CommissionProperties)commPercent.getEntity()).setRate(true);
        EntityStorage.get().save(commPercent, false);
        EntityContainer result = new EntityContainer(Contract.class);
        Contract contract = (Contract)result.getEntity();
        contract.setVendor(vendorRef);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(new Date());
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(vendorRef);
        info.setCustomer(agencyRef);
        contract.setVendor(vendorRef);
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("A1");
        RuleRestriction restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)"SU");
        rs.getRestrictions().add(restr);
        RuleResult res = new RuleResult();
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(commPercent.toReference());
        value.setValue(2.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        this.save(result);
        return result;
    }

    private Product createTicket(EntityReference<Organization> agencyRef, EntityReference<Organization> subAgencyRef, String pnr, String ticketNo, String scn, ProductStatus productStatus, Product prevTicket, Product nextTicket) throws Exception {
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile bf = (BookingFile)bfc.getEntity();
        Reservation res = new Reservation();
        this.setRecordLocator(res, pnr);
        res.setBookingFile(bf);
        Product product = new Product();
        Traveller traveller = new Traveller();
        traveller.setName("PUTIN MR.");
        product.setTraveller(traveller);
        product.setPreviousProduct(prevTicket);
        product.setNextProduct(nextTicket);
        product.setReservation(res);
        product.setSystemNumber(ticketNo);
        product.getScns().add(scn);
        product.setConjCount(0);
        product.setStatus(productStatus);
        product.setProductCategory(ProductCategory.AIR);
        product.setTariffType(TariffType.REGULAR);
        product.setValidatorCode("111111");
        Calendar cl = Calendar.getInstance();
        cl.setTime(new Date());
        product.setIssueDate(cl.getTime());
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)new BigDecimal(100.0));
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setEquivalentAmount(new BigDecimal(37));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("YQ");
        tax.setEquivalentAmount(new BigDecimal(1200));
        product.getTaxes().add(tax);
        Money baseFare = new Money();
        baseFare.setCurrency("EUR");
        baseFare.setValue(new BigDecimal(10.0));
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        Airline airline = DictHelper.findAirlineByAnyCode((String)"555");
        product.setBlankOwnerRef(this.suReference);
        product.setBlankOwnerNumber("555");
        Iterator iterator = BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef()).iterator();
        if (iterator.hasNext()) {
            BlankType bt = (BlankType)iterator.next();
            bt.getCode().equals("555 24");
            product.setBlankType((DictionaryReference)new BlankTypeReference(bt));
        }
        SegmentTariff st = new SegmentTariff();
        Segment seg = new Segment();
        seg.setAirline((DictionaryReference)airline.toReference());
        seg.setFlightNo("101");
        seg.setDepartCityCode("SVO");
        seg.setDepartureLocation((DictionaryReference)new GeoLocationReference("SVO"));
        seg.setArriveCityCode("LHR");
        seg.setArriveLocation((DictionaryReference)new GeoLocationReference("LHR"));
        seg.setRecordNumber(1);
        seg.setFareBasis("5");
        st.getSegments().add(seg);
        seg = new Segment();
        seg.setAirline((DictionaryReference)airline.toReference());
        seg.setFlightNo("102");
        seg.setDepartCityCode("LHR");
        seg.setDepartureLocation((DictionaryReference)new GeoLocationReference("LHR"));
        seg.setArriveCityCode("SVO");
        seg.setArriveLocation((DictionaryReference)new GeoLocationReference("SVO"));
        seg.setRecordNumber(3);
        seg.setFareBasis("5");
        st.getSegments().add(seg);
        product.getSegmentTariffs().add(st);
        product.setTicketType(TicketType.OWN);
        bf.setAgency(agencyRef);
        AirProductHelper.setSubagency((Product)product, subAgencyRef);
        AirProductHelper.setAgency((Product)product, agencyRef);
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setAgencyCode(((Organization)EntityStorage.get().resolve(subAgencyRef).getEntity()).getCode());
        ProductFop fop = new ProductFop();
        fop.setType(PaymentType.CASH);
        Money fopMoney = new Money();
        fopMoney.setCurrency("RUB");
        fopMoney.setValue(new BigDecimal(1337));
        fop.setAmount(fopMoney);
        fop.setOperationDate(product.getIssueDate());
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setChecked(true);
        List blankTypes = BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef());
        for (BlankType type : blankTypes) {
            if (type.getBlankCategory() != BlankCategory.ETICKET) continue;
            product.setBlankType((DictionaryReference)type.toReference());
            product.setProductCategory(type.getProductCategory());
            break;
        }
        product.setCashier(new EntityReference("cashier_uid", Person.class, null));
        res.getProducts().add(product);
        bf.getReservations().add(res);
        this.save(bfc);
        return product;
    }

    private void createExceesBagage(EntityReference<Organization> agencyRef, EntityReference<Organization> subAgencyRef, String pnr, String ticketNo, String scn, ProductStatus productStatus) throws Exception {
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile bf = (BookingFile)bfc.getEntity();
        Reservation res = new Reservation();
        this.setRecordLocator(res, pnr);
        res.setBookingFile(bf);
        Product product = new Product();
        Traveller traveller = new Traveller();
        traveller.setName("PUTIN MR.");
        product.setTraveller(traveller);
        product.setReservation(res);
        product.setSystemNumber(ticketNo);
        product.getScns().add(scn);
        product.setConjCount(0);
        product.setStatus(productStatus);
        product.setProductCategory(ProductCategory.EXCESS_BAGAGE);
        product.setLuggageWeight(Double.valueOf(10.0));
        product.setLuggageUnits(LuggageUnits.PIECE);
        product.setIssueDate(new Date());
        product.setTariffType(TariffType.REGULAR);
        product.setValidatorCode("111111");
        Airline airline = DictHelper.findAirlineByAnyCode((String)"555");
        SegmentTariff st = new SegmentTariff();
        Segment seg = new Segment();
        seg.setAirline((DictionaryReference)airline.toReference());
        seg.setFlightNo("101");
        seg.setDepartCityCode("SVO");
        seg.setDepartureLocation((DictionaryReference)new GeoLocationReference("SVO"));
        seg.setArriveCityCode("LHR");
        seg.setArriveLocation((DictionaryReference)new GeoLocationReference("LHR"));
        seg.setRecordNumber(1);
        seg.setFareBasis("5");
        st.getSegments().add(seg);
        seg = new Segment();
        seg.setAirline((DictionaryReference)airline.toReference());
        seg.setFlightNo("102");
        seg.setDepartCityCode("LHR");
        seg.setDepartureLocation((DictionaryReference)new GeoLocationReference("LHR"));
        seg.setArriveCityCode("SVO");
        seg.setArriveLocation((DictionaryReference)new GeoLocationReference("SVO"));
        seg.setRecordNumber(3);
        seg.setFareBasis("5");
        st.getSegments().add(seg);
        product.getSegmentTariffs().add(st);
        Money baseFare = new Money();
        baseFare.setCurrency("EUR");
        baseFare.setValue(new BigDecimal(10.0));
        AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)new BigDecimal(100.0));
        product.setBlankOwnerRef(this.suReference);
        product.setBlankOwnerNumber("555");
        Iterator iterator = BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef()).iterator();
        if (iterator.hasNext()) {
            BlankType bt = (BlankType)iterator.next();
            product.setBlankType((DictionaryReference)new BlankTypeReference(bt));
        }
        product.setTicketType(TicketType.OWN);
        bf.setAgency(agencyRef);
        AirProductHelper.setSubagency((Product)product, subAgencyRef);
        AirProductHelper.setAgency((Product)product, agencyRef);
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setAgencyCode(((Organization)EntityStorage.get().resolve(subAgencyRef).getEntity()).getCode());
        ProductFop fop = new ProductFop();
        Money fopMoney = new Money();
        fopMoney.setCurrency("RUB");
        fopMoney.setValue(new BigDecimal(100));
        fop.setAmount(fopMoney);
        fop.setType(PaymentType.CASH);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setChecked(true);
        List blankTypes = BookingHelper.getBlankTypesByVendor((EntityReference)product.getBlankOwnerRef());
        for (BlankType type : blankTypes) {
            if (type.getBlankCategory() != BlankCategory.PRINTED_NUMBER) continue;
            product.setBlankType((DictionaryReference)type.toReference());
            product.setProductCategory(type.getProductCategory());
            break;
        }
        product.setCashier(new EntityReference("cashier_uid", Person.class, null));
        res.getProducts().add(product);
        bf.getReservations().add(res);
        EntityStorage.get().save(bfc, true);
    }

    private void setMultyAgencyReport(boolean enable) throws Exception {
        DictionaryStorage ds = DictionaryStorage.get();
        Collection dicts = ds.loadAll(null, Preference.class);
        for (BaseDictionary dict : dicts) {
            if (!((Preference)dict).getKey().equals((Object)PreferenceKey.XML_REPORT_TICKET_ORDER_FOR_MULTYAGENCY_REPORT)) continue;
            if (enable) {
                ((Preference)dict).setValue("YES");
            } else {
                ((Preference)dict).setValue("NO");
            }
            ds.save(dict);
            break;
        }
    }

    static class TestSuReportRenderHandler
    extends SuReportRenderHandler {
        TestSuReportRenderHandler() {
        }

        public EntityContainer<ReportDocument> renderReport(Map<String, Object> parameters) throws Exception {
            if (parameters.get("key-batch-data-list") == null) {
                return null;
            }
            EntityContainer result = new EntityContainer(ReportDocument.class);
            ((ReportDocument)result.getEntity()).setParameters((ReportParameters)parameters.get("key-report-params"));
            ((ReportDocument)result.getEntity()).getFiles().addAll(((ReportDocument)new SuXmlReportRender().renderReport(parameters).getEntity()).getFiles());
            ((ReportDocument)result.getEntity()).getFiles().addAll(((ReportDocument)new TestSuRegistryRender().renderReport(parameters).getEntity()).getFiles());
            Map bcDataMap = (Map)parameters.get("KEY_BLOCK_CHARTER_DATA");
            if (bcDataMap != null && !bcDataMap.isEmpty()) {
                for (SUBCData bcData : bcDataMap.values()) {
                    parameters.put("KEY_BLOCK_CHARTER_DATA", bcData);
                    ((ReportDocument)result.getEntity()).getFiles().addAll(((ReportDocument)new SUBCReportTestBase.TestSuBcSellReportRenderer().renderReport(parameters).getEntity()).getFiles());
                }
            }
            return result;
        }
    }

    static class TestSuRegistryRender
    extends SuRegistryRender<SuTicket> {
        TestSuRegistryRender() {
        }

        protected File getTemplateFile() {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            return result;
        }
    }
}

