/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.salesreports.tch.TchSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import com.gridnine.xtrip.server.setup.SetupManager;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class Bug1061Test
extends RenderSalesReportTestBase {
    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("tchSalesReportTestDictionaries.xml");
    }

    protected URL getEntitiesSetupFile() {
        this.prepareAgent();
        return ((Object)((Object)this)).getClass().getResource("testdata/bug1061.xml");
    }

    protected void doSetup(SetupManager sm) throws Exception {
        GeneralProductHelper.ensureContractRelationsExists();
        super.doSetup(sm);
    }

    public void prepareAgent() {
        EntityStorage es = EntityStorage.get();
        String user = LogicalStorage.get().getUser();
        EntityContainer agentContainer = new EntityContainer(Person.class);
        agentContainer.setCreatedBy(user);
        agentContainer.setModifiedBy(user);
        Person agent = (Person)agentContainer.getEntity();
        agent.setUid("Test uid");
        agent.setCode("testAgent");
        agent.setLoginName(user);
        es.save(agentContainer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExchanges() throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        ReportParameters params = new ReportParameters();
        params.setPeriodBegin(sdf.parse("2009.04.21 00:00:00"));
        params.setPeriodEnd(sdf.parse("2009.05.01 00:00:00"));
        params.setAgency((EntityReference)ProfileDao.getProfileReferenceByCode((String)"002", OrganizationIndex.class).get(0));
        params.setBlankOwner(EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)"\u04281").toReference());
        TchSalesReportPrepareHandler handler = new TchSalesReportPrepareHandler();
        data.put("key-report-params", params);
        handler.prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage()), (boolean)true);
        }
        List batchDataList = (List)data.get("key-batch-data-list");
        ReportBatchData cashList = null;
        ReportBatchData packBatch = null;
        for (ReportBatchData batch : batchDataList) {
            if (batch.getBatchId().equals("CASH")) {
                cashList = batch;
                continue;
            }
            if (!batch.getBatchId().equals("PACK")) continue;
            packBatch = batch;
        }
        Assert.assertEquals((long)1L, (long)packBatch.getTickets().size());
        List tickets = cashList.getTickets();
        Assert.assertEquals((long)7L, (long)tickets.size());
        File outFile = new File(this.getOutFolder(), "bug1061.xls");
        TchSalesReportTestBase.TestTchReportRenderHandler renderHandler = new TchSalesReportTestBase.TestTchReportRenderHandler();
        EntityContainer renderReport = renderHandler.renderReport(data);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(((ReportFile)((ReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)Bug1061Test.class.getResource("testdata/bug1061.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

