/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class Bug2198Test
extends TchSalesReportTestBase {
    @Test
    public void testExchanges() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        String relatedProductUid = this.createProduct("001", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, "A1");
        relatedProductUid = this.createProduct("001", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.EXCHANGE, relatedProductUid, PaymentType.CASH, ProductCategory.AIR, null, false, "A1");
        relatedProductUid = this.createProduct("002", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, relatedProductUid, PaymentType.CASH, ProductCategory.AIR, null, false, "A1");
        EntityContainer ctr = BookingDao.findProductByUid((String)relatedProductUid).getContainer();
        Product product = (Product)CollectionUtil.find((Iterable)((Reservation)((BookingFile)ctr.getEntity()).getReservations().get(0)).getProducts(), (String)relatedProductUid);
        List vendorFops = AirProductHelper.getVendorContractRelation((Product)product).getFops();
        List clientFops = AirProductHelper.getClientContractRelation((Product)product).getFops();
        vendorFops.clear();
        clientFops.clear();
        BigDecimal total = AirProductHelper.getEquivalentFare((Product)product).add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product));
        BigDecimal exchangeAmount = BigDecimal.valueOf(100L).add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product));
        Object value = SystemHelper.getMoney((double)exchangeAmount.doubleValue(), (String)"RUB");
        ProductFop fop2 = new ProductFop();
        fop2.setAmount((Money)value);
        fop2.setExchangePaymentType(PaymentType.CASH);
        fop2.setOperationDate(product.getIssueDate());
        fop2.setType(PaymentType.TICKET);
        vendorFops.add(fop2);
        value = SystemHelper.getMoney((double)total.subtract(exchangeAmount).doubleValue(), (String)"RUB");
        fop2 = new ProductFop();
        fop2.setAmount((Money)value);
        fop2.setOperationDate(product.getIssueDate());
        fop2.setType(PaymentType.CASH);
        vendorFops.add(fop2);
        for (ProductFop fop2 : vendorFops) {
            clientFops.add(XCloneHelper.clone((XCloneable)fop2, (boolean)true));
        }
        File outFile = new File(this.getOutFolder(), "bug2198.xls");
        this.createReport(outFile);
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("testdata/bug2198.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

