/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.reports.prepare.salesreports.tch.TchSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.Code99ATestBase;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class Code99ATest
extends Code99ATestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReport() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        this.createBookingFile();
        HashMap<String, Object> data = new HashMap<String, Object>();
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ReportParameters params = new ReportParameters();
        params.setPeriodBegin(cldr.getTime());
        cldr.add(2, 12);
        params.setPeriodEnd(cldr.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        params.setBlankOwner(this.vendorContainer.toReference());
        TchSalesReportPrepareHandler handler = new TchSalesReportPrepareHandler();
        data.put("key-report-params", params);
        handler.prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)message.getMessage().getKey(), (boolean)true);
        }
        File outFile = new File(this.getOutFolder(), "code99ATest.xls");
        TchSalesReportTestBase.TestTchReportRenderHandler renderHandler = new TchSalesReportTestBase.TestTchReportRenderHandler();
        EntityContainer renderReport = renderHandler.renderReport(data);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(((ReportFile)((ReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("code99ATest.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    private void createBookingFile() throws Exception {
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile result = (BookingFile)bfc.getEntity();
        result.setCustomerProfile(this.clientContainer.toReference());
        String user = LogicalStorage.get().getUser();
        bfc.setCreatedBy(user);
        bfc.setModifiedBy(user);
        Reservation reservation = new Reservation();
        reservation.setBookingFile(result);
        result.getReservations().add(reservation);
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        result.getTravellers().add(traveller);
        result.setAgency(new EntityReference(this.agencyContainer));
        Product product = new Product();
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setTraveller(traveller);
        product.setProductCategory(ProductCategory.AIR);
        product.setBlankOwnerRef(this.findBlankOwnerByCode("\u04281"));
        product.setBlankOwnerNumber("99A");
        product.setStatus(ProductStatus.SELL);
        product.setCarrier((DictionaryReference)new AirlineReference("A1"));
        product.setCarrierNumber("99A");
        product.setBlankType((DictionaryReference)new BlankTypeReference("99A 661"));
        product.setTicketType(TicketType.OWN);
        product.setTariffType(TariffType.REGULAR);
        product.setValidatorCode("12345678");
        product.setCashier(this.agent);
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyContainer.toReference());
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        Segment segment = new Segment();
        segment.setStartDate(Calendar.getInstance().getTime());
        segment.setAirline((DictionaryReference)new AirlineReference("A1"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference(this.cityCode1));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference(this.cityCode2));
        segment.setFareBasis("farebasis");
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(0.5 * this.tariffFare));
        AirProductHelper.setSegmentBaseFare((Product)product, (SegmentTariff)sppPsgr, (Money)SystemHelper.getMoney((double)(0.5 * this.tariffFare), (String)"RUB"));
        Tax tax = new Tax();
        tax.setCode("TTcode");
        tax.setEquivalentAmount(BigDecimal.valueOf(0.5 * this.taxAmount));
        tax.setSegmentTariff(sppPsgr);
        product.getTaxes().add(tax);
        segment = new Segment();
        segment.setStartDate(Calendar.getInstance().getTime());
        segment.setAirline((DictionaryReference)new AirlineReference("A2"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference(this.cityCode2));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference(this.cityCode1));
        segment.setFareBasis("farebasis");
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(0.5 * this.tariffFare));
        AirProductHelper.setSegmentBaseFare((Product)product, (SegmentTariff)sppPsgr, (Money)SystemHelper.getMoney((double)(0.5 * this.tariffFare), (String)"RUB"));
        tax = new Tax();
        tax.setCode("TTcode");
        tax.setEquivalentAmount(BigDecimal.valueOf(0.5 * this.taxAmount));
        tax.setSegmentTariff(sppPsgr);
        product.getTaxes().add(tax);
        ProductFop fop = new ProductFop();
        fop.setType(PaymentType.CASH);
        fop.setOperationDate(this.issueDate);
        fop.setAmount(SystemHelper.getMoney((double)(this.tariffFare + this.taxAmount), (String)this.equiveCurrencyCode));
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setIssueDate(this.issueDate);
        product.setSystemNumber("A1");
        product = new Product();
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setTraveller(traveller);
        product.setProductCategory(ProductCategory.AIR);
        product.setBlankOwnerRef(this.findBlankOwnerByCode("\u04281"));
        product.setBlankOwnerNumber("99A");
        product.setStatus(ProductStatus.SELL);
        product.setCarrier((DictionaryReference)new AirlineReference("A2"));
        product.setCarrierNumber("99A");
        product.setCashier(this.agent);
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyContainer.toReference());
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setBlankType((DictionaryReference)new BlankTypeReference("99A 661"));
        product.setTicketType(TicketType.OWN);
        product.setTariffType(TariffType.REGULAR);
        product.setValidatorCode("12345678");
        segment = new Segment();
        segment.setStartDate(Calendar.getInstance().getTime());
        segment.setAirline((DictionaryReference)new AirlineReference("A2"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference(this.cityCode1));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference(this.cityCode2));
        segment.setFareBasis("farebasis");
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(0.5 * this.tariffFare));
        AirProductHelper.setSegmentBaseFare((Product)product, (SegmentTariff)sppPsgr, (Money)SystemHelper.getMoney((double)(0.5 * this.tariffFare), (String)"RUB"));
        tax = new Tax();
        tax.setCode("TTcode");
        tax.setEquivalentAmount(BigDecimal.valueOf(0.5 * this.taxAmount));
        tax.setSegmentTariff(sppPsgr);
        product.getTaxes().add(tax);
        segment = new Segment();
        segment.setStartDate(Calendar.getInstance().getTime());
        segment.setAirline((DictionaryReference)new AirlineReference("A3"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference(this.cityCode2));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference(this.cityCode1));
        segment.setFareBasis("farebasis");
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(0.5 * this.tariffFare));
        AirProductHelper.setSegmentBaseFare((Product)product, (SegmentTariff)sppPsgr, (Money)SystemHelper.getMoney((double)(0.5 * this.tariffFare), (String)"RUB"));
        tax = new Tax();
        tax.setCode("TTcode");
        tax.setEquivalentAmount(BigDecimal.valueOf(0.5 * this.taxAmount));
        tax.setSegmentTariff(sppPsgr);
        product.getTaxes().add(tax);
        fop = new ProductFop();
        fop.setType(PaymentType.CASH);
        fop.setAmount(SystemHelper.getMoney((double)(this.tariffFare + this.taxAmount), (String)this.equiveCurrencyCode));
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setIssueDate(this.issueDate);
        fop.setOperationDate(this.issueDate);
        product.setSystemNumber("A1");
        EntityStorage.get().save(bfc, true);
    }
}

