/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.test.TestSalesPointBuilder;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

abstract class Code99ATestBase
extends RenderSalesReportTestBase {
    protected double rate1 = 10.0;
    protected double tariffFare = 1000.0;
    protected double taxAmount = 100.0;
    protected String equiveCurrencyCode = "RUB";
    protected Date issueDate;
    protected EntityContainer<Organization> agencyContainer;
    protected EntityContainer<Organization> vendorContainer;
    protected EntityContainer<Organization> clientContainer;
    protected EntityContainer<Person> agentContainer;
    protected String cityCode1 = "testCityCode1";
    protected String cityCode2 = "testCityCode2";
    protected EntityReference<SalesPoint> salesPointRef;
    protected String validator = "000001";

    Code99ATestBase() {
    }

    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("tchSalesReportTestDictionaries.xml");
    }

    protected URL getEntitiesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("standardActionsTestEntities.xml");
    }

    protected void createProfiles() throws Exception {
        String registrationName = "\u0422\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u043d\u0430\u044f \u043a\u043b\u0438\u0440\u0438\u043d\u0433\u043e\u0432\u0430\u044f \u043f\u0430\u043b\u0430\u0442\u0430 / Transport Clearing House";
        this.vendorContainer = new EntityContainer(Organization.class);
        String user = LogicalStorage.get().getUser();
        this.vendorContainer.setCreatedBy(user);
        this.vendorContainer.setModifiedBy(user);
        Organization profile = (Organization)this.vendorContainer.getEntity();
        L10nStringHelper.setValue((L10nString)profile.getShortName(), (String)"\u0422\u041a\u041f / TCH", (Locale)Locale.ENGLISH);
        profile.setActive(true);
        profile.setCode("\u04281");
        L10nStringHelper.setValue((L10nString)profile.getFullName(), (String)registrationName, (Locale)Locale.ENGLISH);
        profile.setRegistrationId("0000000015");
        profile.setAirline((DictionaryReference)new AirlineReference("\u04281"));
        EntityStorage es = EntityStorage.get();
        es.save(this.vendorContainer, true);
        this.agencyContainer = new EntityContainer(Organization.class);
        this.agencyContainer.setCreatedBy(user);
        this.agencyContainer.setModifiedBy(user);
        Organization agency = (Organization)this.agencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"testAgency", (Locale)Locale.ENGLISH);
        agency.setActive(true);
        agency.setCode("testAgency");
        es.save(this.agencyContainer, true);
        this.agentContainer = new EntityContainer(Person.class);
        this.agentContainer.setCreatedBy(user);
        this.agentContainer.setModifiedBy(user);
        Person agent = (Person)this.agentContainer.getEntity();
        agent.setCode("testAgent");
        agent.setLoginName(user);
        es.save(this.agentContainer, true);
        this.clientContainer = new EntityContainer(Organization.class);
        this.clientContainer.setCreatedBy(user);
        this.clientContainer.setModifiedBy(user);
        Organization client = (Organization)this.clientContainer.getEntity();
        L10nStringHelper.setValue((L10nString)client.getShortName(), (String)"testClient", (Locale)Locale.ENGLISH);
        client.setActive(true);
        client.setCode("testClient");
        es.save(this.clientContainer, true);
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        cc.setCreatedBy(user);
        cc.setModifiedBy(user);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(new EntityReference(this.vendorContainer));
        info.setCustomer(new EntityReference(this.agencyContainer));
        contract.setVendor(new EntityReference(this.vendorContainer));
        info.setNumber("01");
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("A1");
        RuleRestriction restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)"TCH");
        rs.getRestrictions().add(restr);
        RuleResult res = new RuleResult();
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setValue(this.rate1);
        value.setTarget(new EntityReference("commission_rate_1", CommissionProperties.class, "commission_rate_1"));
        res.setValue((Object)value);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        es.save(cc, true);
        this.salesPointRef = new TestSalesPointBuilder().agency(this.agencyContainer.toReference()).validator(this.vendorContainer.toReference(), this.agencyContainer.toReference(), this.validator).create().toReference();
    }
}

