/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.reports.prepare.salesreports.tch.TchSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class CombinedFopTest
extends RenderSalesReportTestBase {
    private final double rate1 = 10.0;
    private final double tariffFare = 1000.0;
    private final double taxAmount = 100.0;
    private final String equiveCurrencyCode = "RUB";
    private Date issueDate;
    private EntityContainer<Organization> agencyContainer;
    private EntityContainer<Person> agentContainer;
    private EntityContainer<Organization> clientContainer;
    private final String cityCode1 = "testCityCode1";
    private final String cityCode2 = "testCityCode2";

    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("tchSalesReportTestDictionaries.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReport() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        this.createBookingFile();
        HashMap<String, Object> data = new HashMap<String, Object>();
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ReportParameters params = new ReportParameters();
        params.setPeriodBegin(cldr.getTime());
        cldr.add(2, 12);
        params.setPeriodEnd(cldr.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        params.setBlankOwner(this.findBlankOwnerByCode("\u04281"));
        TchSalesReportPrepareHandler handler = new TchSalesReportPrepareHandler();
        data.put("key-report-params", params);
        handler.prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)message.getMessage().getKey(), (boolean)true);
        }
        File outFile = new File(this.getOutFolder(), "combinedFopTest.xls");
        TchSalesReportTestBase.TestTchReportRenderHandler renderHandler = new TchSalesReportTestBase.TestTchReportRenderHandler();
        EntityContainer renderReport = renderHandler.renderReport(data);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            os.write(((ReportFile)((ReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
        }
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("combinedFopTest.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    private void createBookingFile() throws Exception {
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile result = (BookingFile)bfc.getEntity();
        result.setCustomerProfile(this.clientContainer.toReference());
        String user = LogicalStorage.get().getUser();
        bfc.setCreatedBy(user);
        bfc.setModifiedBy(user);
        Reservation reservation = new Reservation();
        reservation.setBookingFile(result);
        result.getReservations().add(reservation);
        this.addProduct(reservation, result, "A1");
        Product product = this.addProduct(reservation, result, "A2");
        ((ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(0)).getFares().add(product.getFares().get(0));
        ((ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(0)).getAmount().setValue(((ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(0)).getAmount().getValue().subtract(BigDecimal.TEN));
        ((ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(1)).getFares().add(product.getFares().get(0));
        ((ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(1)).getTaxes().add(product.getTaxes().get(0));
        ((ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(1)).getAmount().setValue(((ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(1)).getAmount().getValue().add(BigDecimal.TEN));
        EntityStorage.get().save(bfc, true);
    }

    private Product addProduct(Reservation reservation, BookingFile result, String airlineCode) throws Exception {
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        result.getTravellers().add(traveller);
        Product product = new Product();
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setTraveller(traveller);
        product.setProductCategory(ProductCategory.AIR);
        product.setBlankOwnerRef(this.findBlankOwnerByCode("\u04281"));
        product.setBlankOwnerNumber("99A");
        product.setStatus(ProductStatus.SELL);
        product.setCarrier((DictionaryReference)new AirlineReference(airlineCode));
        product.setCarrierNumber(airlineCode);
        product.setBlankType((DictionaryReference)new BlankTypeReference("99A 661"));
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyContainer.toReference());
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        result.setAgency(new EntityReference(this.agencyContainer));
        product.setTicketType(TicketType.OWN);
        product.setTariffType(TariffType.REGULAR);
        product.setCashier(this.agent);
        product.setValidatorCode("12345678");
        Segment segment = new Segment();
        segment.setStartDate(Calendar.getInstance().getTime());
        segment.setAirline((DictionaryReference)new AirlineReference(airlineCode));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("testCityCode1"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("testCityCode2"));
        segment.setFareBasis("farebasis");
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        Money money = new Money();
        money.setValue(BigDecimal.valueOf(1000.0));
        money.setCurrency("RUB");
        AirProductHelper.setBaseFare((Product)product, (Money)money);
        Tax tax = new Tax();
        tax.setCode("TTcode");
        tax.setAmount(SystemHelper.getMoney((double)100.0, (String)"RUB"));
        tax.setEquivalentAmount(BigDecimal.valueOf(100.0));
        product.getTaxes().add(tax);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.valueOf(1000.0));
        product.setIssueDate(this.issueDate);
        ProductFop fop = new ProductFop();
        fop.setType(PaymentType.CASH);
        fop.setAmount(SystemHelper.getMoney((double)1000.0, (String)"RUB"));
        fop.setOperationDate(this.issueDate);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        fop = new ProductFop();
        fop.setCard(new Card());
        fop.getCard().setVendor(CardVendor.VISA);
        fop.setType(PaymentType.CREDIT_CARD);
        fop.setAmount(SystemHelper.getMoney((double)100.0, (String)"RUB"));
        fop.setOperationDate(this.issueDate);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setSystemNumber(airlineCode);
        return product;
    }

    private void createProfiles() throws Exception {
        EntityContainer commPercent = new EntityContainer(CommissionProperties.class);
        ((CommissionProperties)commPercent.getEntity()).setDisplayName("Commission %");
        ((CommissionProperties)commPercent.getEntity()).setRate(true);
        ((CommissionProperties)commPercent.getEntity()).setRoundingMode(RoundingMode.NONE);
        ((CommissionProperties)commPercent.getEntity()).setRate(true);
        EntityStorage.get().save(commPercent, false);
        String user = LogicalStorage.get().getUser();
        EntityStorage es = EntityStorage.get();
        this.agencyContainer = new EntityContainer(Organization.class);
        this.agencyContainer.setCreatedBy(user);
        this.agencyContainer.setModifiedBy(user);
        Organization agency = (Organization)this.agencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"testAgency", (Locale)Locale.ENGLISH);
        agency.setActive(true);
        agency.setCode("testAgency");
        es.save(this.agencyContainer, true);
        this.agentContainer = new EntityContainer(Person.class);
        this.agentContainer.setCreatedBy(user);
        this.agentContainer.setModifiedBy(user);
        Person agent = (Person)this.agentContainer.getEntity();
        agent.setCode("testAgent");
        agent.setLoginName(user);
        es.save(this.agentContainer, true);
        this.clientContainer = new EntityContainer(Organization.class);
        this.clientContainer.setCreatedBy(user);
        this.clientContainer.setModifiedBy(user);
        Organization client = (Organization)this.agencyContainer.getEntity();
        L10nStringHelper.setValue((L10nString)client.getShortName(), (String)"testClient", (Locale)Locale.ENGLISH);
        client.setActive(true);
        client.setCode("testClient");
        es.save(this.clientContainer, true);
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        cc.setCreatedBy(user);
        cc.setModifiedBy(user);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(this.tchReference);
        info.setCustomer(new EntityReference(this.agencyContainer));
        contract.setVendor(this.tchReference);
        info.setNumber("01");
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("A1");
        RuleRestriction restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)"TCH");
        rs.getRestrictions().add(restr);
        RuleResult res = new RuleResult();
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(commPercent.toReference());
        value.setValue(10.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        es.save(cc, true);
    }
}

