/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;

public class CreditSalesReportTest
extends TchSalesReportTestBase {
    @Test
    public void testReport() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        this.createProduct("001", 0, "testAirlineCode2", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, "026");
        this.createProduct("002", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, null, PaymentType.CREDIT, ProductCategory.AIR, null, false, "027");
        this.createProduct("003", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, null, PaymentType.CREDIT, ProductCategory.AIR, null, true, "027");
        String productUid = this.createProduct("004", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, true, "027");
        ProductSearchResult psr = BookingDao.findProductByUid((String)productUid);
        Product product = (Product)psr.getProduct();
        product.setContractRulesApplied(false);
        ProductFop fop1 = (ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(0);
        fop1.getAmount().setValue(BigDecimal.valueOf(200L));
        fop1.setType(PaymentType.CREDIT);
        ProductFop fop2 = (ProductFop)XCloneHelper.clone((XCloneable)fop1, (boolean)true);
        fop2.setType(PaymentType.CASH);
        fop2.getAmount().setValue(BigDecimal.valueOf(100L));
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop2);
        EntityStorage.get().save(psr.getContainer(), true);
        File outFile = new File(this.getOutFolder(), "CreditSalesReportTest.xls");
        this.createReport(outFile);
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("CreditSalesReportTest.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

