/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTest;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class EticketsTest
extends TchSalesReportTest {
    @Override
    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("tchSalesReportTestDictionaries.xml");
    }

    @Override
    @Test
    public void testReport() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        this.createProduct("001", ProductStatus.SELL, null, 100.0, PaymentType.CASH, PaymentType.CREDIT_CARD, ProductCategory.AIR, null, true);
        this.createProduct("004", ProductStatus.VOID, null, 100.0, PaymentType.CREDIT_CARD, null, ProductCategory.AIR, null, true);
        this.createProduct("002", ProductStatus.SELL, null, 100.0, PaymentType.CASH, null, ProductCategory.AIR, null, true);
        String prodUid = this.createProduct("003", ProductStatus.SELL, null, 100.0, PaymentType.CASH, null, ProductCategory.AIR, null, true);
        String refUid = this.createProduct("003", ProductStatus.REFUND, prodUid, 100.0, PaymentType.CASH, null, ProductCategory.AIR, null, true);
        this.createProduct("004", ProductStatus.SELL, refUid, 100.0, PaymentType.CASH, null, ProductCategory.MCO, MCOCategory.PENALTY, false);
        this.createProduct("005", ProductStatus.SELL, refUid, 0.0, PaymentType.CASH, null, ProductCategory.MCO, MCOCategory.INFORMATION, false);
        File outFile = new File(this.getOutFolder(), "eticketsTest.xls");
        this.createReport(outFile);
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("eticketsTest.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    protected String createProduct(String ticketNo, ProductStatus status, String relUid, double fare, PaymentType paymentType1, PaymentType paymentType2, ProductCategory productCategory, MCOCategory mcoCategory, boolean eticket) throws Exception {
        Card card;
        EntityContainer bfc = null;
        Product product = null;
        if (!TextUtil.isBlank((String)relUid)) {
            ProductSearchResult searchResult = BookingDao.findProductByUid((String)relUid);
            bfc = searchResult.getContainer();
            Reservation reservation = searchResult.getReservation();
            product = new Product();
            reservation.getProducts().add(product);
            product.setTicketType(TicketType.OWN);
            product.setTariffType(TariffType.REGULAR);
            product.setValidatorCode("12345678");
            product.setReservation(reservation);
            Product relatedProduct = (Product)searchResult.getProduct();
            if (productCategory == ProductCategory.AIR) {
                product.setPreviousProduct(relatedProduct);
            } else {
                product.getRelatedProducts().add(relatedProduct);
            }
        } else {
            bfc = new EntityContainer(BookingFile.class);
            String user = LogicalStorage.get().getUser();
            bfc.setCreated(new Date());
            bfc.setCreatedBy(user);
            bfc.setModified(new Date());
            bfc.setModifiedBy(user);
            BookingFile bf = (BookingFile)bfc.getEntity();
            Reservation reservation = new Reservation();
            bf.getReservations().add(reservation);
            reservation.setBookingFile(bf);
            product = new Product();
            reservation.getProducts().add(product);
            product.setTicketType(TicketType.OWN);
            product.setTariffType(TariffType.REGULAR);
            product.setValidatorCode("12345678");
            product.setReservation(reservation);
        }
        BookingFile bf = (BookingFile)bfc.getEntity();
        bf.setCustomerProfile(this.clientContainer.toReference());
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        bf.getTravellers().add(traveller);
        product.setTraveller(traveller);
        product.setBlankOwnerRef(this.tchReference);
        product.setStatus(ProductStatus.SELL);
        product.setCarrier((DictionaryReference)new AirlineReference("testAirlineCode2"));
        bf.setAgency(new EntityReference(this.agencyContainer));
        product.setProductCategory(productCategory);
        product.setMcoCategory(mcoCategory);
        product.setEticket(eticket);
        product.setCashier(this.agent);
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyContainer.toReference());
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        product.setBlankType((DictionaryReference)new BlankTypeReference(eticket ? "99A \u042d61" : "99A 661"));
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(BigDecimal.valueOf(fare));
        AirProductHelper.setBaseFare((Product)product, (Money)money);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.valueOf(fare));
        Tax tax = new Tax();
        tax.setCode("ZZ");
        tax.setEquivalentAmount(BigDecimal.valueOf(fare));
        product.getTaxes().add(tax);
        product.setStatus(status);
        product.setSystemNumber(ticketNo);
        product.setConjCount(0);
        product.getScns().add(ticketNo);
        product.setIssueDate(this.issueDate);
        product.setCarrierNumber("026");
        Segment segment = new Segment();
        segment.setStartDate(this.issueDate);
        segment.setAirline((DictionaryReference)new AirlineReference("testAirlineCode2"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("testCityCode1"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("testCityCode2"));
        segment.setFareBasis("farebasis");
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        segment = new Segment();
        segment.setStartDate(this.issueDate);
        segment.setAirline((DictionaryReference)new AirlineReference("testAirlineCode2"));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("testCityCode2"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("testCityCode1"));
        segment.setFareBasis("farebasis");
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        ProductFop pt = new ProductFop();
        pt.setType(paymentType1);
        pt.setOperationDate(this.issueDate);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(pt);
        if (paymentType1.equals((Object)PaymentType.CREDIT_CARD)) {
            card = new Card();
            card.setVendor(CardVendor.AMEX);
            pt.setCard(card);
        }
        Money money2 = new Money();
        money2.setCurrency("RUB");
        money2.setValue(BigDecimal.valueOf(paymentType2 != null ? fare : 2.0 * fare));
        pt.setAmount(money2);
        if (paymentType2 != null) {
            pt.getFares().addAll(product.getFares());
        }
        if (paymentType2 != null) {
            pt = new ProductFop();
            pt.setType(paymentType2);
            pt.setOperationDate(this.issueDate);
            AirProductHelper.getVendorContractRelation((Product)product).getFops().add(pt);
            if (paymentType2.equals((Object)PaymentType.CREDIT_CARD)) {
                card = new Card();
                card.setVendor(CardVendor.AMEX);
                pt.setCard(card);
            }
            money2 = new Money();
            money2.setCurrency("RUB");
            money2.setValue(BigDecimal.valueOf(fare));
            pt.setAmount(money2);
            pt.getTaxes().addAll(product.getTaxes());
        }
        EntityStorage.get().save(bfc, false);
        return product.getUid();
    }
}

