/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;

public class PTATicketsReportTest
extends TchSalesReportTestBase {
    @Test
    public void testExchangedPTA() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        String sellUid = this.createProduct("001", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.PTA, ProductCategory.AIR, null, false, "027");
        String exchangeUid = this.createProduct("001", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.EXCHANGE, sellUid, PaymentType.PTA, ProductCategory.AIR, null, false, "027");
        String sell2Uid = this.createProduct("002", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, exchangeUid, PaymentType.TICKET, ProductCategory.AIR, null, false, "027");
        ProductSearchResult searchResult = BookingDao.findProductByUid((String)sell2Uid);
        Product sell2 = (Product)searchResult.getProduct();
        ((ProductFop)AirProductHelper.getVendorContractRelation((Product)sell2).getFops().get(0)).getAmount().setValue(AirProductHelper.getEquivalentFare((Product)sell2).subtract(BigDecimal.valueOf(100L)).add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)sell2)));
        ProductFop fop = new ProductFop();
        fop.setAmount(SystemHelper.getMoney((double)100.0, (String)"RUB"));
        fop.setType(PaymentType.CASH);
        fop.setOperationDate(sell2.getIssueDate());
        AirProductHelper.getVendorContractRelation((Product)sell2).getFops().add(fop);
        EntityStorage.get().save(searchResult.getContainer(), false);
        File outFile = new File(this.getOutFolder(), "PTAExchangedTicketsReportTest.xls");
        this.createReport(outFile);
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("PTAExchangedTicketsReportTest.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

