/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class PenaltyOnTicketTest
extends TchSalesReportTestBase {
    private final String airlineNumber1 = "026";

    @Test
    public void testReport() throws Exception {
        this.issueDate = this.df.parse("2015-02-02");
        this.createProfiles();
        String sellUid = this.createProduct("0001", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, true, "026");
        String refundUid = this.createProduct("0001", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.REFUND, sellUid, PaymentType.CASH, ProductCategory.AIR, null, true, "026");
        EntityContainer bookingCtr = BookingDao.findProductByUid((String)refundUid).getContainer();
        Product refund = (Product)BookingHelper.findProduct((BookingFile)((BookingFile)bookingCtr.getEntity()), (String)refundUid);
        refund.setPenalty(BigDecimal.valueOf(50L));
        AirProductHelper.updateFops((Product)refund);
        refund.setContractRulesApplied(false);
        EntityStorage.get().save(bookingCtr, true);
        File outFile = new File(this.getOutFolder(), "penaltyOnTicket.xls");
        Date startDate = this.df.parse("2015-02-01");
        Date endDate = this.df.parse("2015-02-10");
        this.createReport(startDate, endDate, outFile);
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("testdata/penaltyOnTicket.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

