/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class TchSalesReportDirectContractTest
extends TchSalesReportTestBase {
    @Test
    public void testDirectContractsReport() throws Exception {
        this.issueDate = this.df.parse("2014-01-02");
        this.createProfiles();
        String productUid = null;
        productUid = this.createProduct("0001", 0, this.directAirline.getCode(), (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, true, ((Airline)DictionaryCache.get().resolveReference(this.directAirline)).getAirlineNumber());
        ProductSearchResult searchResult = BookingDao.findProductByUid((String)productUid);
        Product prod = (Product)searchResult.getProduct();
        ((Tax)prod.getTaxes().get(0)).setAmount(SystemHelper.getMoney((double)50.0, (String)"RUB"));
        ((Tax)prod.getTaxes().get(0)).setEquivalentAmount(BigDecimal.valueOf(50L));
        Tax tax = new Tax();
        tax.setCode("YQ");
        tax.setAmount(SystemHelper.getMoney((double)50.0, (String)"RUB"));
        tax.setEquivalentAmount(BigDecimal.valueOf(50L));
        prod.getTaxes().add(tax);
        EntityStorage.get().save(searchResult.getContainer(), true);
        this.issueDate = this.df.parse("2014-02-02");
        productUid = this.createProduct("0001", 0, this.directAirline.getCode(), (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.REFUND, productUid, PaymentType.CASH, ProductCategory.AIR, null, true, ((Airline)DictionaryCache.get().resolveReference(this.directAirline)).getAirlineNumber());
        searchResult = BookingDao.findProductByUid((String)productUid);
        prod = (Product)searchResult.getProduct();
        ((Tax)prod.getTaxes().get(0)).setAmount(SystemHelper.getMoney((double)50.0, (String)"RUB"));
        ((Tax)prod.getTaxes().get(0)).setEquivalentAmount(BigDecimal.valueOf(50L));
        tax = new Tax();
        tax.setCode("YQ");
        tax.setAmount(SystemHelper.getMoney((double)50.0, (String)"RUB"));
        tax.setEquivalentAmount(BigDecimal.valueOf(50L));
        prod.getTaxes().add(tax);
        EntityStorage.get().save(searchResult.getContainer(), true);
        File outFile = new File(this.getOutFolder(), "tchSellDirectContractTest.xls");
        Date startDate = this.df.parse("2014-01-01");
        Date endDate = this.df.parse("2014-01-10");
        this.createReport(startDate, endDate, outFile);
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("testdata/tchSellDirectContractTest.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
        outFile = new File(this.getOutFolder(), "tchRefundDirectContractTest.xls");
        startDate = this.df.parse("2014-02-01");
        endDate = this.df.parse("2014-02-10");
        this.createReport(startDate, endDate, outFile);
        res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("testdata/tchRefundDirectContractTest.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

