/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;

public class TchSalesReportTest
extends TchSalesReportTestBase {
    private final double fare1 = 100.0;
    private final double fare2 = 200.0;
    private final double fare3 = 300.0;
    private final double fare4 = 400.0;
    private final String airlineNumber1 = "026";
    private final String airlineNumber2 = "027";
    private static final String TICKET_NO_FIRST_SELL = "004";
    private static final String TICKET_NO_SELL_EXCHANGE = "051";
    private static final String TICKET_NO_SECOND_SELL = "052";
    private static final String TICKET_NO_SIMPLE_SELL_1 = "001";
    private static final String TICKET_NO_SELL_REFUND = "002";
    private static final String TICKET_NO_VOID = "003";
    private static final String TICKET_SELL_CC = "006";
    private static final String MCO_PENALTY = "007";
    private static final String MCO_REFERENCE = "008";
    private static final String TICKET_NO_PTA = "009";
    private static final String TICKET_ETICKET = "010";
    private static final String EMCO_PENALTY = "015";
    private static final String EMCO_REFERENCE = "016";
    private static final String TICKET_CONJUNCTION = "011";
    private static final String MTD_NO = "017";

    @Test
    public void testReport() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2008-02-01");
        this.createProfiles();
        this.createProduct(TICKET_NO_SIMPLE_SELL_1, 0, "testAirlineCode2", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, "027");
        this.createProduct("0012", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, "026");
        String pr2 = this.createProduct(TICKET_NO_SELL_REFUND, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, "026");
        String refundUid = this.createProduct(TICKET_NO_SELL_REFUND, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.REFUND, pr2, PaymentType.CASH, ProductCategory.AIR, null, false, "026");
        this.createProduct(MCO_PENALTY, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, refundUid, PaymentType.CASH, ProductCategory.MCO, MCOCategory.PENALTY, false, "026");
        this.createProduct(MCO_REFERENCE, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 200.0, ProductStatus.SELL, refundUid, PaymentType.CASH, ProductCategory.MCO, MCOCategory.INFORMATION, false, "026");
        this.createProduct(TICKET_NO_VOID, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.VOID, null, PaymentType.CASH, ProductCategory.AIR, null, false, "026");
        this.createProduct(TICKET_NO_PTA, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.PTA, ProductCategory.AIR, null, false, "026");
        pr2 = this.createProduct(TICKET_ETICKET, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CREDIT_CARD, ProductCategory.AIR, null, true, "026");
        refundUid = this.createProduct(TICKET_ETICKET, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.REFUND, pr2, PaymentType.CREDIT_CARD, ProductCategory.AIR, null, true, "026");
        this.createProduct(EMCO_PENALTY, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, refundUid, PaymentType.CASH, ProductCategory.MCO, MCOCategory.PENALTY, false, "026");
        this.createProduct(EMCO_REFERENCE, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, refundUid, PaymentType.CASH, ProductCategory.MCO, MCOCategory.INFORMATION, false, "026");
        String pr4 = this.createProduct(TICKET_NO_FIRST_SELL, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 300.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, "026");
        String pr5 = this.createProduct(TICKET_NO_SELL_EXCHANGE, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 300.0, ProductStatus.EXCHANGE, pr4, PaymentType.CASH, ProductCategory.AIR, null, false, "026");
        this.createProduct(TICKET_NO_SECOND_SELL, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 400.0, ProductStatus.SELL, pr5, PaymentType.CASH, ProductCategory.AIR, null, false, "026");
        this.createProduct(TICKET_SELL_CC, 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 400.0, ProductStatus.SELL, null, PaymentType.CREDIT_CARD, ProductCategory.AIR, null, false, "026");
        this.createProduct("0062", 0, "testAirlineCode2", (EntityReference<Organization>)this.tchReference, 400.0, ProductStatus.SELL, null, PaymentType.CREDIT_CARD, ProductCategory.AIR, null, false, "027");
        this.createProduct(TICKET_CONJUNCTION, 1, "testAirlineCode2", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, false, "027");
        this.createSubsidizedProduct(MTD_NO, "SU", 100.0, ProductStatus.SELL, null, null, true, "VVO", "SU", "SU");
        String productUid = this.createProduct(MTD_NO, 0, "testAirlineCode2", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CREDIT, ProductCategory.AIR, null, false, "027");
        ProductSearchResult psr = BookingDao.findProductByUid((String)productUid);
        Product product = (Product)psr.getProduct();
        ProductFop fop1 = (ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(0);
        fop1.setType(PaymentType.CREDIT);
        fop1.setRelatedTicketNumber("7654567");
        EntityStorage.get().save(psr.getContainer(), true);
        this.createAgencyMemoProduct("4001", "026", AgencyMemoProductEntryType.TARIFF, 100.0);
        File outFile = new File(this.getOutFolder(), "tchSalesReportTest.xls");
        this.createReport(outFile);
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("tchSalesReportTest.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

