/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TchCreditCardAccompanyingDocumentType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntry;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryAssociationType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductRelatedProductGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.TchDirectContract;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchSubsidizedReportRegistryRenderHandler;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.prepare.salesreports.tch.TchSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.junit.Assert;

abstract class TchSalesReportTestBase
extends RenderSalesReportTestBase {
    protected EntityContainer<Organization> agencyContainer;
    protected EntityContainer<Organization> clientContainer;
    protected EntityContainer<Person> agentContainer;
    protected Date issueDate;
    protected final String airlineCode2 = "testAirlineCode2";
    protected final String airlineCode1 = "testAirlineCode1";
    protected final DictionaryReference<Airline> directAirline = new AirlineReference("TD");
    protected final double rate1 = 10.0;
    protected final double rate2 = 20.0;
    protected final double rate3 = 30.0;
    protected EntityReference<SalesPoint> spRef;
    protected SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    protected TchCreditCardAccompanyingDocumentType ccAccompanyingDocumentType = null;

    TchSalesReportTestBase() {
    }

    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("tchSalesReportTestDictionaries.xml");
    }

    protected void createReport(File ... outFiles) throws Exception {
        Calendar cl = Calendar.getInstance();
        cl.setTime(this.issueDate);
        cl.add(1, -1);
        Date startDate = cl.getTime();
        cl.add(1, 2);
        Date endDate = cl.getTime();
        this.createReport(startDate, endDate, outFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createReport(Date startDate, Date endDate, File ... outFiles) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ReportParameters params = new ReportParameters();
        params.setPeriodBegin(startDate);
        params.setPeriodEnd(endDate);
        params.setAgency(new EntityReference(this.agencyContainer));
        params.setBlankOwner(this.tchReference);
        data.put("key-report-params", params);
        TchSalesReportPrepareHandler prepareHandler = new TchSalesReportPrepareHandler();
        prepareHandler.prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage()), (boolean)true);
        }
        TestTchReportRenderHandler renderHandler = new TestTchReportRenderHandler();
        EntityContainer renderReport = renderHandler.renderReport(data);
        List files = ((ReportDocument)renderReport.getEntity()).getFiles();
        for (int n = 0; n < files.size(); ++n) {
            if (n >= outFiles.length) {
                return;
            }
            File fileName = outFiles[n];
            try (FileOutputStream os = new FileOutputStream(fileName);){
                os.write(((ReportFile)files.get(n)).getContent());
                continue;
            }
        }
    }

    protected String createProduct(String ticketNo, int conj, String airline, EntityReference<Organization> blOwner, double fare, ProductStatus status, String relUid, PaymentType paymentType, ProductCategory productCategory, MCOCategory mcoCategory, boolean eticket, String airlineNumber) throws Exception {
        EntityContainer bfc = null;
        Product product = null;
        if (!TextUtil.isBlank((String)relUid)) {
            ProductSearchResult searchResult = BookingDao.findProductByUid((String)relUid);
            bfc = searchResult.getContainer();
            Reservation reservation = searchResult.getReservation();
            product = new Product();
            reservation.getProducts().add(product);
            product.setReservation(reservation);
            product.setTicketType(TicketType.OWN);
            product.setTariffType(TariffType.REGULAR);
            product.setValidatorCode("12345678");
            Product relatedProduct = (Product)searchResult.getProduct();
            if (productCategory == ProductCategory.AIR) {
                product.setPreviousProduct(relatedProduct);
            } else {
                product.getRelatedProducts().add(relatedProduct);
            }
        } else {
            bfc = new EntityContainer(BookingFile.class);
            String user = LogicalStorage.get().getUser();
            bfc.setCreated(new Date());
            bfc.setCreatedBy(user);
            bfc.setModified(new Date());
            bfc.setModifiedBy(user);
            BookingFile bf = (BookingFile)bfc.getEntity();
            Reservation reservation = new Reservation();
            bf.getReservations().add(reservation);
            reservation.setBookingFile(bf);
            product = new Product();
            reservation.getProducts().add(product);
            product.setReservation(reservation);
            product.setTicketType(TicketType.OWN);
            product.setTariffType(TariffType.REGULAR);
            product.setValidatorCode("12345678");
        }
        BookingFile bf = (BookingFile)bfc.getEntity();
        bf.setAgency(this.agencyContainer.toReference());
        bf.setCustomerProfile(this.clientContainer.toReference());
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        bf.getTravellers().add(traveller);
        product.setTraveller(traveller);
        product.setBlankOwnerRef(blOwner);
        product.setBlankOwnerNumber("99A");
        product.setStatus(ProductStatus.SELL);
        product.setCarrier((DictionaryReference)new AirlineReference(airline));
        bf.setAgency(new EntityReference(this.agencyContainer));
        product.setProductCategory(productCategory);
        product.setMcoCategory(mcoCategory);
        product.setEticket(eticket);
        product.setBlankType((DictionaryReference)new BlankTypeReference(eticket ? "99A \u042d61" : "99A 661"));
        product.setCashier(this.agent);
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(BigDecimal.valueOf(fare));
        AirProductHelper.setBaseFare((Product)product, (Money)money);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.valueOf(fare));
        double taxAmount = 100.0;
        Tax tax = new Tax();
        tax.setCode("ZZ");
        tax.setEquivalentAmount(BigDecimal.valueOf(taxAmount));
        product.getTaxes().add(tax);
        product.setStatus(status);
        product.setSystemNumber(ticketNo);
        product.setConjCount(conj);
        product.getScns().add(ticketNo);
        product.setIssueDate(this.issueDate);
        product.setCarrierNumber(airlineNumber);
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyContainer.toReference());
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        Segment segment = new Segment();
        segment.setStartDate(this.issueDate);
        segment.setAirline((DictionaryReference)new AirlineReference(airline));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("testCityCode1"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("testCityCode2"));
        segment.setFareBasis("farebasis");
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        segment = new Segment();
        segment.setStartDate(this.issueDate);
        segment.setAirline((DictionaryReference)new AirlineReference(airline));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("testCityCode2"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("testCityCode1"));
        segment.setFareBasis("farebasis");
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        if (product.getStatus() != ProductStatus.VOID) {
            List vendorFops = AirProductHelper.getVendorContractRelation((Product)product).getFops();
            List clientFops = AirProductHelper.getClientContractRelation((Product)product).getFops();
            ProductFop vendorFOP = new ProductFop();
            vendorFops.add(vendorFOP);
            vendorFOP.setOperationDate(this.issueDate);
            vendorFOP.setType(paymentType);
            ProductFop clientFOP = new ProductFop();
            clientFops.add(clientFOP);
            clientFOP.setOperationDate(this.issueDate);
            clientFOP.setType(paymentType);
            clientFOP.setAgent(new EntityReference("testUid", Person.class, "testAgent"));
            if (paymentType.equals((Object)PaymentType.CREDIT_CARD) || paymentType.equals((Object)PaymentType.CREDIT_CARD_TCH)) {
                Card card = new Card();
                card.setVendor(CardVendor.AMEX);
                vendorFOP.setCard(card);
                vendorFOP.setTchCCAccompanyingDocumentType(this.ccAccompanyingDocumentType);
                card = new Card();
                card.setVendor(CardVendor.AMEX);
                clientFOP.setCard(card);
            }
            Money money2 = new Money();
            money2.setCurrency("RUB");
            money2.setValue(BigDecimal.valueOf(fare + taxAmount));
            vendorFOP.setAmount(money2);
            money2 = new Money();
            money2.setCurrency("RUB");
            money2.setValue(BigDecimal.valueOf(fare + taxAmount));
            clientFOP.setAmount(money2);
        }
        EntityStorage.get().save(bfc, false);
        return product.getUid();
    }

    protected String createSubsidizedProduct(String ticketNo, String validaingCarrier, double fare, ProductStatus status, String relUid, MCOCategory mcoCategory, boolean eticket, String city, String firstSegmentAirline, String lastSegmentAirline) throws Exception {
        EntityContainer bfc = null;
        Product product = null;
        if (!TextUtil.isBlank((String)relUid)) {
            ProductSearchResult searchResult = BookingDao.findProductByUid((String)relUid);
            bfc = searchResult.getContainer();
            Reservation reservation = searchResult.getReservation();
            product = new Product();
            reservation.getProducts().add(product);
            product.setReservation(reservation);
            product.setTicketType(TicketType.OWN);
            product.setTariffType(TariffType.REGULAR);
            product.setValidatorCode("12345678");
            Product relatedProduct = (Product)searchResult.getProduct();
            if (mcoCategory == null) {
                product.setPreviousProduct(relatedProduct);
            } else {
                product.getRelatedProducts().add(relatedProduct);
            }
        } else {
            bfc = new EntityContainer(BookingFile.class);
            String user = LogicalStorage.get().getUser();
            bfc.setCreated(new Date());
            bfc.setCreatedBy(user);
            bfc.setModified(new Date());
            bfc.setModifiedBy(user);
            BookingFile bf = (BookingFile)bfc.getEntity();
            Reservation reservation = new Reservation();
            bf.getReservations().add(reservation);
            reservation.setBookingFile(bf);
            product = new Product();
            product.setTicketType(TicketType.OWN);
            product.setTariffType(TariffType.REGULAR);
            product.setValidatorCode("12345678");
            reservation.getProducts().add(product);
            product.setReservation(reservation);
        }
        BookingFile bf = (BookingFile)bfc.getEntity();
        bf.setCustomerProfile(this.clientContainer.toReference());
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        product.setPassengerType(DictHelper.getAdultPassengerType());
        traveller.setBirthday(this.df.parse("1990-01-01"));
        traveller.setGender(Gender.MALE);
        Passport passport = new Passport();
        passport.setNumber("00001");
        traveller.setPassport(passport);
        bf.getTravellers().add(traveller);
        product.setTraveller(traveller);
        product.setBlankOwnerRef(this.tchReference);
        product.setBlankOwnerNumber("99A");
        product.setStatus(ProductStatus.SELL);
        product.setCarrier((DictionaryReference)new AirlineReference(validaingCarrier));
        product.setSubsidizedTariff(true);
        product.setSalesPoint(this.spRef);
        bf.setAgency(new EntityReference(this.agencyContainer));
        product.setProductCategory(mcoCategory == null ? ProductCategory.AIR : ProductCategory.MCO);
        product.setMcoCategory(mcoCategory);
        product.setEticket(eticket);
        product.setCashier(this.agent);
        product.setBlankType((DictionaryReference)new BlankTypeReference(eticket ? "99A \u042d61" : "99A 661"));
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(BigDecimal.valueOf(fare));
        AirProductHelper.setBaseFare((Product)product, (Money)money);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.valueOf(fare));
        double taxAmount = 100.0;
        Tax tax = new Tax();
        tax.setCode("ZZ");
        tax.setEquivalentAmount(BigDecimal.valueOf(taxAmount));
        product.getTaxes().add(tax);
        product.setStatus(status);
        product.setSystemNumber(ticketNo);
        product.getScns().add(ticketNo);
        product.setIssueDate(this.issueDate);
        product.setCarrierNumber(((Airline)DictionaryCache.get().resolveReference((DictionaryReference)new AirlineReference(validaingCarrier))).getAirlineNumber());
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyContainer.toReference());
        AirProductHelper.setSupplier((Product)product, (EntityReference)product.getBlankOwnerRef());
        ProductFop vendorFOP = new ProductFop();
        List vendorFops = AirProductHelper.getVendorContractRelation((Product)product).getFops();
        List clientFops = AirProductHelper.getClientContractRelation((Product)product).getFops();
        vendorFops.add(vendorFOP);
        vendorFOP.setOperationDate(this.issueDate);
        vendorFOP.setType(PaymentType.CASH);
        ProductFop clientFOP = new ProductFop();
        clientFops.add(clientFOP);
        clientFOP.setOperationDate(this.issueDate);
        clientFOP.setType(PaymentType.CASH);
        clientFOP.setAgent(new EntityReference("testUid", Person.class, "testAgent"));
        Segment segment = new Segment();
        segment.setStartDate(this.issueDate);
        segment.setAirline((DictionaryReference)new AirlineReference(firstSegmentAirline));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("airport DME"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference(city));
        segment.setFareBasis("farebasis");
        segment.setStartDate(this.df.parse("2012-01-01"));
        segment.setFlightNo("422");
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(fare).divide(BigDecimal.valueOf(2L), 2, java.math.RoundingMode.HALF_UP));
        segment = new Segment();
        segment.setStartDate(this.issueDate);
        segment.setAirline((DictionaryReference)new AirlineReference(lastSegmentAirline));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference(city));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("airport DME"));
        segment.setFareBasis("farebasis");
        segment.setStartDate(this.df.parse("2012-01-02"));
        segment.setFlightNo("423");
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        AirProductHelper.setSegmentEquivalentFare((Product)product, (SegmentTariff)sppPsgr, (BigDecimal)BigDecimal.valueOf(fare).subtract(BigDecimal.valueOf(fare).divide(BigDecimal.valueOf(2L), 2, java.math.RoundingMode.HALF_UP)));
        Money money2 = new Money();
        money2.setCurrency("RUB");
        money2.setValue(BigDecimal.valueOf(fare + taxAmount));
        vendorFOP.setAmount(money2);
        money2 = new Money();
        money2.setCurrency("RUB");
        money2.setValue(BigDecimal.valueOf(fare + taxAmount));
        clientFOP.setAmount(money2);
        EntityStorage.get().save(bfc, false);
        product.setSubsidizedTariff(true);
        EntityStorage.get().save(bfc, false);
        return product.getUid();
    }

    protected void createProfiles() throws Exception {
        EntityContainer commPercent = new EntityContainer(CommissionProperties.class);
        ((CommissionProperties)commPercent.getEntity()).setDisplayName("Commission %");
        ((CommissionProperties)commPercent.getEntity()).setRate(true);
        ((CommissionProperties)commPercent.getEntity()).setRoundingMode(RoundingMode.NONE);
        ((CommissionProperties)commPercent.getEntity()).setRate(true);
        EntityStorage.get().save(commPercent, false);
        String user = LogicalStorage.get().getUser();
        EntityContainer ctr = EntityStorage.get().resolve(new EntityReference("test_accountant_container_uid", Person.class, null));
        L10nStringHelper.setValue((L10nString)((Person)ctr.getEntity()).getLastName(), (String)"Ivanov", (Locale)Locale.ROOT);
        L10nStringHelper.setValue((L10nString)((Person)ctr.getEntity()).getLastName(), (String)"Ivanov", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)((Person)ctr.getEntity()).getFirstName(), (String)"Ivan", (Locale)Locale.ROOT);
        L10nStringHelper.setValue((L10nString)((Person)ctr.getEntity()).getMiddleName(), (String)"Ivanovich", (Locale)Locale.ROOT);
        EntityStorage.get().save(ctr, false);
        ctr = EntityStorage.get().resolve(new EntityReference("test_director_container_uid", Person.class, null));
        L10nStringHelper.setValue((L10nString)((Person)ctr.getEntity()).getLastName(), (String)"Petrov", (Locale)Locale.ROOT);
        L10nStringHelper.setValue((L10nString)((Person)ctr.getEntity()).getFirstName(), (String)"Petr", (Locale)Locale.ROOT);
        L10nStringHelper.setValue((L10nString)((Person)ctr.getEntity()).getMiddleName(), (String)"Petrovich", (Locale)Locale.ROOT);
        EntityStorage.get().save(ctr, false);
        EntityStorage es = EntityStorage.get();
        this.agentContainer = new EntityContainer(Person.class);
        this.agentContainer.setCreatedBy(user);
        this.agentContainer.setModifiedBy(user);
        Person agent = (Person)this.agentContainer.getEntity();
        agent.setUid("Test uid");
        agent.setCode("testAgent");
        agent.setLoginName(user);
        es.save(this.agentContainer, true);
        this.agencyContainer = es.load(Organization.class, "test_agency_container_uid");
        this.clientContainer = es.load(Organization.class, "test_client_container_uid");
        EntityContainer<SalesPoint> spCtr = this.createSalesPoint("001", "Main SP", "Main SP", (EntityReference<Organization>)this.agencyContainer.toReference(), null, null, null);
        Address address = new Address();
        address.setAddressType(AddressType.FACTUAL);
        address.setCity((DictionaryReference)new GeoLocationReference("MOW"));
        ((SalesPoint)spCtr.getEntity()).getAddresses().add(address);
        EntityStorage.get().save(spCtr, false);
        this.spRef = spCtr.toReference();
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        cc.setCreatedBy(user);
        cc.setModifiedBy(user);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(this.tchReference);
        info.setCustomer(new EntityReference(this.agencyContainer));
        contract.setVendor(this.tchReference);
        info.setNumber("01");
        TchDirectContract directContract = new TchDirectContract();
        directContract.setAirline(this.directAirline);
        directContract.setContractNumber("001");
        info.getTchDirectContracts().add(directContract);
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("fare1");
        RuleRestriction restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.AIRLINES);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)"testAirlineCode1");
        rs.getRestrictions().add(restr);
        RuleResult res = new RuleResult();
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(commPercent.toReference());
        value.setValue(10.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("fare2");
        restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.AIRLINES);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)"testAirlineCode2");
        rs.getRestrictions().add(restr);
        res = new RuleResult();
        value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(commPercent.toReference());
        value.setValue(20.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("fare3");
        restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.AIRLINES);
        restr.setCondition((RuleCondition)Conditions.INCLUDE);
        restr.setValue((Object)this.directAirline.getCode());
        rs.getRestrictions().add(restr);
        res = new RuleResult();
        value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(commPercent.toReference());
        value.setValue(30.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        es.save(cc, true);
    }

    protected AgencyMemoProduct createAgencyMemoProduct(String systemNumber, String airlineNumber, AgencyMemoProductEntryType entryType, double value) throws Exception {
        EntityContainer bookingFileContainer = new EntityContainer(BookingFile.class);
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        bookingFile.setAgency(this.agencyContainer.toReference());
        Reservation reservation = new Reservation();
        this.setRecordLocator(reservation, "testPnr");
        reservation.setBookingFile(bookingFile);
        AgencyMemoProduct agencyMemoProduct = new AgencyMemoProduct();
        agencyMemoProduct.setReservation(reservation);
        agencyMemoProduct.setBlankOwner(this.tchReference);
        agencyMemoProduct.setAirlineCode(airlineNumber);
        agencyMemoProduct.setSystemNumber(systemNumber);
        agencyMemoProduct.setType(AgencyMemoProductType.ADM);
        agencyMemoProduct.setSupplier(this.tchReference);
        agencyMemoProduct.setAgency(this.agencyContainer.toReference());
        agencyMemoProduct.setIssueDate(this.issueDate);
        agencyMemoProduct.setAcceptDate(this.issueDate);
        agencyMemoProduct.setSourceReportDate(this.issueDate);
        agencyMemoProduct.setTargetReportDate(this.issueDate);
        agencyMemoProduct.setIncludeToReport(true);
        Money amount = new Money();
        amount.setValue(BigDecimal.valueOf(value));
        amount.setCurrency("RUB");
        AgencyMemoProductEntry entry01 = new AgencyMemoProductEntry();
        entry01.setProduct(agencyMemoProduct);
        entry01.setType(entryType);
        entry01.setAssociationType(AgencyMemoProductEntryAssociationType.PRODUCT);
        entry01.setRelatedProductNumber("001");
        entry01.setAmount(amount);
        entry01.setEquivalentAmount(amount.getValue());
        agencyMemoProduct.getEntries().add(entry01);
        AgencyMemoProductItemGroup itemGroup = new AgencyMemoProductItemGroup();
        itemGroup.setType(entryType);
        itemGroup.setAmount(amount);
        itemGroup.setEquivalentAmount(amount.getValue());
        itemGroup.getEntries().add(entry01);
        agencyMemoProduct.getItemGroups().add(itemGroup);
        AgencyMemoProductRelatedProductGroup relatedProductGroup = new AgencyMemoProductRelatedProductGroup();
        relatedProductGroup.setAssociationType(AgencyMemoProductEntryAssociationType.PRODUCT);
        relatedProductGroup.setRelatedProductNumber("001");
        relatedProductGroup.getEntries().add(entry01);
        agencyMemoProduct.getRelatedProductGroups().add(relatedProductGroup);
        agencyMemoProduct.getRelatedProductGroups().add(relatedProductGroup);
        reservation.getProducts().add(agencyMemoProduct);
        bookingFile.getReservations().add(reservation);
        this.save(bookingFileContainer);
        return agencyMemoProduct;
    }

    static final class TestTchReportRenderHandler
    extends TchReportRenderHandler {
        TestTchReportRenderHandler() {
        }

        protected File getTemplateFile() {
            return new File("./plugins/com.gridnine.xtrip.common.reports/templates/salesreports/TCH.xls");
        }

        protected void addSubsidizedRegistries(EntityContainer<ReportDocument> result, Map<String, Object> context) throws Exception {
            List batches = (List)context.get("key-subsidized-registry-batches");
            if (batches != null) {
                List files = new TchSubsidizedReportRegistryRenderHandler(){

                    protected File getTemplateFile() {
                        return new File("./plugins/com.gridnine.xtrip.common.reports/templates/salesreports/TCHSubsidized.xls");
                    }
                }.getRegistries(batches, (ReportParameters)context.get("key-report-params"), (String)context.get("key-tch-agency-code"));
                ((ReportDocument)result.getEntity()).getFiles().addAll(files);
            }
        }

        protected void addAdditionalRegistries(EntityContainer<ReportDocument> result, Map<String, Object> context) throws Exception {
            TchReportRenderHandler.AdditionalRegistryRenderHandler additionalRegistryRenderHandler = new TchReportRenderHandler.AdditionalRegistryRenderHandler(){

                protected File getTemplateFile() {
                    return new File("./plugins/com.gridnine.xtrip.common.reports/templates/salesreports/TCH-additional-registries.xls");
                }
            };
            EntityContainer ctr = additionalRegistryRenderHandler.renderReport(context);
            List batches = (List)context.get("key-summary-data");
            if (batches == null || batches.size() == 0) {
                return;
            }
            ReportDocument doc = (ReportDocument)ctr.getEntity();
            ReportFile reportFile = (ReportFile)doc.getFiles().get(0);
            reportFile.setTitle(TchReportRenderHandler.getReportTitle(context, (String)Messages.TchReportRenderHandler_additional_registries_reportTitle));
            reportFile.setName(String.format("TCH-additional-registries-%s.xls", TchReportRenderHandler.getReportPeriod(context)));
            ((ReportDocument)result.getEntity()).getFiles().add(reportFile);
        }
    }
}

